package org.beast.data.domain;

import lombok.Data;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class ObjectCursor implements Streamable<ObjectCursor.PropertyCursor>, Serializable {

    private final List<PropertyCursor> cursors;

    public ObjectCursor(List<PropertyCursor> cursors) {
        this.cursors = cursors;
    }
    public ObjectCursor(PropertyCursor... cursors) {
        this.cursors = List.of(cursors);
    }

    @NonNull
    @Override
    public Iterator<PropertyCursor> iterator() {
        return cursors.iterator();
    }

    @Nullable
    public PropertyCursor getCursorFor(int index) {
        return cursors.get(index);
    }

    @Nullable
    public PropertyCursor getCursorFor(String property) {
        for (var cursor : this) {
            if (cursor.getProperty().equals(property)) {
                return cursor;
            }
        }
        return null;
    }

    @Data
    public static final class PropertyCursor {

        private String property;

        private Object rawValue;

        private Sort.Direction direction;
    }

}
