package org.beast.data.converter;

import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

/**
 * @see org.springframework.data.convert.Jsr310Converters
 */
public class TimeConverters {

    public static List<?> getConvertersToRegister() {
        List<Object> converters = new ArrayList<>();
        converters.add(StringToInstantConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public enum StringToInstantConverter implements Converter<String, Instant> {
        INSTANCE;

        @Override
        public Instant convert(@NonNull String source) {
            try {
                long value = Long.parseLong(source);
                return Instant.ofEpochMilli(value);
            } catch (NumberFormatException ignore) { }
            return Instant.parse(source);
        }
    }
}
