package org.beast.data.message;

/*
 * web passport
 * 通用错误代码
 * 错误代码范围  10000 < CODE < 110000
 */
public enum StandardErrors implements MessageErrorOwner {

    //服务不可达
    SERVICE_UNAVAILABLE(),

    //服务繁忙
    SERVICE_BUSY(),

    //服务内部错误
    SERVICE_INTERNAL_ERROR(),

    PARAMETER_MISSING,
    //参数类型不匹配
    PARAMETER_TYPE_MISMATCH(),

    //未知错误，可能前端协议错误
    UNKNOWN_ERROR(),

    //参数错误
    BAD_PARAMETER(),

    //未经认证
    UNAUTHENTICATED(),

    //未经授权
    UNAUTHORIZED(),

    //禁止403
    FORBIDDEN(),

    //404
    NOT_FOUND,

    //不存在
    MISSING,

    //HTTP级别错误 accept不可处理
    HTTP_MEDIA_TYPE_NOT_ACCEPTABLE,
    //HTTP级别错误 请求方法不支持
    HTTP_REQUEST_METHOD_NOT_SUPPORTED,

    ;
    private String errorCode;

    StandardErrors() {
        this.errorCode = this.name();
    }

    StandardErrors(String code) {
        this.errorCode = code;
    }

    public static StandardErrors valueOfMessage(String message) {
        return StandardErrors.valueOf(message);
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

}
