/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.beast.data.domain.Cursor;
import org.springframework.lang.NonNull;

public class OrdersCursor
implements Cursor,
Comparable<OrdersCursor> {
    private final List<String> orders;
    private final String rawValue;

    public OrdersCursor(List<String> orders) {
        this.orders = orders;
        this.rawValue = OrdersCursor.getRawValueFromOrders(orders);
    }

    public OrdersCursor(String rawValue) {
        this.rawValue = rawValue;
        this.orders = OrdersCursor.getOrdersFromRawValues(rawValue);
    }

    public static String getRawValueFromOrders(List<String> orders) {
        ArrayList<String> encodeValues = new ArrayList<String>();
        for (String value : orders) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);
        }
        return Joiner.on((String)".").join(encodeValues);
    }

    public static List<String> getOrdersFromRawValues(String rawValue) {
        ArrayList<String> values = new ArrayList<String>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on((String)".").split((CharSequence)rawValue)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    @JsonCreator
    public static OrdersCursor ofNullable(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return new OrdersCursor(rawValue);
    }

    public List<String> getOrders() {
        return this.orders;
    }

    @Override
    public String getValue() {
        return this.rawValue;
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public int compareTo(@NonNull OrdersCursor o) {
        return this.getValue().compareTo(o.getValue());
    }
}

