/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.beast.data.domain.SimpleMoney;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;

public class MoneyConverters {
    public static List<?> getConvertersToRegister() {
        ArrayList<Enum> converters = new ArrayList<Enum>();
        converters.add(SimpleMoneyToLongConvert.INSTANCE);
        converters.add(LongToSimpleMoneyConvert.INSTANCE);
        converters.add(IntegerToSimpleMoneyConvert.INSTANCE);
        converters.add(StringToSimpleMoneyConvert.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum SimpleMoneyToLongConvert implements Converter<SimpleMoney, Long>
    {
        INSTANCE;


        public Long convert(@NonNull SimpleMoney source) {
            BigDecimal value = source.getBigDecimal().movePointRight(2);
            if (value.scale() != 0) {
                throw new ArithmeticException(source + " can not be represented by this class, scale > 2");
            }
            return value.longValue();
        }
    }

    @ReadingConverter
    public static enum LongToSimpleMoneyConvert implements Converter<Long, SimpleMoney>
    {
        INSTANCE;


        public SimpleMoney convert(@NonNull Long source) {
            BigDecimal value = new BigDecimal(source).movePointLeft(2);
            return SimpleMoney.of(value);
        }
    }

    @ReadingConverter
    public static enum IntegerToSimpleMoneyConvert implements Converter<Integer, SimpleMoney>
    {
        INSTANCE;


        public SimpleMoney convert(@NonNull Integer source) {
            BigDecimal value = new BigDecimal(source).movePointLeft(2);
            return SimpleMoney.of(value);
        }
    }

    @ReadingConverter
    public static enum StringToSimpleMoneyConvert implements Converter<String, SimpleMoney>
    {
        INSTANCE;


        public SimpleMoney convert(@NonNull String source) {
            BigDecimal value = new BigDecimal(source);
            return SimpleMoney.of(value);
        }
    }
}

