/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.message;

import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.beast.data.message.ErrorException;
import org.beast.data.message.ErrorInfo;
import org.beast.data.message.ErrorSupplier;

public class ReturnResult<T>
implements Serializable {
    private T data;
    private ErrorInfo error;

    public ReturnResult() {
    }

    public ReturnResult(T data, ErrorInfo error) {
        this.data = data;
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public boolean isPresent() {
        return this.data != null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.data != null) {
            action.accept(this.data);
        }
    }

    public T orElse(T other) {
        if (this.hasError()) {
            return other;
        }
        return this.data;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        if (this.hasError()) {
            return supplier.get();
        }
        return this.data;
    }

    public T orElseThrow() {
        if (this.hasError()) {
            throw new ErrorException(this.error);
        }
        return this.data;
    }

    public <X extends Throwable> T orElseThrow(ErrorSupplier<X, ErrorInfo> exceptionSupplier) throws X {
        if (this.hasError()) {
            throw (Throwable)exceptionSupplier.get(this.getError());
        }
        return this.data;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.hasError()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.data;
    }

    public <O> ReturnResult<O> map(Function<T, O> converter) {
        return new ReturnResult<O>(converter.apply(this.data), this.error);
    }

    public String toString() {
        return "ReturnResult(data=" + this.getData() + ", error=" + this.getError() + ")";
    }

    public T getData() {
        return this.data;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }
}

