/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.domain;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

public class PageResult<T>
implements Page<T> {
    private List<T> rows = Collections.emptyList();
    private long total;

    public PageResult() {
    }

    public PageResult(List<T> rows, long total) {
        this.rows = rows;
        this.total = total;
    }

    public int getTotalPages() {
        throw new UnsupportedOperationException();
    }

    public long getTotalElements() {
        return this.total;
    }

    public int getNumber() {
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfElements() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<T> getContent() {
        return this.rows;
    }

    public boolean hasContent() {
        return this.rows.size() > 0;
    }

    @NonNull
    public Sort getSort() {
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean isLast() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Pageable nextPageable() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Pageable previousPageable() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <U> Page<U> map(@NonNull Function<? super T, ? extends U> converter) {
        return new PageResult(this.rows.stream().map(converter).collect(Collectors.toList()), this.total);
    }

    public Iterator<T> iterator() {
        return this.rows.iterator();
    }

    public List<T> getRows() {
        return this.rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        return this.getTotal() == other.getTotal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        return result;
    }

    public String toString() {
        return "PageResult(rows=" + this.getRows() + ", total=" + this.getTotal() + ")";
    }
}

