/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.message;

import java.io.Serializable;
import java.util.function.Supplier;
import org.beast.data.message.ErrorException;
import org.beast.data.message.ErrorInfo;
import org.beast.data.message.ErrorSupplier;

public class ReturnResult<T>
implements Serializable {
    private ErrorInfo error;
    private T data;

    public boolean hasError() {
        return this.error != null;
    }

    public T orElse(T other) {
        if (this.hasError()) {
            return other;
        }
        return this.data;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        if (this.hasError()) {
            return supplier.get();
        }
        return this.data;
    }

    public T orElseThrow() {
        if (this.hasError()) {
            throw new ErrorException(this.error);
        }
        return this.data;
    }

    public <X extends Throwable> T orElseThrow(ErrorSupplier<X, ErrorInfo> exceptionSupplier) throws X {
        if (this.hasError()) {
            throw (Throwable)exceptionSupplier.get(this.getError());
        }
        return this.data;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.hasError()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.data;
    }

    public String toString() {
        return "ReturnResult(error=" + this.getError() + ", data=" + this.getData() + ")";
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public T getData() {
        return this.data;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public void setData(T data) {
        this.data = data;
    }
}

