package org.beast.sleuth.web;

import brave.Span;
import brave.Tracer;
import org.beast.web.servlet.error.ErrorAttributesProvider;
import org.springframework.web.context.request.WebRequest;

import java.util.Map;

public class TraceErrorAttributesProvider implements ErrorAttributesProvider {

    private Tracer tracer;

    public TraceErrorAttributesProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Map<String, Object> apply(WebRequest webRequest) {

        Span span = tracer.currentSpan();
        String traceId = span.context().traceIdString();
//        TraceContext context = currentTraceContext.get();

//        String traceId = context.traceIdString();
        return Map.of("traceId", traceId);
    }
}
