package org.beast.sleuth.web;

import brave.Tracer;
import brave.propagation.CurrentTraceContext;
import org.beast.web.servlet.error.BeastErrorMvcAutoConfiguration;
import org.beast.web.servlet.error.ErrorAttributesProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

import javax.servlet.Servlet;

@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class})
@ConditionalOnBean(CurrentTraceContext.class)
@AutoConfigureBefore(BeastErrorMvcAutoConfiguration.class)
@AutoConfigureAfter(BraveAutoConfiguration.class)
public class TraceBeastErrorMvcAutoConfiguration {

    @Bean
    public ErrorAttributesProvider traceErrorAttributesProvider(Tracer tracer) {
        return new TraceErrorAttributesProvider(tracer);
    }

}
