package org.beast.cloud.grpc.discovery;


import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.netty.NettyChannelBuilder;
import org.beast.cloud.grpc.GRPCChannelFactory;
import org.beast.cloud.grpc.GRPCChannelProperties;
import org.beast.cloud.grpc.GRPCChannelsProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DiscoveryChannelFactory implements GRPCChannelFactory {

    private final GRPCChannelsProperties properties;

    private final DiscoveryClient client;

//    private final LoadBalancer.Factory loadBalancerFactory;

    private final List<ClientInterceptor> globalInterceptor;

    public DiscoveryChannelFactory(GRPCChannelsProperties properties,
                                   DiscoveryClient client,
//                                   LoadBalancer.Factory loadBalancerFactory,
                                   List<ClientInterceptor> globalInterceptor) {
        this.properties = properties;
        this.client = client;
//        this.loadBalancerFactory = loadBalancerFactory;
        this.globalInterceptor = Lists.newArrayList(globalInterceptor);
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        GRPCChannelProperties channelProperties = properties.getChannel(name);

        NettyChannelBuilder builder = NettyChannelBuilder.forTarget(name)
//                .loadBalancerFactory(loadBalancerFactory)
                .nameResolverFactory(new DiscoveryNameResolverProvider(client))
                .negotiationType(channelProperties.getNegotiationType());

        if (channelProperties.isEnableKeepAlive()) {
            builder.keepAliveWithoutCalls(channelProperties.isKeepAliveWithoutCalls())
                    .keepAliveTime(channelProperties.getKeepAliveTime(), TimeUnit.SECONDS)
                    .keepAliveTimeout(channelProperties.getKeepAliveTimeout(), TimeUnit.SECONDS);
        }
        if(channelProperties.getMaxInboundMessageSize() > 0) {
            builder.maxInboundMessageSize(channelProperties.getMaxInboundMessageSize());
        }
        Channel channel = builder.build();
        List<ClientInterceptor> interceptorList = Lists.newArrayList(globalInterceptor);
        if (Objects.nonNull(interceptors)) {
            interceptorList.addAll(interceptors);
        }
        return ClientInterceptors.intercept(channel, interceptorList);
    }


}
