package org.beast.cloud.grpc;

import com.google.common.collect.Maps;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Map;

@ConfigurationProperties(prefix = "beast.cloud.grpc")
public class GRPCChannelsProperties {

    @NestedConfigurationProperty
    private Map<String, GRPCChannelProperties> clients = Maps.newHashMap();

    public GRPCChannelProperties getChannel(String name) {
        GRPCChannelProperties properties = clients.get(name);
        if (properties == null) {
            properties = GRPCChannelProperties.DEFAULT;
        }
        return properties;
    }

}
