/*
 * Decompiled with CFR 0.152.
 */
package org.beast.cloud.grpc.discovery;

import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.context.event.EventListener;

public class DiscoveryNameResolver
extends NameResolver {
    private final String name;
    private final DiscoveryClient client;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private ScheduledExecutorService timerServiceHolder;
    private NameResolver.Listener listener;
    private volatile boolean resolving;
    private volatile boolean shutdown;
    private HeartbeatMonitor monitor = new HeartbeatMonitor();
    public final Runnable resolveRunnable = new Runnable(){
        private List<ServiceInstance> serviceInstances = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiscoveryNameResolver discoveryNameResolver = DiscoveryNameResolver.this;
            synchronized (discoveryNameResolver) {
                if (DiscoveryNameResolver.this.shutdown) {
                    return;
                }
                if (DiscoveryNameResolver.this.resolving) {
                    return;
                }
                DiscoveryNameResolver.this.resolving = true;
            }
            NameResolver.Listener savedListener = DiscoveryNameResolver.this.listener;
            try {
                List newServiceInstanceList;
                try {
                    newServiceInstanceList = DiscoveryNameResolver.this.client.getInstances(DiscoveryNameResolver.this.name);
                }
                catch (Exception e) {
                    savedListener.onError(Status.INVALID_ARGUMENT.withCause((Throwable)e));
                    DiscoveryNameResolver discoveryNameResolver2 = DiscoveryNameResolver.this;
                    synchronized (discoveryNameResolver2) {
                        DiscoveryNameResolver.this.resolving = false;
                    }
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)newServiceInstanceList)) {
                    if (this.isServiceInstanceListUpdate(newServiceInstanceList)) {
                        return;
                    }
                    this.serviceInstances = newServiceInstanceList;
                    List equivalentAddressGroups = this.serviceInstances.stream().map(new Function<ServiceInstance, EquivalentAddressGroup>(){

                        @Override
                        public EquivalentAddressGroup apply(ServiceInstance serviceInstance) {
                            return new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(serviceInstance.getHost(), serviceInstance.getPort()));
                        }
                    }).collect(Collectors.toList());
                    DiscoveryNameResolver.this.listener.onAddresses(equivalentAddressGroups, Attributes.EMPTY);
                } else {
                    savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)new RuntimeException("UNAVAILABLE: NameResolver '" + DiscoveryNameResolver.this.name + "' returned an empty list")));
                }
            }
            finally {
                DiscoveryNameResolver discoveryNameResolver3 = DiscoveryNameResolver.this;
                synchronized (discoveryNameResolver3) {
                    DiscoveryNameResolver.this.resolving = false;
                }
            }
        }

        private boolean isServiceInstanceListUpdate(List<ServiceInstance> newServiceInstances) {
            return CollectionUtils.isEqualCollection(newServiceInstances, this.serviceInstances, (Equator)new Equator<ServiceInstance>(){

                public boolean equate(ServiceInstance serviceInstance, ServiceInstance t1) {
                    return Objects.equals(serviceInstance.getHost(), t1.getHost()) && Objects.equals(serviceInstance.getPort(), t1.getPort());
                }

                public int hash(ServiceInstance serviceInstance) {
                    return serviceInstance.getPort();
                }
            });
        }
    };

    public DiscoveryNameResolver(String name, DiscoveryClient client, Attributes attributes, SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource) {
        this.name = name;
        this.client = client;
        this.timerServiceResource = timerServiceResource;
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            this.refresh();
        }
    }

    public String getServiceAuthority() {
        return this.name;
    }

    public void start(NameResolver.Listener listener) {
        this.listener = listener;
        this.timerServiceHolder = (ScheduledExecutorService)SharedResourceHolder.get(this.timerServiceResource);
        this.resolve();
    }

    public final synchronized void refresh() {
        if (this.listener != null) {
            this.resolve();
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.timerServiceHolder != null) {
            this.timerServiceHolder = (ScheduledExecutorService)SharedResourceHolder.release(this.timerServiceResource, (Object)this.timerServiceHolder);
        }
    }

    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.resolveRunnable.run();
    }
}

