/*
 * Decompiled with CFR 0.152.
 */
package org.beast.cloud.grpc;

import com.google.common.collect.Maps;
import io.grpc.Channel;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beast.cloud.grpc.GRPCChannelFactory;
import org.beast.cloud.grpc.GRPCClient;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class GRPCClientBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private Map<String, List<Class>> beansToProcess = Maps.newHashMap();
    @Autowired
    private GRPCChannelFactory channelFactory;

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        Class<?> clazz = beanClass;
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(GRPCClient.class)) continue;
                if (!this.beansToProcess.containsKey(beanName)) {
                    this.beansToProcess.put(beanName, new ArrayList());
                }
                this.beansToProcess.get(beanName).add(clazz);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        if (this.beansToProcess.containsKey(beanName)) {
            try {
                Object target = this.getTargetBean(bean);
                for (Class clazz : this.beansToProcess.get(beanName)) {
                    for (Field field : clazz.getDeclaredFields()) {
                        GRPCClient annotation = (GRPCClient)AnnotationUtils.getAnnotation((AnnotatedElement)field, GRPCClient.class);
                        if (!Objects.nonNull(annotation)) continue;
                        Channel channel = this.channelFactory.createChannel(annotation.value());
                        ReflectionUtils.makeAccessible((Field)field);
                        ReflectionUtils.setField((Field)field, (Object)target, (Object)channel);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pvs;
    }

    private Object getTargetBean(Object bean) throws Exception {
        Object target = bean;
        while (AopUtils.isAopProxy((Object)target)) {
            target = ((Advised)target).getTargetSource().getTarget();
        }
        return target;
    }
}

