/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.aspectj.bridge.IMessage;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationFieldTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;

public class ExactAnnotationFieldTypePattern
extends ExactAnnotationTypePattern {
    UnresolvedType annotationType;
    private ResolvedMember field;

    public ExactAnnotationFieldTypePattern(ExactAnnotationTypePattern p, String formalName) {
        super(formalName);
        this.annotationType = p.annotationType;
        this.copyLocationFrom(p);
    }

    public ExactAnnotationFieldTypePattern(UnresolvedType annotationType, String formalName) {
        super(formalName);
        this.annotationType = annotationType;
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        if (this.resolved) {
            return this;
        }
        this.resolved = true;
        FormalBinding formalBinding = scope.lookupFormal(this.formalName);
        if (formalBinding == null) {
            scope.message(IMessage.ERROR, this, "When using @annotation(<annotationType>(<annotationField>)), <annotationField> must be bound");
            return this;
        }
        this.annotationType = scope.getWorld().resolve(this.annotationType, true);
        if (ResolvedType.isMissing(this.annotationType)) {
            int lastDot;
            String cleanname = this.annotationType.getName();
            UnresolvedType type = null;
            while (ResolvedType.isMissing(type = scope.lookupType(cleanname, this)) && (lastDot = cleanname.lastIndexOf(46)) != -1) {
                cleanname = cleanname.substring(0, lastDot) + "$" + cleanname.substring(lastDot + 1);
            }
            this.annotationType = scope.getWorld().resolve(type, true);
        }
        this.verifyIsAnnotationType((ResolvedType)this.annotationType, scope);
        if (!formalBinding.getType().resolve(scope.getWorld()).isEnum()) {
            scope.message(IMessage.ERROR, this, "The field within the annotation must be an Enum. '" + formalBinding.getType() + "' is not an Enum (compiler limitation)");
        }
        this.bindingPattern = true;
        ReferenceType theAnnotationType = (ReferenceType)this.annotationType;
        ResolvedMember[] annotationFields = theAnnotationType.getDeclaredMethods();
        this.field = null;
        for (int i = 0; i < annotationFields.length; ++i) {
            ResolvedMember resolvedMember = annotationFields[i];
            if (!resolvedMember.getReturnType().equals(formalBinding.getType())) continue;
            if (this.field != null) {
                scope.message(IMessage.ERROR, this, "The field type '" + formalBinding.getType() + "' is ambiguous for annotation type '" + theAnnotationType.getName() + "'");
            }
            this.field = resolvedMember;
        }
        if (this.field == null) {
            scope.message(IMessage.ERROR, this, "No field of type '" + formalBinding.getType() + "' exists on annotation type '" + theAnnotationType.getName() + "'");
        }
        BindingAnnotationFieldTypePattern binding = new BindingAnnotationFieldTypePattern(formalBinding.getType(), formalBinding.getIndex(), theAnnotationType);
        binding.copyLocationFrom(this);
        bindings.register(binding, scope);
        binding.resolveBinding(scope.getWorld());
        return binding;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(9);
        s.writeUTF(this.formalName);
        this.annotationType.write(s);
        this.writeLocation(s);
    }

    public static AnnotationTypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        String formalName = s.readUTF();
        UnresolvedType annotationType = UnresolvedType.read(s);
        ExactAnnotationFieldTypePattern ret = new ExactAnnotationFieldTypePattern(annotationType, formalName);
        ret.readLocation(context, s);
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExactAnnotationFieldTypePattern)) {
            return false;
        }
        ExactAnnotationFieldTypePattern other = (ExactAnnotationFieldTypePattern)obj;
        return other.annotationType.equals(this.annotationType) && other.field.equals(this.field) && other.formalName.equals(this.formalName);
    }

    public int hashCode() {
        int hashcode = this.annotationType.hashCode();
        hashcode = hashcode * 37 + this.field.hashCode();
        hashcode = hashcode * 37 + this.formalName.hashCode();
        return hashcode;
    }

    public FuzzyBoolean fastMatches(AnnotatedElement annotated) {
        throw new BCException("unimplemented");
    }

    public UnresolvedType getAnnotationType() {
        throw new BCException("unimplemented");
    }

    public Map getAnnotationValues() {
        throw new BCException("unimplemented");
    }

    public ResolvedType getResolvedAnnotationType() {
        throw new BCException("unimplemented");
    }

    public FuzzyBoolean matches(AnnotatedElement annotated, ResolvedType[] parameterAnnotations) {
        throw new BCException("unimplemented");
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        throw new BCException("unimplemented");
    }

    public FuzzyBoolean matchesRuntimeType(AnnotatedElement annotated) {
        throw new BCException("unimplemented");
    }

    public AnnotationTypePattern parameterizeWith(Map typeVariableMap, World w) {
        throw new BCException("unimplemented");
    }

    public void resolve(World world) {
        throw new BCException("unimplemented");
    }

    public String toString() {
        if (!this.resolved && this.formalName != null) {
            return this.formalName;
        }
        StringBuffer ret = new StringBuffer();
        ret.append("@").append(this.annotationType.toString());
        ret.append("(").append(this.formalName).append(")");
        return ret.toString();
    }
}

