/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.state;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.state.RedisKeyValueState;
import org.apache.storm.state.DefaultStateSerializer;
import org.apache.storm.state.Serializer;
import org.apache.storm.state.State;
import org.apache.storm.state.StateProvider;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisKeyValueStateProvider
implements StateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisKeyValueStateProvider.class);

    public State newState(String namespace, Map stormConf, TopologyContext context) {
        try {
            return this.getRedisKeyValueState(namespace, this.getStateConfig(stormConf));
        }
        catch (Exception ex) {
            LOG.error("Error loading config from storm conf {}", (Object)stormConf);
            throw new RuntimeException(ex);
        }
    }

    StateConfig getStateConfig(Map stormConf) throws Exception {
        StateConfig stateConfig = null;
        String providerConfig = null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        if (stormConf.containsKey("topology.state.provider.config")) {
            providerConfig = (String)stormConf.get("topology.state.provider.config");
            stateConfig = (StateConfig)mapper.readValue(providerConfig, StateConfig.class);
        } else {
            stateConfig = new StateConfig();
        }
        return stateConfig;
    }

    private RedisKeyValueState getRedisKeyValueState(String namespace, StateConfig config) throws Exception {
        return new RedisKeyValueState(namespace, this.getJedisPoolConfig(config), this.getKeySerializer(config), this.getValueSerializer(config));
    }

    private Serializer getKeySerializer(StateConfig config) throws Exception {
        DefaultStateSerializer serializer = null;
        if (config.keySerializerClass != null) {
            Class<?> klass = Class.forName(config.keySerializerClass);
            serializer = (Serializer)klass.newInstance();
        } else {
            serializer = config.keyClass != null ? new DefaultStateSerializer(Collections.singletonList(Class.forName(config.keyClass))) : new DefaultStateSerializer();
        }
        return serializer;
    }

    private Serializer getValueSerializer(StateConfig config) throws Exception {
        DefaultStateSerializer serializer = null;
        if (config.valueSerializerClass != null) {
            Class<?> klass = Class.forName(config.valueSerializerClass);
            serializer = (Serializer)klass.newInstance();
        } else {
            serializer = config.valueClass != null ? new DefaultStateSerializer(Collections.singletonList(Class.forName(config.valueClass))) : new DefaultStateSerializer();
        }
        return serializer;
    }

    private JedisPoolConfig getJedisPoolConfig(StateConfig config) {
        return config.jedisPoolConfig != null ? config.jedisPoolConfig : new JedisPoolConfig.Builder().build();
    }

    static class StateConfig {
        String keyClass;
        String valueClass;
        String keySerializerClass;
        String valueSerializerClass;
        JedisPoolConfig jedisPoolConfig;

        StateConfig() {
        }

        public String toString() {
            return "StateConfig{keyClass='" + this.keyClass + '\'' + ", valueClass='" + this.valueClass + '\'' + ", keySerializerClass='" + this.keySerializerClass + '\'' + ", valueSerializerClass='" + this.valueSerializerClass + '\'' + ", jedisPoolConfig=" + this.jedisPoolConfig + '}';
        }
    }
}

