/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.io.Serializable;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.TransportAddresses;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public final class StormElasticSearchClient
implements Serializable {
    private final EsConfig esConfig;

    public StormElasticSearchClient(EsConfig esConfig) {
        this.esConfig = esConfig;
    }

    public Client construct() {
        Settings settings = this.esConfig.toBasicSettings();
        TransportClient transportClient = new TransportClient(settings);
        this.addTransportAddresses(transportClient);
        return transportClient;
    }

    private void addTransportAddresses(TransportClient transportClient) {
        TransportAddresses transportAddresses = this.esConfig.getTransportAddresses();
        for (InetSocketTransportAddress transportAddress : transportAddresses) {
            transportClient.addTransportAddress((TransportAddress)transportAddress);
        }
    }
}

