/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.util.Collection;
import java.util.List;
import org.apache.storm.elasticsearch.ElasticsearchGetRequest;
import org.apache.storm.elasticsearch.EsLookupResultOutput;
import org.apache.storm.elasticsearch.bolt.AbstractEsBolt;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.base.Preconditions;

public class EsLookupBolt
extends AbstractEsBolt {
    private final ElasticsearchGetRequest getRequest;
    private final EsLookupResultOutput output;

    public EsLookupBolt(EsConfig esConfig, ElasticsearchGetRequest getRequest, EsLookupResultOutput output) {
        super(esConfig);
        Preconditions.checkNotNull((Object)getRequest);
        Preconditions.checkNotNull((Object)output);
        this.getRequest = getRequest;
        this.output = output;
    }

    @Override
    public void execute(Tuple tuple) {
        try {
            Collection<Values> values = this.lookupValuesInEs(tuple);
            this.tryEmitAndAck(values, tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    private Collection<Values> lookupValuesInEs(Tuple tuple) {
        GetRequest request = this.getRequest.extractFrom((ITuple)tuple);
        GetResponse response = (GetResponse)client.get(request).actionGet();
        return this.output.toValues(response);
    }

    private void tryEmitAndAck(Collection<Values> values, Tuple tuple) {
        for (Values value : values) {
            this.collector.emit(tuple, (List)value);
        }
        this.collector.ack(tuple);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        outputFieldsDeclarer.declare(this.output.fields());
    }
}

