/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.util.Map;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.StormElasticSearchClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.annotations.VisibleForTesting;
import org.elasticsearch.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEsBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEsBolt.class);
    protected static Client client;
    protected OutputCollector collector;
    private EsConfig esConfig;

    public AbstractEsBolt(EsConfig esConfig) {
        Preconditions.checkNotNull((Object)esConfig);
        this.esConfig = esConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        try {
            this.collector = outputCollector;
            Class<AbstractEsBolt> clazz = AbstractEsBolt.class;
            synchronized (AbstractEsBolt.class) {
                if (client == null) {
                    client = new StormElasticSearchClient(this.esConfig).construct();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOG.warn("unable to initialize EsBolt ", (Throwable)e);
        }
        {
            return;
        }
    }

    public abstract void execute(Tuple var1);

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    @VisibleForTesting
    static Client getClient() {
        return client;
    }

    @VisibleForTesting
    static void replaceClient(Client client) {
        AbstractEsBolt.client = client;
    }
}

