/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.apache.pluto.driver.services.impl.resource.ResourceConfig;
import org.apache.pluto.driver.services.impl.resource.ResourceConfigReader;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.apache.pluto.driver.services.portal.admin.RenderConfigAdminService;

public class RenderConfigServiceImpl
implements RenderConfigService,
RenderConfigAdminService {
    private ResourceConfig config;

    public void init(ServletContext ctx) {
        try {
            InputStream in = ctx.getResourceAsStream("/WEB-INF/pluto-portal-driver-config.xml");
            this.config = ResourceConfigReader.getFactory().parse(in);
        }
        catch (Exception e) {
            throw new DriverConfigurationException((Throwable)e);
        }
    }

    public void destroy() {
        this.config = null;
    }

    public String getPortalName() {
        return this.config.getPortalName();
    }

    public String getPortalVersion() {
        return this.config.getPortalVersion();
    }

    public String getContainerName() {
        return this.config.getContainerName();
    }

    public Set getSupportedPortletModes() {
        return this.config.getSupportedPortletModes();
    }

    public Set getSupportedWindowStates() {
        return this.config.getSupportedWindowStates();
    }

    public List getPages() {
        return this.config.getRenderConfig().getPages();
    }

    public PageConfig getDefaultPage() {
        return this.config.getRenderConfig().getPageConfig(null);
    }

    public PageConfig getPage(String id) {
        return this.config.getRenderConfig().getPageConfig(id);
    }

    public void addPage(PageConfig pageConfig) {
        this.config.getRenderConfig().addPage(pageConfig);
    }

    public void removePage(PageConfig pageConfig) {
        this.config.getRenderConfig().removePage(pageConfig);
    }
}

