/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util;

import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$util$StringManager == null ? (class$org$apache$pluto$util$StringManager = StringManager.class$("org.apache.pluto.util.StringManager")) : class$org$apache$pluto$util$StringManager));
    private ResourceBundle bundle;
    private final String packageName;
    private static Hashtable managers = new Hashtable();
    static /* synthetic */ Class class$org$apache$pluto$util$StringManager;

    private StringManager(String packageName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("String Manager Created for package: " + packageName));
        }
        this.packageName = packageName;
        String bundleName = packageName + ".LocalStrings";
        try {
            this.bundle = ResourceBundle.getBundle(bundleName);
            return;
        }
        catch (MissingResourceException ex) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                try {
                    this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
                    return;
                }
                catch (MissingResourceException ex2) {
                    // empty catch block
                }
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            System.out.println("Can't find resource " + bundleName + " " + cl);
            if (cl instanceof URLClassLoader) {
                System.out.println(((URLClassLoader)cl).getURLs());
            }
            return;
        }
    }

    public String getString(String key) {
        return MessageFormat.format(this.getStringInternal(key), null);
    }

    protected String getStringInternal(String key) {
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        String str = null;
        if (this.bundle == null) {
            return key;
        }
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            String name = null;
            name = this.packageName == null ? "unknown" : this.packageName;
            str = "Cannot find message in the ResourceBundle associated with key '" + key + "' " + "(package " + name + ")";
            LOG.warn((Object)str, (Throwable)mre);
        }
        return str;
    }

    public String getString(String key, Object[] args) {
        String iString = null;
        String value = this.getStringInternal(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[").append(i).append("]=").append(args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

