/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.XMLMetaDataParser;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    public static final String SPEC_JPA = "jpa";
    public static final String ALIAS_EJB = "ejb";
    public static final String RSRC_GLOBAL = "META-INF/openjpa.xml";
    public static final String RSRC_DEFAULT = "META-INF/persistence.xml";
    private static final Localizer _loc = Localizer.forPackage(PersistenceProductDerivation.class);

    public void putBrokerFactoryAliases(Map m) {
    }

    public int getType() {
        return 0;
    }

    public void validate() throws Exception {
        AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(EntityManagerFactory.class));
    }

    public boolean beforeConfigurationLoad(Configuration c) {
        if (!(c instanceof OpenJPAConfigurationImpl)) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setAlias(ALIAS_EJB, PersistenceMetaDataFactory.class.getName());
        conf.metaFactoryPlugin.setAlias(SPEC_JPA, PersistenceMetaDataFactory.class.getName());
        conf.addValue((Value)new EntityManagerFactoryValue());
        return true;
    }

    public boolean afterSpecificationSet(Configuration c) {
        if (!(c instanceof OpenJPAConfigurationImpl) || !SPEC_JPA.equals(((OpenJPAConfiguration)c).getSpecification())) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setDefault(SPEC_JPA);
        conf.metaFactoryPlugin.setString(SPEC_JPA);
        conf.lockManagerPlugin.setDefault("version");
        conf.lockManagerPlugin.setString("version");
        conf.nontransactionalWrite.setDefault("true");
        conf.nontransactionalWrite.set(true);
        return true;
    }

    public ConfigurationProvider load(PersistenceUnitInfo pinfo, Map m) throws IOException {
        PersistenceUnitInfoImpl impl;
        if (pinfo == null) {
            return null;
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        cp.addProperties(PersistenceUnitInfoImpl.toOpenJPAProperties(pinfo));
        cp.addProperties(m);
        if (pinfo instanceof PersistenceUnitInfoImpl && (impl = (PersistenceUnitInfoImpl)pinfo).getPersistenceXmlFileUrl() != null) {
            cp.setSource(impl.getPersistenceXmlFileUrl().toString());
        }
        return cp;
    }

    public ConfigurationProvider load(String rsrc, String name, Map m) throws IOException {
        ConfigurationProviderImpl cp;
        Boolean ret;
        boolean explicit;
        boolean bl = explicit = !StringUtils.isEmpty((String)rsrc);
        if (!explicit) {
            rsrc = RSRC_DEFAULT;
        }
        if ((ret = this.load(cp = new ConfigurationProviderImpl(), rsrc, name, m, null, explicit)) != null) {
            return ret != false ? cp : null;
        }
        if (explicit) {
            return null;
        }
        PersistenceUnitInfoImpl pinfo = new PersistenceUnitInfoImpl();
        pinfo.fromUserProperties(m);
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        return cp;
    }

    public ConfigurationProvider load(String rsrc, String anchor, ClassLoader loader) throws IOException {
        if (rsrc != null && !rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, true) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public ConfigurationProvider load(File file, String anchor) throws IOException {
        if (!file.getName().endsWith(".xml")) {
            return null;
        }
        ConfigurationParser parser = new ConfigurationParser(null);
        parser.parse(file);
        return this.load(this.findUnit(parser.getResults(), anchor, null), null);
    }

    public ConfigurationProvider loadGlobals(ClassLoader loader) throws IOException {
        int idx;
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        String rsrc = null;
        for (int i = 0; i < prefixes.length && StringUtils.isEmpty(rsrc); ++i) {
            rsrc = (String)AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction((String)(prefixes[i] + ".properties")));
        }
        boolean explicit = !StringUtils.isEmpty(rsrc);
        String anchor = null;
        int n = idx = !explicit ? -1 : rsrc.lastIndexOf(35);
        if (idx != -1) {
            if (idx < rsrc.length() - 1) {
                anchor = rsrc.substring(idx + 1);
            }
            rsrc = rsrc.substring(0, idx);
        }
        if (StringUtils.isEmpty((String)rsrc)) {
            rsrc = RSRC_GLOBAL;
        } else if (!rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, explicit) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public ConfigurationProvider loadDefaults(ClassLoader loader) throws IOException {
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, RSRC_DEFAULT, null, null, loader, false) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    private Boolean load(ConfigurationProviderImpl cp, String rsrc, String name, Map m, ClassLoader loader, boolean explicit) throws IOException {
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        Enumeration urls = null;
        try {
            urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)rsrc));
            if (!urls.hasMoreElements()) {
                if (!rsrc.startsWith("META-INF")) {
                    urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)("META-INF/" + rsrc)));
                }
                if (!urls.hasMoreElements()) {
                    return null;
                }
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        ConfigurationParser parser = new ConfigurationParser(m);
        PersistenceUnitInfoImpl pinfo = this.parseResources(parser, urls, name, loader);
        if (pinfo == null) {
            if (!explicit) {
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("missing-xml-config", (Object)rsrc, (Object)String.valueOf(name)).getMessage(), ((Object)((Object)this)).getClass().getName(), rsrc);
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) {
            if (!explicit) {
                PersistenceProductDerivation.warnUnknownProvider(pinfo);
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("unknown-provider", (Object)rsrc, (Object)name, (Object)pinfo.getPersistenceProviderClassName()).getMessage(), ((Object)((Object)this)).getClass().getName(), rsrc);
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        cp.setSource(pinfo.getPersistenceXmlFileUrl().toString());
        return Boolean.TRUE;
    }

    private PersistenceUnitInfoImpl parseResources(ConfigurationParser parser, Enumeration<URL> urls, String name, ClassLoader loader) throws IOException {
        ArrayList<PersistenceUnitInfoImpl> pinfos = new ArrayList<PersistenceUnitInfoImpl>();
        for (URL url : Collections.list(urls)) {
            parser.parse(url);
            pinfos.addAll(parser.getResults());
        }
        return this.findUnit(pinfos, name, loader);
    }

    private PersistenceUnitInfoImpl findUnit(List<PersistenceUnitInfoImpl> pinfos, String name, ClassLoader loader) {
        PersistenceUnitInfoImpl ojpa = null;
        for (PersistenceUnitInfoImpl pinfo : pinfos) {
            if (name != null) {
                if (!name.equals(pinfo.getPersistenceUnitName())) continue;
                return pinfo;
            }
            if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) continue;
            if (StringUtils.isEmpty((String)pinfo.getPersistenceUnitName())) {
                return pinfo;
            }
            if (ojpa != null) continue;
            ojpa = pinfo;
        }
        return ojpa;
    }

    private static boolean isOpenJPAPersistenceProvider(PersistenceUnitInfo pinfo, ClassLoader loader) {
        String provider = pinfo.getPersistenceProviderClassName();
        if (StringUtils.isEmpty((String)provider) || PersistenceProviderImpl.class.getName().equals(provider)) {
            return true;
        }
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        try {
            if (PersistenceProviderImpl.class.isAssignableFrom(Class.forName(provider, false, loader))) {
                return true;
            }
        }
        catch (Throwable t) {
            PersistenceProductDerivation.log(_loc.get("unloadable-provider", (Object)provider, (Object)t).getMessage());
            return false;
        }
        return false;
    }

    private static void warnUnknownProvider(PersistenceUnitInfo pinfo) {
        PersistenceProductDerivation.log(_loc.get("unrecognized-provider", (Object)pinfo.getPersistenceProviderClassName()).getMessage());
    }

    private static void log(String msg) {
        System.err.println(msg);
    }

    public static class ConfigurationParser
    extends XMLMetaDataParser {
        private final Map _map;
        private PersistenceUnitInfoImpl _info = null;
        private URL _source = null;

        public ConfigurationParser(Map map) {
            this._map = map;
            this.setCaching(false);
            this.setValidating(true);
            this.setParseText(true);
        }

        public void parse(URL url) throws IOException {
            this._source = url;
            super.parse(url);
        }

        public void parse(File file) throws IOException {
            this._source = file.toURL();
            super.parse(file);
        }

        protected Object getSchemaSource() {
            return ((Object)((Object)this)).getClass().getResourceAsStream("persistence-xsd.rsrc");
        }

        protected void reset() {
            super.reset();
            this._info = null;
            this._source = null;
        }

        protected boolean startElement(String name, Attributes attrs) throws SAXException {
            if (this.currentDepth() == 1) {
                this.startPersistenceUnit(attrs);
            } else if (this.currentDepth() == 3 && "property".equals(name)) {
                this._info.setProperty(attrs.getValue("name"), attrs.getValue("value"));
            }
            return true;
        }

        protected void endElement(String name) throws SAXException {
            if (this.currentDepth() == 1) {
                this._info.fromUserProperties(this._map);
                this.addResult(this._info);
            }
            if (this.currentDepth() != 2) {
                return;
            }
            switch (name.charAt(0)) {
                case 'c': {
                    this._info.addManagedClassName(this.currentText());
                }
                case 'e': {
                    this._info.setExcludeUnlistedClasses("true".equalsIgnoreCase(this.currentText()));
                    break;
                }
                case 'j': {
                    if ("jta-data-source".equals(name)) {
                        this._info.setJtaDataSourceName(this.currentText());
                        break;
                    }
                    try {
                        this._info.addJarFileName(this.currentText());
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw this.getException(iae.getMessage());
                    }
                }
                case 'm': {
                    this._info.addMappingFileName(this.currentText());
                    break;
                }
                case 'n': {
                    this._info.setNonJtaDataSourceName(this.currentText());
                    break;
                }
                case 'p': {
                    if (!"provider".equals(name)) break;
                    this._info.setPersistenceProviderClassName(this.currentText());
                }
            }
        }

        private void startPersistenceUnit(Attributes attrs) throws SAXException {
            this._info = new PersistenceUnitInfoImpl();
            this._info.setPersistenceUnitName(attrs.getValue("name"));
            String val = attrs.getValue("transaction-type");
            if (val == null) {
                this._info.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                this._info.setTransactionType(Enum.valueOf(PersistenceUnitTransactionType.class, val));
            }
            if (this._source != null) {
                this._info.setPersistenceXmlFileUrl(this._source);
            }
        }
    }

    public static class ConfigurationProviderImpl
    extends MapConfigurationProvider {
        private String _source;

        public ConfigurationProviderImpl() {
        }

        public ConfigurationProviderImpl(Map props) {
            super(props);
        }

        public void setSource(String source) {
            this._source = source;
        }

        public void setInto(Configuration conf) {
            if (conf instanceof OpenJPAConfiguration) {
                OpenJPAConfiguration oconf = (OpenJPAConfiguration)conf;
                oconf.setSpecification(PersistenceProductDerivation.SPEC_JPA);
                String orig = oconf.getMetaDataFactory();
                if (!StringUtils.isEmpty((String)orig)) {
                    String key = ProductDerivations.getConfigurationKey((String)"MetaDataFactory", (Map)this.getProperties());
                    Object override = this.getProperties().get(key);
                    if (override instanceof String) {
                        this.addProperty(key, Configurations.combinePlugins((String)orig, (String)((String)override)));
                    }
                }
            }
            super.setInto(conf, null);
            Log log = conf.getConfigurationLog();
            if (log.isTraceEnabled()) {
                String src = this._source == null ? "?" : this._source;
                log.trace((Object)_loc.get("conf-load", (Object)src, (Object)this.getProperties()));
            }
        }
    }
}

