/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.apache.maven.plugin.pmd.PmdReportListener;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class PmdReport
extends AbstractPmdReport {
    private String targetJdk;
    private int minimumPriority = 5;
    private boolean skip;
    private String[] rulesets = new String[]{"rulesets/basic.xml", "rulesets/unusedcode.xml", "rulesets/imports.xml"};
    private ResourceManager locator;

    public String getName(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.name");
    }

    public String getDescription(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.description");
    }

    public void setRulesets(String[] rules) {
        this.rulesets = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(locale);
        }
        finally {
            if (this.getSink() != null) {
                this.getSink().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Locale locale) throws MavenReportException {
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Report report = this.generateReport(locale);
                if (!this.isHtml()) {
                    this.writeNonHtml(report);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Report generateReport(Locale locale) throws MavenReportException {
        Map files;
        Sink sink = this.getSink();
        PMD pmd = this.getPMD();
        RuleContext ruleContext = new RuleContext();
        Report report = new Report();
        PmdReportListener reportSink = new PmdReportListener(sink, PmdReport.getBundle(locale), this.aggregate);
        report.addListener((ReportListener)reportSink);
        ruleContext.setReport(report);
        reportSink.beginDocument();
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        ruleSetFactory.setMinimumPriority(this.minimumPriority);
        RuleSet[] sets = new RuleSet[this.rulesets.length];
        try {
            for (int idx = 0; idx < this.rulesets.length; ++idx) {
                String set = this.rulesets[idx];
                this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                File ruleset = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                if (null == ruleset) {
                    throw new MavenReportException("Could not resolve " + set);
                }
                FileInputStream rulesInput = new FileInputStream(ruleset);
                try {
                    RuleSet ruleSet;
                    sets[idx] = ruleSet = ruleSetFactory.createRuleSet((InputStream)rulesInput);
                    ruleSet.start(ruleContext);
                    continue;
                }
                finally {
                    ((InputStream)rulesInput).close();
                }
            }
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            files = this.getFilesToProcess();
        }
        catch (IOException e) {
            throw new MavenReportException("Can't get file list", (Exception)e);
        }
        if (StringUtils.isEmpty((String)this.getSourceEncoding()) && !files.isEmpty()) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        Iterator i = files.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            File file = (File)entry.getKey();
            PmdFileInfo fileInfo = (PmdFileInfo)entry.getValue();
            reportSink.beginFile(file, fileInfo);
            ruleContext.setSourceCodeFilename(file.getAbsolutePath());
            for (int idx = 0; idx < this.rulesets.length; ++idx) {
                try {
                    Reader reader = StringUtils.isNotEmpty((String)this.getSourceEncoding()) ? ReaderFactory.newReader((File)file, (String)this.getSourceEncoding()) : ReaderFactory.newPlatformReader((File)file);
                    try {
                        pmd.processFile(reader, sets[idx], ruleContext);
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (UnsupportedEncodingException e1) {
                    throw new MavenReportException("Encoding '" + this.getSourceEncoding() + "' is not supported.", (Exception)e1);
                }
                catch (PMDException pe) {
                    String msg = pe.getLocalizedMessage();
                    Throwable r = pe.getCause();
                    if (r != null) {
                        msg = msg + ": " + r.getLocalizedMessage();
                    }
                    this.getLog().warn((CharSequence)msg);
                    reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, msg));
                    continue;
                }
                catch (FileNotFoundException e2) {
                    this.getLog().warn((CharSequence)("Error opening source file: " + file));
                    reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, e2.getLocalizedMessage()));
                    continue;
                }
                catch (Exception e3) {
                    this.getLog().warn((CharSequence)("Failure executing PMD for: " + file), (Throwable)e3);
                    reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, e3.getLocalizedMessage()));
                }
            }
            reportSink.endFile(file);
        }
        for (int idx = 0; idx < this.rulesets.length; ++idx) {
            sets[idx].end(ruleContext);
        }
        reportSink.endDocument();
        return report;
    }

    private void writeNonHtml(Report report) throws MavenReportException {
        Renderer r = this.createRenderer();
        if (r == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            File targetFile = new File(this.targetDirectory, "pmd." + this.format);
            FileOutputStream tStream = new FileOutputStream(targetFile);
            writer = new OutputStreamWriter((OutputStream)tStream, this.getOutputEncoding());
            r.setWriter((Writer)writer);
            r.start();
            r.renderFileReport(report);
            r.end();
            ((Writer)writer).close();
            File siteDir = this.getReportOutputDirectory();
            siteDir.mkdirs();
            FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "pmd." + this.format));
        }
        catch (IOException ioe) {
            try {
                throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    public PMD getPMD() throws MavenReportException {
        PMD pmd = new PMD();
        if (null != this.targetJdk) {
            SourceType sourceType = SourceType.getSourceTypeForId((String)("java " + this.targetJdk));
            if (sourceType == null) {
                throw new MavenReportException("Unsupported targetJdk value '" + this.targetJdk + "'.");
            }
            pmd.setJavaVersion(sourceType);
        }
        return pmd;
    }

    public String getOutputName() {
        return "pmd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pmd-report", locale, PmdReport.class.getClassLoader());
    }

    public final Renderer createRenderer() throws MavenReportException {
        PmdXMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new PmdXMLRenderer(this.getOutputEncoding());
        } else if ("txt".equals(this.format)) {
            renderer = new TextRenderer();
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if ("html".equals(this.format)) {
            renderer = new HTMLRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find PMD custom format " + this.format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }

    private static class ProcessingErrorRuleViolation
    implements IRuleViolation {
        private String filename;
        private String description;

        public ProcessingErrorRuleViolation(File file, String description) {
            this.filename = file.getPath();
            this.description = description;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getBeginLine() {
            return 0;
        }

        public int getBeginColumn() {
            return 0;
        }

        public int getEndLine() {
            return 0;
        }

        public int getEndColumn() {
            return 0;
        }

        public Rule getRule() {
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPackageName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public String getClassName() {
            return null;
        }

        public boolean isSuppressed() {
            return false;
        }

        public String getVariableName() {
            return null;
        }
    }

    private static class PmdXMLRenderer
    extends XMLRenderer {
        public PmdXMLRenderer(String encoding) {
            this.encoding = encoding;
        }
    }
}

