/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.completer;

import java.util.List;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrCompleterSupport
implements Completer {
    protected final transient Logger logger = LoggerFactory.getLogger(ScrCompleterSupport.class);
    @Reference
    private ScrService scrService;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            for (Component component : this.scrService.getComponents()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component Name to work on: " + component.getName());
                }
                if (ScrActionSupport.showHiddenComponent(commandLine, component)) {
                    if (!this.availableComponent(component)) continue;
                    delegate.getStrings().add(component.getName());
                    continue;
                }
                if (ScrActionSupport.isHiddenComponent(component) || !this.availableComponent(component)) continue;
                delegate.getStrings().add(component.getName());
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception completing the command request: " + e.getLocalizedMessage());
        }
        return delegate.complete(session, commandLine, candidates);
    }

    public abstract boolean availableComponent(Component var1) throws Exception;

    public ScrService getScrService() {
        return this.scrService;
    }

    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }
}

