/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.completer.ActivateCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="scr", name="activate", description="Activates a Component for the given name")
@Service
public class ActivateAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The name of the Component to activate ", required=true, multiValued=false)
    @Completion(value=ActivateCompleter.class)
    String name;

    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        this.logger.debug("Activate Action");
        this.logger.debug("  Activating the Component: " + this.name);
        Component[] components = scrService.getComponents(this.name);
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            component.enable();
        }
        return null;
    }
}

