/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.admin.AdminUtils$;
import kafka.api.ControlledShutdownRequest;
import kafka.api.ControlledShutdownResponse;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponseSend;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.api.PartitionFetchInfo;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetMetadata;
import kafka.common.OffsetMetadata$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.controller.KafkaController;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupCoordinator$;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberSummary;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.RequestChannel;
import kafka.network.RequestOrResponseSend;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.Topic$;
import kafka.server.BecomeLeaderOrFollowerResult;
import kafka.server.BrokerTopicStats$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.KafkaApis$;
import kafka.server.KafkaApis$$anonfun$kafka$server$KafkaApis$;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.ResponseSend;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u0001\u001d\u0011\u0011bS1gW\u0006\f\u0005/[:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001d3\tq!+Z9vKN$8\t[1o]\u0016d\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0006d_>\u0014H-\u001b8bi>\u0014X#A\u0016\u0011\u00051rS\"A\u0017\u000b\u0005%\"\u0011BA\u0018.\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003,\u00031\u0019wn\u001c:eS:\fGo\u001c:!\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0014AC2p]R\u0014x\u000e\u001c7feV\tQ\u0007\u0005\u00027q5\tqG\u0003\u00024\t%\u0011\u0011h\u000e\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A1\b\u0001B\u0001B\u0003%Q'A\u0006d_:$(o\u001c7mKJ\u0004\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \u0002\u000fi\\W\u000b^5mgV\tq\b\u0005\u0002\u0010\u0001&\u0011\u0011\t\u0005\u0002\b5.,F/\u001b7t\u0011!\u0019\u0005A!A!\u0002\u0013y\u0014\u0001\u0003>l+RLGn\u001d\u0011\t\u0011\u0015\u0003!Q1A\u0005\u0002\u0019\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002\u000fB\u0011\u0011\u0002S\u0005\u0003\u0013*\u00111!\u00138u\u0011!Y\u0005A!A!\u0002\u00139\u0015!\u00032s_.,'/\u00133!\u0011!i\u0005A!b\u0001\n\u0003q\u0015AB2p]\u001aLw-F\u0001P!\t\u0019\u0003+\u0003\u0002R\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!\u0019\u0006A!A!\u0002\u0013y\u0015aB2p]\u001aLw\r\t\u0005\t+\u0002\u0011)\u0019!C\u0001-\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012a\u0016\t\u0003GaK!!\u0017\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Y\u0006A!A!\u0002\u00139\u0016AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\t;\u0002\u0011)\u0019!C\u0001=\u00069Q.\u001a;sS\u000e\u001cX#A0\u0011\u0005\u0001LW\"A1\u000b\u0005u\u0013'BA2e\u0003\u0019\u0019w.\\7p]*\u0011Q!\u001a\u0006\u0003M\u001e\fa!\u00199bG\",'\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kC\n9Q*\u001a;sS\u000e\u001c\b\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B0\u0002\u00115,GO]5dg\u0002B\u0001B\u001c\u0001\u0003\u0006\u0004%\ta\\\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#\u00019\u0011\u0007%\t8/\u0003\u0002s\u0015\t1q\n\u001d;j_:\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t\u0005,H\u000f\u001b\u0006\u0003q\u0012\t\u0001b]3dkJLG/_\u0005\u0003uV\u0014!\"Q;uQ>\u0014\u0018N_3s\u0011!a\bA!A!\u0002\u0013\u0001\u0018aC1vi\"|'/\u001b>fe\u0002BQA \u0001\u0005\u0002}\fa\u0001P5oSRtDCFA\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0011\u0005\r\u0002\u0001\"B\u000b~\u0001\u00049\u0002\"\u0002\u0011~\u0001\u0004\u0011\u0003\"B\u0015~\u0001\u0004Y\u0003\"B\u001a~\u0001\u0004)\u0004\"B\u001f~\u0001\u0004y\u0004\"B#~\u0001\u00049\u0005\"B'~\u0001\u0004y\u0005\"B+~\u0001\u00049\u0006\"B/~\u0001\u0004y\u0006\"\u00028~\u0001\u0004\u0001\b\"CA\r\u0001\t\u0007I\u0011AA\u000e\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\u0011\u0011Q\u0004\t\t\u0003?\t)#!\u000b\u000205\u0011\u0011\u0011\u0005\u0006\u0004\u0003GQ\u0011AC2pY2,7\r^5p]&!\u0011qEA\u0011\u0005\ri\u0015\r\u001d\t\u0004\u0013\u0005-\u0012bAA\u0017\u0015\t)1\u000b[8siB\u00191%!\r\n\u0007\u0005M\"A\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002CA\u001c\u0001\u0001\u0006I!!\b\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA!9\u00111\b\u0001\u0005\u0002\u0005u\u0012A\u00025b]\u0012dW\r\u0006\u0003\u0002@\u0005\u0015\u0003cA\u0005\u0002B%\u0019\u00111\t\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000f\nI\u00041\u0001\u0002J\u00059!/Z9vKN$\b\u0003BA&\u0003#r1\u0001GA'\u0013\r\ty%G\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t\u0019&!\u0016\u0003\u000fI+\u0017/^3ti*\u0019\u0011qJ\r\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005I\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0011\ty$!\u0018\t\u0011\u0005\u001d\u0013q\u000ba\u0001\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019'\u0001\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR$B!a\u0010\u0002f!A\u0011qIA0\u0001\u0004\tI\u0005C\u0004\u0002j\u0001!\t!a\u001b\u00027!\fg\u000e\u001a7f+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011\ty$!\u001c\t\u0011\u0005\u001d\u0013q\ra\u0001\u0003\u0013Bq!!\u001d\u0001\t\u0003\t\u0019(A\u0010iC:$G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V-];fgR$B!a\u0010\u0002v!A\u0011qIA8\u0001\u0004\tI\u0005C\u0004\u0002z\u0001!\t!a\u001f\u00023!\fg\u000e\u001a7f\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003\u007f\ti\b\u0003\u0005\u0002H\u0005]\u0004\u0019AA%\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b\u0011\"Y;uQ>\u0014\u0018N_3\u0015\u0011\u0005\u0015\u00151RAS\u0003_\u00032!CAD\u0013\r\tII\u0003\u0002\b\u0005>|G.Z1o\u0011!\ti)a A\u0002\u0005=\u0015aB:fgNLwN\u001c\t\u0005\u0003#\u000b\tK\u0004\u0003\u0002\u0014\u00065c\u0002BAK\u0003?sA!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u000373\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\tQB!\u0003\u0003\u0002$\u0006U#aB*fgNLwN\u001c\u0005\t\u0003O\u000by\b1\u0001\u0002*\u0006Iq\u000e]3sCRLwN\u001c\t\u0004i\u0006-\u0016bAAWk\nIq\n]3sCRLwN\u001c\u0005\t\u0003c\u000by\b1\u0001\u00024\u0006A!/Z:pkJ\u001cW\rE\u0002u\u0003kK1!a.v\u0005!\u0011Vm]8ve\u000e,\u0007bBA^\u0001\u0011\u0005\u0011QX\u0001\u0016Q\u0006tG\r\\3Qe>$WoY3s%\u0016\fX/Z:u)\u0011\ty$a0\t\u0011\u0005\u001d\u0013\u0011\u0018a\u0001\u0003\u0013Bq!a1\u0001\t\u0003\t)-\u0001\niC:$G.\u001a$fi\u000eD'+Z9vKN$H\u0003BA \u0003\u000fD\u0001\"a\u0012\u0002B\u0002\u0007\u0011\u0011\n\u0005\b\u0003\u0017\u0004A\u0011AAg\u0003MA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u)\u0011\ty$a4\t\u0011\u0005\u001d\u0013\u0011\u001aa\u0001\u0003\u0013Bq!a5\u0001\t\u0003\t).\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$8\u000f\u0006\u0006\u0002X\u0006\r\u00181_A\u0000\u0005\u0007\u0001b!a\b\u0002Z\u0006u\u0017\u0002BAn\u0003C\u00111aU3r!\rI\u0011q\\\u0005\u0004\u0003CT!\u0001\u0002'p]\u001eD\u0001\"!:\u0002R\u0002\u0007\u0011q]\u0001\u000bY><W*\u00198bO\u0016\u0014\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H!A\u0002m_\u001eLA!!=\u0002l\nQAj\\4NC:\fw-\u001a:\t\u0011\u0005U\u0018\u0011\u001ba\u0001\u0003o\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002z\u0006mX\"\u00012\n\u0007\u0005u(M\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\t\u0005\u0011\u0011\u001ba\u0001\u0003;\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\t\u0015\u0011\u0011\u001ba\u0001\u000f\u0006iQ.\u0019=Ok6|eMZ:fiNDqA!\u0003\u0001\t\u0013\u0011Y!\u0001\ngKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,G\u0003CAl\u0005\u001b\u0011)Ba\u0006\t\u0011\u00055(q\u0001a\u0001\u0005\u001f\u0001B!!;\u0003\u0012%!!1CAv\u0005\raun\u001a\u0005\t\u0005\u0003\u00119\u00011\u0001\u0002^\"9!Q\u0001B\u0004\u0001\u00049\u0005b\u0002B\u000e\u0001\u0011%!QD\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$bAa\b\u0003.\t\u0015\u0003CBA\u0010\u00033\u0014\t\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\r\u00119\u0003B\u0001\u0004CBL\u0017\u0002\u0002B\u0016\u0005K\u0011Q\u0002V8qS\u000elU\r^1eCR\f\u0007\u0002\u0003B\u0018\u00053\u0001\rA!\r\u0002\rQ|\u0007/[2t!\u0019\tyBa\r\u00038%!!QGA\u0011\u0005\r\u0019V\r\u001e\t\u0005\u0005s\u0011yDD\u0002\n\u0005wI1A!\u0010\u000b\u0003\u0019\u0001&/\u001a3fM&!!\u0011\tB\"\u0005\u0019\u0019FO]5oO*\u0019!Q\b\u0006\t\u0011\t\u001d#\u0011\u0004a\u0001\u0005\u0013\n\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014c\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B*\u0005\u001b\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000f\t]\u0003\u0001\"\u0001\u0003Z\u0005Q\u0002.\u00198eY\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR!\u0011q\bB.\u0011!\t9E!\u0016A\u0002\u0005%\u0003b\u0002B0\u0001\u0011\u0005!\u0011M\u0001\u0019Q\u0006tG\r\\3PM\u001a\u001cX\r\u001e$fi\u000eD'+Z9vKN$H\u0003BA \u0005GB\u0001\"a\u0012\u0003^\u0001\u0007\u0011\u0011\n\u0005\b\u0005O\u0002A\u0011\u0001B5\u0003uA\u0017M\u001c3mK\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014(+Z9vKN$H\u0003BA \u0005WB\u0001\"a\u0012\u0003f\u0001\u0007\u0011\u0011\n\u0005\b\u0005_\u0002A\u0011\u0001B9\u0003iA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016<%o\\;q%\u0016\fX/Z:u)\u0011\tyDa\u001d\t\u0011\u0005\u001d#Q\u000ea\u0001\u0003\u0013BqAa\u001e\u0001\t\u0003\u0011I(A\fiC:$G.\u001a'jgR<%o\\;qgJ+\u0017/^3tiR!\u0011q\bB>\u0011!\t9E!\u001eA\u0002\u0005%\u0003b\u0002B@\u0001\u0011\u0005!\u0011Q\u0001\u0017Q\u0006tG\r\\3K_&twI]8vaJ+\u0017/^3tiR!\u0011q\bBB\u0011!\t9E! A\u0002\u0005%\u0003b\u0002BD\u0001\u0011\u0005!\u0011R\u0001\u0017Q\u0006tG\r\\3Ts:\u001cwI]8vaJ+\u0017/^3tiR!\u0011q\bBF\u0011!\t9E!\"A\u0002\u0005%\u0003b\u0002BH\u0001\u0011\u0005!\u0011S\u0001\u0017Q\u0006tG\r\\3IK\u0006\u0014HOY3biJ+\u0017/^3tiR!\u0011q\bBJ\u0011!\t9E!$A\u0002\u0005%\u0003b\u0002BL\u0001\u0011%!\u0011T\u0001\u0019S:\u001cH/\u00198uS\u0006$X-U;pi\u0006l\u0015M\\1hKJ\u001cH\u0003BA\u000f\u00057CqA!(\u0003\u0016\u0002\u0007q*A\u0002dM\u001eDqA!)\u0001\t\u0003\u0011\u0019+A\fiC:$G.\u001a'fCZ,wI]8vaJ+\u0017/^3tiR!\u0011q\bBS\u0011!\t9Ea(A\u0002\u0005%\u0003b\u0002BU\u0001\u0011\u0005!1V\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u007fAqAa,\u0001\t\u0003\u0011\t,\u0001\fbkRDwN]5{K\u000ecWo\u001d;fe\u0006\u001bG/[8o)\u0011\tyDa-\t\u0011\u0005\u001d#Q\u0016a\u0001\u0003\u0013\u0002")
public class KafkaApis
implements Logging {
    private final RequestChannel requestChannel;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator coordinator;
    private final KafkaController controller;
    private final ZkUtils zkUtils;
    private final int brokerId;
    private final KafkaConfig config;
    private final MetadataCache metadataCache;
    private final Metrics metrics;
    private final Option<Authorizer> authorizer;
    private final Map<Object, ClientQuotaManager> quotaManagers;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public GroupCoordinator coordinator() {
        return this.coordinator;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public Map<Object, ClientQuotaManager> quotaManagers() {
        return this.quotaManagers;
    }

    public void handle(RequestChannel.Request request) {
        block42: {
            ApiKeys apiKeys;
            block41: {
                this.trace((Function0<String>)new Serializable(this, request){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Handling request:%s from connection %s;securityProtocol:%s,principal:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.requestObj(), this.request$1.connectionId(), this.request$1.securityProtocol(), this.request$1.session().principal()}));
                    }
                    {
                        this.request$1 = request$1;
                    }
                });
                apiKeys = ApiKeys.forId((int)request.requestId());
                ApiKeys apiKeys2 = ApiKeys.PRODUCE;
                ApiKeys apiKeys3 = apiKeys;
                if (!(apiKeys2 != null ? !apiKeys2.equals(apiKeys3) : apiKeys3 != null)) {
                    this.handleProducerRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ApiKeys apiKeys4 = ApiKeys.FETCH;
                    ApiKeys apiKeys5 = apiKeys;
                    if (!(apiKeys4 != null ? !apiKeys4.equals(apiKeys5) : apiKeys5 != null)) {
                        this.handleFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        ApiKeys apiKeys6 = ApiKeys.LIST_OFFSETS;
                        ApiKeys apiKeys7 = apiKeys;
                        if (!(apiKeys6 != null ? !apiKeys6.equals(apiKeys7) : apiKeys7 != null)) {
                            this.handleOffsetRequest(request);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            ApiKeys apiKeys8 = ApiKeys.METADATA;
                            ApiKeys apiKeys9 = apiKeys;
                            if (!(apiKeys8 != null ? !apiKeys8.equals(apiKeys9) : apiKeys9 != null)) {
                                this.handleTopicMetadataRequest(request);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                ApiKeys apiKeys10 = ApiKeys.LEADER_AND_ISR;
                                ApiKeys apiKeys11 = apiKeys;
                                if (!(apiKeys10 != null ? !apiKeys10.equals(apiKeys11) : apiKeys11 != null)) {
                                    this.handleLeaderAndIsrRequest(request);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    ApiKeys apiKeys12 = ApiKeys.STOP_REPLICA;
                                    ApiKeys apiKeys13 = apiKeys;
                                    if (!(apiKeys12 != null ? !apiKeys12.equals(apiKeys13) : apiKeys13 != null)) {
                                        this.handleStopReplicaRequest(request);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        ApiKeys apiKeys14 = ApiKeys.UPDATE_METADATA_KEY;
                                        ApiKeys apiKeys15 = apiKeys;
                                        if (!(apiKeys14 != null ? !apiKeys14.equals(apiKeys15) : apiKeys15 != null)) {
                                            this.handleUpdateMetadataRequest(request);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            ApiKeys apiKeys16 = ApiKeys.CONTROLLED_SHUTDOWN_KEY;
                                            ApiKeys apiKeys17 = apiKeys;
                                            if (!(apiKeys16 != null ? !apiKeys16.equals(apiKeys17) : apiKeys17 != null)) {
                                                this.handleControlledShutdownRequest(request);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                ApiKeys apiKeys18 = ApiKeys.OFFSET_COMMIT;
                                                ApiKeys apiKeys19 = apiKeys;
                                                if (!(apiKeys18 != null ? !apiKeys18.equals(apiKeys19) : apiKeys19 != null)) {
                                                    this.handleOffsetCommitRequest(request);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    ApiKeys apiKeys20 = ApiKeys.OFFSET_FETCH;
                                                    ApiKeys apiKeys21 = apiKeys;
                                                    if (!(apiKeys20 != null ? !apiKeys20.equals(apiKeys21) : apiKeys21 != null)) {
                                                        this.handleOffsetFetchRequest(request);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        ApiKeys apiKeys22 = ApiKeys.GROUP_COORDINATOR;
                                                        ApiKeys apiKeys23 = apiKeys;
                                                        if (!(apiKeys22 != null ? !apiKeys22.equals(apiKeys23) : apiKeys23 != null)) {
                                                            this.handleGroupCoordinatorRequest(request);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            ApiKeys apiKeys24 = ApiKeys.JOIN_GROUP;
                                                            ApiKeys apiKeys25 = apiKeys;
                                                            if (!(apiKeys24 != null ? !apiKeys24.equals(apiKeys25) : apiKeys25 != null)) {
                                                                this.handleJoinGroupRequest(request);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                ApiKeys apiKeys26 = ApiKeys.HEARTBEAT;
                                                                ApiKeys apiKeys27 = apiKeys;
                                                                if (!(apiKeys26 != null ? !apiKeys26.equals(apiKeys27) : apiKeys27 != null)) {
                                                                    this.handleHeartbeatRequest(request);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    ApiKeys apiKeys28 = ApiKeys.LEAVE_GROUP;
                                                                    ApiKeys apiKeys29 = apiKeys;
                                                                    if (!(apiKeys28 != null ? !apiKeys28.equals(apiKeys29) : apiKeys29 != null)) {
                                                                        this.handleLeaveGroupRequest(request);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        ApiKeys apiKeys30 = ApiKeys.SYNC_GROUP;
                                                                        ApiKeys apiKeys31 = apiKeys;
                                                                        if (!(apiKeys30 != null ? !apiKeys30.equals(apiKeys31) : apiKeys31 != null)) {
                                                                            this.handleSyncGroupRequest(request);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            ApiKeys apiKeys32 = ApiKeys.DESCRIBE_GROUPS;
                                                                            ApiKeys apiKeys33 = apiKeys;
                                                                            if (!(apiKeys32 != null ? !apiKeys32.equals(apiKeys33) : apiKeys33 != null)) {
                                                                                this.handleDescribeGroupRequest(request);
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            } else {
                                                                                ApiKeys apiKeys34 = ApiKeys.LIST_GROUPS;
                                                                                ApiKeys apiKeys35 = apiKeys;
                                                                                if (apiKeys34 != null ? !apiKeys34.equals(apiKeys35) : apiKeys35 != null) break block41;
                                                                                this.handleListGroupsRequest(request);
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
            try {
                throw new KafkaException(new StringBuilder().append((Object)"Unknown api code ").append((Object)apiKeys).toString());
            }
            catch (Throwable throwable) {
                if (request.requestObj() == null) {
                    AbstractRequestResponse response = request.body().getErrorResponse((int)request.header().apiVersion(), throwable);
                    ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
                    if (response == null) {
                        this.requestChannel().closeConnection(request.processor(), request);
                    } else {
                        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, response)));
                    }
                    this.error((Function0<String>)new Serializable(this, request){
                        public static final long serialVersionUID = 0L;
                        private final RequestChannel.Request request$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.body()}));
                        }
                        {
                            this.request$1 = request$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    break block42;
                }
                request.requestObj().handleError(throwable, this.requestChannel(), request);
                this.error((Function0<String>)new Serializable(this, request){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.requestObj()}));
                    }
                    {
                        this.request$1 = request$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
            break block42;
            finally {
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
        }
    }

    public void handleLeaderAndIsrRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)request.body();
        try {
            LeaderAndIsrResponse leaderAndIsrResponse;
            ResponseHeader responseHeader = new ResponseHeader(correlationId);
            if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                BecomeLeaderOrFollowerResult result = this.replicaManager().becomeLeaderOrFollower(correlationId, leaderAndIsrRequest, this.metadataCache(), (Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;

                    public final void apply(Iterable<Partition> updatedLeaders, Iterable<Partition> updatedFollowers) {
                        this.$outer.kafka$server$KafkaApis$$onLeadershipChange$1(updatedLeaders, updatedFollowers);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                leaderAndIsrResponse = new LeaderAndIsrResponse(result.errorCode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(result.responseMap().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Short apply(short x$1) {
                        return new Short(x$1);
                    }
                })).asJava());
            } else {
                scala.collection.immutable.Map result = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, Short> apply(TopicPartition x$2) {
                        return new Tuple2((Object)x$2, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                leaderAndIsrResponse = new LeaderAndIsrResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
            }
            LeaderAndIsrResponse leaderAndIsrResponse2 = leaderAndIsrResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)leaderAndIsrResponse2)));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disk error during leadership change.";
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$2;

                public final KafkaStorageException apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStopReplicaRequest(RequestChannel.Request request) {
        StopReplicaResponse stopReplicaResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2 tuple2;
            Tuple2<scala.collection.mutable.Map<TopicPartition, Object>, Object> tuple22 = this.replicaManager().stopReplicas(stopReplicaRequest);
            if (tuple22 == null) throw new MatchError(tuple22);
            scala.collection.mutable.Map result = (scala.collection.mutable.Map)tuple22._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple22._2());
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToShort((short)error));
            scala.collection.mutable.Map result2 = (scala.collection.mutable.Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            stopReplicaResponse = new StopReplicaResponse(error2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result2).asJava());
        } else {
            scala.collection.immutable.Map result = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(stopReplicaRequest.partitions()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Short> apply(TopicPartition x$4) {
                    return new Tuple2((Object)x$4, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            stopReplicaResponse = new StopReplicaResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
        }
        StopReplicaResponse response = stopReplicaResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
        this.replicaManager().replicaFetcherManager().shutdownIdleFetcherThreads();
    }

    public void handleUpdateMetadataRequest(RequestChannel.Request request) {
        UpdateMetadataResponse updateMetadataResponse;
        int correlationId = request.header().correlationId();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)request.body();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            this.replicaManager().maybeUpdateMetadataCache(correlationId, updateMetadataRequest, this.metadataCache());
            updateMetadataResponse = new UpdateMetadataResponse(Errors.NONE.code());
        } else {
            updateMetadataResponse = new UpdateMetadataResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        }
        UpdateMetadataResponse updateMetadataResponse2 = updateMetadataResponse;
        ResponseHeader responseHeader = new ResponseHeader(correlationId);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)updateMetadataResponse2)));
    }

    public void handleControlledShutdownRequest(RequestChannel.Request request) {
        ControlledShutdownRequest controlledShutdownRequest = (ControlledShutdownRequest)request.requestObj();
        this.authorizeClusterAction(request);
        scala.collection.Set<TopicAndPartition> partitionsRemaining = this.controller().shutdownBroker(controlledShutdownRequest.brokerId());
        ControlledShutdownResponse controlledShutdownResponse = new ControlledShutdownResponse(controlledShutdownRequest.correlationId(), Errors.NONE.code(), partitionsRemaining);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), controlledShutdownResponse)));
    }

    public void handleOffsetCommitRequest(RequestChannel.Request request) {
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)request.requestObj();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetCommitRequest.groupId()))) {
            scala.collection.immutable.Map invalidRequestsInfo = (scala.collection.immutable.Map)offsetCommitRequest.requestInfo().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;

                public final boolean apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x0$1) {
                    Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        boolean bl = !this.$outer.metadataCache().contains(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            scala.collection.immutable.Map filteredRequestInfo = (scala.collection.immutable.Map)offsetCommitRequest.requestInfo().$minus$minus((GenTraversableOnce)invalidRequestsInfo.keys());
            Tuple2 tuple2 = filteredRequestInfo.partition((Function1)new $anonfun$9(this, request));
            if (tuple2 != null) {
                Tuple2 tuple22;
                scala.collection.immutable.Map authorizedRequestInfo = (scala.collection.immutable.Map)tuple2._1();
                scala.collection.immutable.Map unauthorizedRequestInfo = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
                scala.collection.immutable.Map authorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._1();
                scala.collection.immutable.Map unauthorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._2();
                if (authorizedRequestInfo2.isEmpty()) {
                    this.kafka$server$KafkaApis$$sendResponseCallback$1(scala.collection.Map$.MODULE$.empty(), request, offsetCommitRequest, invalidRequestsInfo, unauthorizedRequestInfo2);
                } else if (offsetCommitRequest.versionId() == 0) {
                    scala.collection.immutable.Map responseInfo = (scala.collection.immutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this, request, offsetCommitRequest){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaApis $outer;
                        private final RequestChannel.Request request$6;
                        private final OffsetCommitRequest offsetCommitRequest$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x0$4) {
                            Tuple2 tuple2;
                            Tuple2<TopicAndPartition, OffsetAndMetadata> tuple22 = x0$4;
                            if (tuple22 == null) throw new MatchError(tuple22);
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                            OffsetAndMetadata metaAndError = (OffsetAndMetadata)tuple22._2();
                            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.offsetCommitRequest$1.groupId(), topicAndPartition.topic());
                            try {
                                if (this.$outer.metadataCache().getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicAndPartition.topic()}))), this.request$6.securityProtocol()).size() <= 0) {
                                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
                                    return tuple2;
                                } else if (metaAndError.metadata() != null && metaAndError.metadata().length() > Predef$.MODULE$.Integer2int(this.$outer.config().offsetMetadataMaxSize())) {
                                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)Errors.OFFSET_METADATA_TOO_LARGE.code()));
                                    return tuple2;
                                } else {
                                    this.$outer.zkUtils().updatePersistentPath(new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition.partition())).toString(), ((Object)BoxesRunTime.boxToLong((long)metaAndError.offset())).toString(), this.$outer.zkUtils().updatePersistentPath$default$3());
                                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                                }
                                return tuple2;
                            }
                            catch (Throwable throwable) {
                                tuple2 = new Tuple2((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)Errors.forException((Throwable)throwable).code()));
                            }
                            return tuple2;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.request$6 = request$6;
                            this.offsetCommitRequest$1 = offsetCommitRequest$1;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    this.kafka$server$KafkaApis$$sendResponseCallback$1(responseInfo, request, offsetCommitRequest, invalidRequestsInfo, unauthorizedRequestInfo2);
                } else {
                    long offsetRetention = offsetCommitRequest.versionId() <= 1 || offsetCommitRequest.retentionMs() == -1L ? this.coordinator().offsetConfig().offsetsRetentionMs() : offsetCommitRequest.retentionMs();
                    long currentTimestamp = SystemTime$.MODULE$.milliseconds();
                    long defaultExpireTimestamp = offsetRetention + currentTimestamp;
                    scala.collection.immutable.Map offsetData = authorizedRequestInfo2.mapValues((Function1)new Serializable(this, offsetRetention, currentTimestamp, defaultExpireTimestamp){
                        public static final long serialVersionUID = 0L;
                        private final long offsetRetention$1;
                        private final long currentTimestamp$1;
                        private final long defaultExpireTimestamp$1;

                        public final OffsetAndMetadata apply(OffsetAndMetadata offsetAndMetadata) {
                            long x$34 = this.currentTimestamp$1;
                            long x$35 = offsetAndMetadata.commitTimestamp() == -1L ? this.defaultExpireTimestamp$1 : this.offsetRetention$1 + offsetAndMetadata.commitTimestamp();
                            OffsetMetadata x$36 = offsetAndMetadata.copy$default$1();
                            return offsetAndMetadata.copy(x$36, x$34, x$35);
                        }
                        {
                            this.offsetRetention$1 = offsetRetention$1;
                            this.currentTimestamp$1 = currentTimestamp$1;
                            this.defaultExpireTimestamp$1 = defaultExpireTimestamp$1;
                        }
                    });
                    this.coordinator().handleCommitOffsets(offsetCommitRequest.groupId(), offsetCommitRequest.memberId(), offsetCommitRequest.groupGenerationId(), (scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)offsetData, (Function1<scala.collection.immutable.Map<TopicAndPartition, Object>, BoxedUnit>)new Serializable(this, request, offsetCommitRequest, invalidRequestsInfo, unauthorizedRequestInfo2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaApis $outer;
                        private final RequestChannel.Request request$6;
                        private final OffsetCommitRequest offsetCommitRequest$1;
                        private final scala.collection.immutable.Map invalidRequestsInfo$1;
                        private final scala.collection.immutable.Map unauthorizedRequestInfo$1;

                        public final void apply(scala.collection.immutable.Map<TopicAndPartition, Object> commitStatus) {
                            this.$outer.kafka$server$KafkaApis$$sendResponseCallback$1(commitStatus, this.request$6, this.offsetCommitRequest$1, this.invalidRequestsInfo$1, this.unauthorizedRequestInfo$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.request$6 = request$6;
                            this.offsetCommitRequest$1 = offsetCommitRequest$1;
                            this.invalidRequestsInfo$1 = invalidRequestsInfo$1;
                            this.unauthorizedRequestInfo$1 = unauthorizedRequestInfo$1;
                        }
                    });
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map errors = offsetCommitRequest.requestInfo().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(OffsetAndMetadata x$5) {
                return Errors.GROUP_AUTHORIZATION_FAILED.code();
            }
        });
        OffsetCommitResponse response = new OffsetCommitResponse((scala.collection.immutable.Map<TopicAndPartition, Object>)errors, offsetCommitRequest.correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), response)));
    }

    public boolean kafka$server$KafkaApis$$authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        return BoxesRunTime.unboxToBoolean((Object)this.authorizer().map((Function1)new Serializable(this, session, operation, resource){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Session session$1;
            private final Operation operation$1;
            private final Resource resource$1;

            public final boolean apply(Authorizer x$9) {
                return x$9.authorize(this.session$1, this.operation$1, this.resource$1);
            }
            {
                this.session$1 = session$1;
                this.operation$1 = operation$1;
                this.resource$1 = resource$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    public void handleProducerRequest(RequestChannel.Request request) {
        ProduceRequest produceRequest = (ProduceRequest)request.body();
        int numBytesAppended = request.header().sizeOf() + produceRequest.sizeOf();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceRequest.partitionRecords()).asScala()).partition((Function1)new $anonfun$14(this, request));
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
            if (authorizedRequestInfo2.isEmpty()) {
                this.kafka$server$KafkaApis$$sendResponseCallback$2((Map)scala.collection.Map$.MODULE$.empty(), request, produceRequest, numBytesAppended, unauthorizedRequestInfo2);
            } else {
                String string = request.header().clientId();
                String string2 = AdminUtils$.MODULE$.AdminClientId();
                boolean internalTopicsAllowed = !(string != null ? !string.equals(string2) : string2 != null);
                scala.collection.mutable.Map authorizedMessagesPerPartition = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, ByteBufferMessageSet> apply(Tuple2<TopicPartition, ByteBuffer> x0$8) {
                        Tuple2<TopicPartition, ByteBuffer> tuple2 = x0$8;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            ByteBuffer buffer = (ByteBuffer)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)new ByteBufferMessageSet(buffer));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                this.replicaManager().appendMessages(produceRequest.timeout(), produceRequest.acks(), internalTopicsAllowed, (Map<TopicPartition, MessageSet>)authorizedMessagesPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)new Serializable(this, request, produceRequest, numBytesAppended, unauthorizedRequestInfo2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final RequestChannel.Request request$2;
                    private final ProduceRequest produceRequest$1;
                    private final int numBytesAppended$1;
                    private final scala.collection.mutable.Map unauthorizedRequestInfo$2;

                    public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                        this.$outer.kafka$server$KafkaApis$$sendResponseCallback$2(responseStatus, this.request$2, this.produceRequest$1, this.numBytesAppended$1, this.unauthorizedRequestInfo$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.request$2 = request$2;
                        this.produceRequest$1 = produceRequest$1;
                        this.numBytesAppended$1 = numBytesAppended$1;
                        this.unauthorizedRequestInfo$2 = unauthorizedRequestInfo$2;
                    }
                });
                produceRequest.clearPartitionRecords();
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void handleFetchRequest(RequestChannel.Request request) {
        FetchRequest fetchRequest = (FetchRequest)request.requestObj();
        Tuple2 tuple2 = fetchRequest.requestInfo().partition((Function1)new $anonfun$18(this, request));
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map authorizedRequestInfo = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map unauthorizedRequestInfo = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.immutable.Map authorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map unauthorizedRequestInfo2 = (scala.collection.immutable.Map)tuple23._2();
            scala.collection.immutable.Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final FetchResponsePartitionData apply(PartitionFetchInfo x$13) {
                    return new FetchResponsePartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, MessageSet$.MODULE$.Empty());
                }
            });
            if (authorizedRequestInfo2.isEmpty()) {
                this.kafka$server$KafkaApis$$sendResponseCallback$3((Map)scala.collection.Map$.MODULE$.empty(), request, fetchRequest, unauthorizedResponseStatus);
            } else {
                this.replicaManager().fetchMessages(fetchRequest.maxWait(), fetchRequest.replicaId(), fetchRequest.minBytes(), (scala.collection.immutable.Map<TopicAndPartition, PartitionFetchInfo>)authorizedRequestInfo2, (Function1<Map<TopicAndPartition, FetchResponsePartitionData>, BoxedUnit>)new Serializable(this, request, fetchRequest, unauthorizedResponseStatus){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final RequestChannel.Request request$3;
                    private final FetchRequest fetchRequest$1;
                    private final scala.collection.immutable.Map unauthorizedResponseStatus$1;

                    public final void apply(Map<TopicAndPartition, FetchResponsePartitionData> responsePartitionData) {
                        this.$outer.kafka$server$KafkaApis$$sendResponseCallback$3(responsePartitionData, this.request$3, this.fetchRequest$1, this.unauthorizedResponseStatus$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.request$3 = request$3;
                        this.fetchRequest$1 = fetchRequest$1;
                        this.unauthorizedResponseStatus$1 = unauthorizedResponseStatus$1;
                    }
                });
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void handleOffsetRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.offsetData()).asScala()).partition((Function1)new $anonfun$20(this, request));
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
            scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
            Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ListOffsetResponse.PartitionData apply(ListOffsetRequest.PartitionData x$16) {
                    return new ListOffsetResponse.PartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
                }
            });
            scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1)new Serializable(this, correlationId, clientId, offsetRequest){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                public final int correlationId$1;
                public final String clientId$1;
                private final ListOffsetRequest offsetRequest$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Tuple2<TopicPartition, ListOffsetResponse.PartitionData> apply(Tuple2<TopicPartition, ListOffsetRequest.PartitionData> elem) {
                    Tuple2 tuple2;
                    Tuple2 tuple23;
                    Tuple2<TopicPartition, ListOffsetRequest.PartitionData> tuple22 = elem;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    TopicPartition topicPartition2 = (TopicPartition)tuple22._1();
                    ListOffsetRequest.PartitionData partitionData = (ListOffsetRequest.PartitionData)tuple22._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)topicPartition2, (Object)partitionData);
                    TopicPartition topicPartition = (TopicPartition)tuple24._1();
                    ListOffsetRequest.PartitionData partitionData2 = (ListOffsetRequest.PartitionData)tuple24._2();
                    try {
                        Seq seq;
                        Replica localReplica = this.offsetRequest$1.replicaId() != -2 ? this.$outer.replicaManager().getLeaderReplicaIfLocal(topicPartition.topic(), topicPartition.partition()) : this.$outer.replicaManager().getReplicaOrException(topicPartition.topic(), topicPartition.partition());
                        Seq allOffsets = this.$outer.fetchOffsets(this.$outer.replicaManager().logManager(), topicPartition, partitionData2.timestamp, partitionData2.maxNumOffsets);
                        if (this.offsetRequest$1.replicaId() != -1) {
                            seq = allOffsets;
                        } else {
                            long hw = localReplica.highWatermark().messageOffset();
                            if (allOffsets.exists((Function1)new Serializable(this, hw){
                                public static final long serialVersionUID = 0L;
                                private final long hw$1;

                                public final boolean apply(long x$18) {
                                    return this.apply$mcZJ$sp(x$18);
                                }

                                public boolean apply$mcZJ$sp(long x$18) {
                                    return x$18 > this.hw$1;
                                }
                                {
                                    this.hw$1 = hw$1;
                                }
                            })) {
                                long l = hw;
                                seq = (Seq)((SeqLike)allOffsets.dropWhile((Function1)new Serializable(this, hw){
                                    public static final long serialVersionUID = 0L;
                                    private final long hw$1;

                                    public final boolean apply(long x$19) {
                                        return this.apply$mcZJ$sp(x$19);
                                    }

                                    public boolean apply$mcZJ$sp(long x$19) {
                                        return x$19 > this.hw$1;
                                    }
                                    {
                                        this.hw$1 = hw$1;
                                    }
                                })).$plus$colon((Object)BoxesRunTime.boxToLong((long)l), Seq$.MODULE$.canBuildFrom());
                            } else {
                                seq = allOffsets;
                            }
                        }
                        Seq offsets = seq;
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offsets.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Long apply(long x$21) {
                                return new Long(x$21);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava()));
                        return tuple2;
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Error while responding to offset request";
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$3;

                            public final Throwable apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                        return tuple2;
                    }
                    catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, notLeaderForPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$22 $outer;
                            private final TopicPartition topicPartition$2;
                            private final NotLeaderForPartitionException nle$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), this.$outer.clientId$1, this.topicPartition$2, this.nle$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicPartition$2 = topicPartition$2;
                                this.nle$1 = nle$1;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)notLeaderForPartitionException).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                        return tuple2;
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, unknownTopicOrPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$22 $outer;
                            private final TopicPartition topicPartition$2;
                            private final UnknownTopicOrPartitionException utpe$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), this.$outer.clientId$1, this.topicPartition$2, this.utpe$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicPartition$2 = topicPartition$2;
                                this.utpe$1 = utpe$1;
                            }
                        });
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)unknownTopicOrPartitionException).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    }
                    return tuple2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.correlationId$1 = correlationId$1;
                    this.clientId$1 = clientId$1;
                    this.offsetRequest$1 = offsetRequest$1;
                }
            }, Map$.MODULE$.canBuildFrom());
            scala.collection.mutable.Map mergedResponseMap = responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
            ResponseHeader responseHeader = new ResponseHeader(correlationId);
            ListOffsetResponse response = new ListOffsetResponse((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(mergedResponseMap).asJava());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<Object> fetchOffsets(LogManager logManager, TopicPartition topicPartition, long timestamp, int maxNumOffsets) {
        Option<Log> option;
        block4: {
            Nil$ nil$;
            block3: {
                block2: {
                    option = logManager.getLog(new TopicAndPartition(topicPartition.topic(), topicPartition.partition()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Log log = (Log)some.x();
                    nil$ = this.fetchOffsetsBefore(log, timestamp, maxNumOffsets);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                nil$ = timestamp == -1L || timestamp == -2L ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError(option);
    }

    private Seq<Object> fetchOffsetsBefore(Log log, long timestamp, int maxNumOffsets) {
        LogSegment[] segsArray = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        ObjectRef offsetTimeArray = new ObjectRef(null);
        offsetTimeArray.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray).last()).size() > 0L ? new Tuple2[segsArray.length + 1] : new Tuple2[segsArray.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segsArray.length).foreach$mVc$sp((Function1)new Serializable(this, segsArray, offsetTimeArray){
            public static final long serialVersionUID = 0L;
            private final LogSegment[] segsArray$1;
            private final ObjectRef offsetTimeArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((Tuple2[])this.offsetTimeArray$1.elem)[i] = new Tuple2.mcJJ.sp(this.segsArray$1[i].baseOffset(), this.segsArray$1[i].lastModified());
            }
            {
                this.segsArray$1 = segsArray$1;
                this.offsetTimeArray$1 = offsetTimeArray$1;
            }
        });
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray.elem)[segsArray.length] = new Tuple2.mcJJ.sp(log.logEndOffset(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex = new IntRef(-1);
        long l = timestamp;
        if (-1L == l) {
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (-2L == l) {
            startIndex.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)new Serializable(this, offsetTimeArray){
                public static final long serialVersionUID = 0L;
                private final ObjectRef offsetTimeArray$1;

                public final String apply() {
                    StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                    Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])this.offsetTimeArray$1.elem)).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, Object> o) {
                            return new StringOps(Predef$.MODULE$.augmentString("%d, %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)o._1$mcJ$sp()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())}));
                        }
                    });
                    return stringBuilder.append((Object)BoxedUnit.UNIT).toString();
                }
                {
                    this.offsetTimeArray$1 = offsetTimeArray$1;
                }
            });
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            while (startIndex.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray.elem)[startIndex.elem]._2$mcJ$sp() <= timestamp) {
                    isFound = true;
                    continue;
                }
                --startIndex.elem;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int retSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxNumOffsets), startIndex.elem + 1);
        long[] ret = new long[retSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), retSize).foreach$mVc$sp((Function1)new Serializable(this, offsetTimeArray, startIndex, ret){
            public static final long serialVersionUID = 0L;
            private final ObjectRef offsetTimeArray$1;
            private final IntRef startIndex$1;
            private final long[] ret$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.ret$1[j] = ((Tuple2[])this.offsetTimeArray$1.elem)[this.startIndex$1.elem]._1$mcJ$sp();
                --this.startIndex$1.elem;
            }
            {
                this.offsetTimeArray$1 = offsetTimeArray$1;
                this.startIndex$1 = startIndex$1;
                this.ret$1 = ret$1;
            }
        });
        return (Seq)Predef$.MODULE$.longArrayOps(ret).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$22) {
                return this.apply$mcJJ$sp(x$22);
            }

            public long apply$mcJJ$sp(long x$22) {
                return -x$22;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicMetadata> getTopicMetadata(scala.collection.Set<String> topics, SecurityProtocol securityProtocol) {
        void var3_3;
        ListBuffer<TopicMetadata> topicResponses = this.metadataCache().getTopicMetadata(topics, securityProtocol);
        if (topics.size() > 0 && topicResponses.size() != topics.size()) {
            scala.collection.Set nonExistentTopics = (scala.collection.Set)topics.$minus$minus((GenTraversableOnce)((TraversableForwarder)topicResponses.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicMetadata x$23) {
                    return x$23.topic();
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).toSet());
            scala.collection.Set responsesForNonExistentTopics = (scala.collection.Set)nonExistentTopics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final TopicMetadata apply(String topic) {
                    TopicMetadata topicMetadata;
                    String string = topic;
                    String string2 = GroupCoordinator$.MODULE$.GroupMetadataTopicName();
                    if ((string == null ? string2 != null : !string.equals(string2)) && !this.$outer.config().autoCreateTopicsEnable()) {
                        topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), Errors.UNKNOWN_TOPIC_OR_PARTITION.code());
                        return topicMetadata;
                    }
                    try {
                        String string3 = topic;
                        String string4 = GroupCoordinator$.MODULE$.GroupMetadataTopicName();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            Seq<Broker> aliveBrokers = this.$outer.metadataCache().getAliveBrokers();
                            int offsetsTopicReplicationFactor = aliveBrokers.length() > 0 ? Math.min(Predef$.MODULE$.Short2short(this.$outer.config().offsetsTopicReplicationFactor()), aliveBrokers.length()) : Predef$.MODULE$.Short2short(this.$outer.config().offsetsTopicReplicationFactor());
                            AdminUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topic, Predef$.MODULE$.Integer2int(this.$outer.config().offsetsTopicPartitions()), offsetsTopicReplicationFactor, this.$outer.coordinator().offsetsTopicConfigs());
                            this.$outer.info((Function0<String>)new Serializable(this, topic, offsetsTopicReplicationFactor){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$24 $outer;
                                private final String topic$1;
                                private final int offsetsTopicReplicationFactor$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().offsetsTopicPartitions(), BoxesRunTime.boxToInteger((int)this.offsetsTopicReplicationFactor$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$1 = topic$1;
                                    this.offsetsTopicReplicationFactor$1 = offsetsTopicReplicationFactor$1;
                                }
                            });
                        } else {
                            AdminUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topic, Predef$.MODULE$.Integer2int(this.$outer.config().numPartitions()), this.$outer.config().defaultReplicationFactor(), AdminUtils$.MODULE$.createTopic$default$5());
                            this.$outer.info((Function0<String>)new Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$24 $outer;
                                private final String topic$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().numPartitions(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().defaultReplicationFactor())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$1 = topic$1;
                                }
                            });
                        }
                        topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), Errors.LEADER_NOT_AVAILABLE.code());
                        return topicMetadata;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), Errors.INVALID_TOPIC_EXCEPTION.code());
                        return topicMetadata;
                    }
                    catch (TopicExistsException topicExistsException) {
                        topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), Errors.LEADER_NOT_AVAILABLE.code());
                    }
                    return topicMetadata;
                }

                public /* synthetic */ KafkaApis kafka$server$KafkaApis$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            topicResponses.appendAll((TraversableOnce)responsesForNonExistentTopics);
        }
        return var3_3;
    }

    public void handleTopicMetadataRequest(RequestChannel.Request request) {
        Set set;
        TopicMetadataRequest metadataRequest = (TopicMetadataRequest)request.requestObj();
        if (metadataRequest.topics().isEmpty()) {
            ListBuffer<TopicMetadata> topicResponses = this.metadataCache().getTopicMetadata((scala.collection.Set<String>)metadataRequest.topics().toSet(), request.securityProtocol());
            set = ((TraversableForwarder)((TraversableLike)topicResponses.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicMetadata x$24) {
                    return x$24.topic();
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$5;

                public final boolean apply(String topic) {
                    return this.$outer.kafka$server$KafkaApis$$authorize(this.request$5.session(), Describe$.MODULE$, new Resource(Topic$.MODULE$, topic));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$5 = request$5;
                }
            })).toSet();
        } else {
            set = metadataRequest.topics().toSet();
        }
        Set topics = set;
        Tuple2 tuple2 = topics.partition((Function1)new $anonfun$27(this, request));
        if (tuple2 != null) {
            Tuple2 tuple22;
            Set authorizedTopics = (Set)tuple2._1();
            Set unauthorizedTopics = (Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedTopics);
            ObjectRef authorizedTopics2 = new ObjectRef((Object)((Set)tuple23._1()));
            ObjectRef unauthorizedTopics2 = new ObjectRef((Object)((Set)tuple23._2()));
            if (!((Set)authorizedTopics2.elem).isEmpty()) {
                ListBuffer<TopicMetadata> topicResponses = this.metadataCache().getTopicMetadata((scala.collection.Set<String>)((Set)authorizedTopics2.elem), request.securityProtocol());
                if (this.config().autoCreateTopicsEnable() && topicResponses.size() != ((Set)authorizedTopics2.elem).size()) {
                    scala.collection.Set nonExistentTopics = (scala.collection.Set)topics.$minus$minus((GenTraversableOnce)((TraversableForwarder)topicResponses.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(TopicMetadata x$26) {
                            return x$26.topic();
                        }
                    }, ListBuffer$.MODULE$.canBuildFrom())).toSet());
                    this.authorizer().foreach((Function1)new Serializable(this, request, authorizedTopics2, unauthorizedTopics2, nonExistentTopics){
                        public static final long serialVersionUID = 0L;
                        private final RequestChannel.Request request$5;
                        private final ObjectRef authorizedTopics$1;
                        private final ObjectRef unauthorizedTopics$1;
                        private final scala.collection.Set nonExistentTopics$1;

                        public final void apply(Authorizer az) {
                            if (!az.authorize(this.request$5.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                                this.authorizedTopics$1.elem = (Set)((Set)this.authorizedTopics$1.elem).$minus$minus((GenTraversableOnce)this.nonExistentTopics$1);
                                this.unauthorizedTopics$1.elem = (Set)((Set)this.unauthorizedTopics$1.elem).$plus$plus((GenTraversableOnce)this.nonExistentTopics$1);
                            }
                        }
                        {
                            this.request$5 = request$5;
                            this.authorizedTopics$1 = authorizedTopics$1;
                            this.unauthorizedTopics$1 = unauthorizedTopics$1;
                            this.nonExistentTopics$1 = nonExistentTopics$1;
                        }
                    });
                }
            }
            Set unauthorizedTopicMetaData = (Set)((Set)unauthorizedTopics2.elem).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicMetadata apply(String topic) {
                    return new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), Errors.TOPIC_AUTHORIZATION_FAILED.code());
                }
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
            Seq<TopicMetadata> topicMetadata = ((Set)authorizedTopics2.elem).isEmpty() ? (Seq<TopicMetadata>)Seq$.MODULE$.empty() : this.getTopicMetadata((scala.collection.Set<String>)((Set)authorizedTopics2.elem), request.securityProtocol());
            Seq<Broker> brokers = this.metadataCache().getAliveBrokers();
            this.trace((Function0<String>)new Serializable(this, metadataRequest, topicMetadata, brokers){
                public static final long serialVersionUID = 0L;
                private final TopicMetadataRequest metadataRequest$1;
                private final Seq topicMetadata$1;
                private final Seq brokers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending topic metadata %s and brokers %s for correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicMetadata$1.mkString(","), this.brokers$1.mkString(","), BoxesRunTime.boxToInteger((int)this.metadataRequest$1.correlationId()), this.metadataRequest$1.clientId()}));
                }
                {
                    this.metadataRequest$1 = metadataRequest$1;
                    this.topicMetadata$1 = topicMetadata$1;
                    this.brokers$1 = brokers$1;
                }
            });
            TopicMetadataResponse response = new TopicMetadataResponse((Seq<BrokerEndPoint>)((Seq)brokers.map((Function1)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$5;

                public final BrokerEndPoint apply(Broker x$27) {
                    return x$27.getBrokerEndPoint(this.request$5.securityProtocol());
                }
                {
                    this.request$5 = request$5;
                }
            }, Seq$.MODULE$.canBuildFrom())), (Seq<TopicMetadata>)((Seq)topicMetadata.$plus$plus((GenTraversableOnce)unauthorizedTopicMetaData, Seq$.MODULE$.canBuildFrom())), metadataRequest.correlationId());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), response)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public void handleOffsetFetchRequest(RequestChannel.Request request) {
        void var2_2;
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)request.requestObj();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetFetchRequest.groupId()))) {
            Tuple2 tuple2 = offsetFetchRequest.requestInfo().partition((Function1)new $anonfun$32(this, request));
            if (tuple2 != null) {
                OffsetFetchResponse offsetFetchResponse;
                Tuple2 tuple22;
                Seq authorizedTopicPartitions = (Seq)tuple2._1();
                Seq unauthorizedTopicPartitions = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)authorizedTopicPartitions, (Object)unauthorizedTopicPartitions);
                Seq authorizedTopicPartitions2 = (Seq)tuple23._1();
                Seq unauthorizedTopicPartitions2 = (Seq)tuple23._2();
                OffsetMetadataAndError authorizationError = new OffsetMetadataAndError(OffsetMetadata$.MODULE$.InvalidOffsetMetadata(), Errors.TOPIC_AUTHORIZATION_FAILED.code());
                scala.collection.immutable.Map unauthorizedStatus = ((TraversableOnce)unauthorizedTopicPartitions2.map((Function1)new Serializable(this, authorizationError){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMetadataAndError authorizationError$1;

                    public final Tuple2<TopicAndPartition, OffsetMetadataAndError> apply(TopicAndPartition topicAndPartition) {
                        return new Tuple2((Object)topicAndPartition, (Object)this.authorizationError$1);
                    }
                    {
                        this.authorizationError$1 = authorizationError$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                if (offsetFetchRequest.versionId() == 0) {
                    Seq responseInfo = (Seq)authorizedTopicPartitions2.map((Function1)new Serializable(this, request, offsetFetchRequest){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaApis $outer;
                        private final RequestChannel.Request request$7;
                        private final OffsetFetchRequest offsetFetchRequest$1;

                        public final Tuple2<TopicAndPartition, OffsetMetadataAndError> apply(TopicAndPartition topicAndPartition) {
                            Tuple2 tuple2;
                            block5: {
                                ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.offsetFetchRequest$1.groupId(), topicAndPartition.topic());
                                try {
                                    Option option;
                                    block8: {
                                        Tuple2 tuple22;
                                        block7: {
                                            block6: {
                                                if (this.$outer.metadataCache().getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicAndPartition.topic()}))), this.request$7.securityProtocol()).size() <= 0) {
                                                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition());
                                                    break block5;
                                                }
                                                Option payloadOpt = (Option)this.$outer.zkUtils().readDataMaybeNull(new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition.partition())).toString())._1();
                                                option = payloadOpt;
                                                if (!(option instanceof Some)) break block6;
                                                Some some = (Some)option;
                                                String payload = (String)some.x();
                                                tuple22 = new Tuple2((Object)topicAndPartition, (Object)OffsetMetadataAndError$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(payload)).toLong()));
                                                break block7;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option option2 = option;
                                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                                            tuple22 = new Tuple2((Object)topicAndPartition, (Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition());
                                        }
                                        tuple2 = tuple22;
                                        break block5;
                                    }
                                    throw new MatchError((Object)option);
                                }
                                catch (Throwable throwable) {
                                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)new OffsetMetadataAndError(OffsetMetadata$.MODULE$.InvalidOffsetMetadata(), Errors.forException((Throwable)throwable).code()));
                                }
                            }
                            return tuple2;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.request$7 = request$7;
                            this.offsetFetchRequest$1 = offsetFetchRequest$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    offsetFetchResponse = new OffsetFetchResponse((scala.collection.immutable.Map<TopicAndPartition, OffsetMetadataAndError>)((scala.collection.immutable.MapLike)scala.collection.immutable.Map$.MODULE$.apply(responseInfo)).$plus$plus((GenTraversableOnce)unauthorizedStatus), offsetFetchRequest.correlationId());
                } else {
                    scala.collection.immutable.Map offsets = this.coordinator().handleFetchOffsets(offsetFetchRequest.groupId(), (Seq<TopicAndPartition>)authorizedTopicPartitions2).toMap(Predef$.MODULE$.conforms());
                    offsetFetchResponse = new OffsetFetchResponse((scala.collection.immutable.Map<TopicAndPartition, OffsetMetadataAndError>)offsets.$plus$plus((GenTraversableOnce)unauthorizedStatus), offsetFetchRequest.correlationId());
                }
                OffsetFetchResponse response = offsetFetchResponse;
                this.trace((Function0<String>)new Serializable(this, offsetFetchRequest, response){
                    public static final long serialVersionUID = 0L;
                    private final OffsetFetchRequest offsetFetchRequest$1;
                    private final OffsetFetchResponse response$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Sending offset fetch response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1, BoxesRunTime.boxToInteger((int)this.offsetFetchRequest$1.correlationId()), this.offsetFetchRequest$1.clientId()}));
                    }
                    {
                        this.offsetFetchRequest$1 = offsetFetchRequest$1;
                        this.response$1 = response$1;
                    }
                });
                this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), response)));
                return;
            }
            throw new MatchError((Object)tuple2);
        }
        OffsetMetadataAndError authorizationError = new OffsetMetadataAndError(OffsetMetadata$.MODULE$.InvalidOffsetMetadata(), Errors.GROUP_AUTHORIZATION_FAILED.code());
        OffsetFetchResponse response = new OffsetFetchResponse((scala.collection.immutable.Map<TopicAndPartition, OffsetMetadataAndError>)((TraversableOnce)var2_2.requestInfo().map((Function1)new Serializable(this, authorizationError){
            public static final long serialVersionUID = 0L;
            private final OffsetMetadataAndError authorizationError$2;

            public final Tuple2<TopicAndPartition, OffsetMetadataAndError> apply(TopicAndPartition x$28) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)x$28), (Object)this.authorizationError$2);
            }
            {
                this.authorizationError$2 = authorizationError$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()), OffsetFetchResponse$.MODULE$.apply$default$2());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), response)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleGroupCoordinatorRequest(RequestChannel.Request request) {
        GroupCoordinatorRequest groupCoordinatorRequest = (GroupCoordinatorRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, groupCoordinatorRequest.groupId()))) {
            GroupCoordinatorResponse groupCoordinatorResponse;
            Option coordinatorEndpoint;
            int partition = this.coordinator().partitionFor(groupCoordinatorRequest.groupId());
            TopicMetadata offsetsTopicMetadata = (TopicMetadata)this.getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{GroupCoordinator$.MODULE$.GroupMetadataTopicName()}))), request.securityProtocol()).head();
            Option option = coordinatorEndpoint = offsetsTopicMetadata.partitionsMetadata().find((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final int partition$1;

                public final boolean apply(PartitionMetadata x$30) {
                    return x$30.partitionId() == this.partition$1;
                }
                {
                    this.partition$1 = partition$1;
                }
            }).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<BrokerEndPoint> apply(PartitionMetadata partitionMetadata) {
                    return partitionMetadata.leader();
                }
            });
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                groupCoordinatorResponse = new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                BrokerEndPoint endpoint = (BrokerEndPoint)some.x();
                groupCoordinatorResponse = new GroupCoordinatorResponse(Errors.NONE.code(), new Node(endpoint.id(), endpoint.host(), endpoint.port()));
            }
            GroupCoordinatorResponse responseBody = groupCoordinatorResponse;
            this.trace((Function0<String>)new Serializable(this, request, responseBody){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$8;
                private final GroupCoordinatorResponse responseBody$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending consumer metadata %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseBody$1, BoxesRunTime.boxToInteger((int)this.request$8.header().correlationId()), this.request$8.header().clientId()}));
                }
                {
                    this.request$8 = request$8;
                    this.responseBody$1 = responseBody$1;
                }
            });
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
            return;
        } else {
            GroupCoordinatorResponse responseBody = new GroupCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), Node.noNode());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public void handleDescribeGroupRequest(RequestChannel.Request request) {
        DescribeGroupsRequest describeRequest = (DescribeGroupsRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        scala.collection.immutable.Map groups = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeRequest.groupIds()).asScala()).map((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$13;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<String, DescribeGroupsResponse.GroupMetadata> apply(String x0$12) {
                Tuple2 tuple2;
                String string = x0$12;
                if (this.$outer.kafka$server$KafkaApis$$authorize(this.request$13.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, string))) {
                    Tuple2 tuple22;
                    Tuple2<Errors, GroupSummary> tuple23 = this.$outer.coordinator().handleDescribeGroup(string);
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Errors error = (Errors)tuple23._1();
                    GroupSummary summary = (GroupSummary)tuple23._2();
                    Tuple2 tuple24 = tuple22 = new Tuple2((Object)error, (Object)summary);
                    Errors error2 = (Errors)tuple24._1();
                    GroupSummary summary2 = (GroupSummary)tuple24._2();
                    List members = (List)summary2.members().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DescribeGroupsResponse.GroupMember apply(MemberSummary member) {
                            ByteBuffer metadata = ByteBuffer.wrap(member.metadata());
                            ByteBuffer assignment = ByteBuffer.wrap(member.assignment());
                            return new DescribeGroupsResponse.GroupMember(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)string), (Object)new DescribeGroupsResponse.GroupMetadata(error2.code(), summary2.state(), summary2.protocolType(), summary2.protocol(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)members).asJava()));
                    return tuple2;
                } else {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)string), (Object)DescribeGroupsResponse.GroupMetadata.forError((Errors)Errors.GROUP_AUTHORIZATION_FAILED));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$13 = request$13;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        DescribeGroupsResponse responseBody = new DescribeGroupsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)groups).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleListGroupsRequest(RequestChannel.Request request) {
        ListGroupsResponse listGroupsResponse;
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Describe$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2 tuple2;
            Tuple2<Errors, List<GroupOverview>> tuple22 = this.coordinator().handleListGroups();
            if (tuple22 == null) throw new MatchError(tuple22);
            Errors error = (Errors)tuple22._1();
            List groups = (List)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            List allGroups = (List)groups2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ListGroupsResponse.Group apply(GroupOverview group) {
                    return new ListGroupsResponse.Group(group.groupId(), group.protocolType());
                }
            }, List$.MODULE$.canBuildFrom());
            listGroupsResponse = new ListGroupsResponse(error2.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allGroups).asJava());
        } else {
            listGroupsResponse = ListGroupsResponse.fromError((Errors)Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        ListGroupsResponse responseBody = listGroupsResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void handleJoinGroupRequest(RequestChannel.Request request) {
        JoinGroupRequest joinGroupRequest = (JoinGroupRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, joinGroupRequest.groupId()))) {
            List protocols2 = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(joinGroupRequest.groupProtocols()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, byte[]> apply(JoinGroupRequest.ProtocolMetadata protocol) {
                    return new Tuple2((Object)protocol.name(), (Object)Utils.toArray((ByteBuffer)protocol.metadata()));
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            this.coordinator().handleJoinGroup(joinGroupRequest.groupId(), joinGroupRequest.memberId(), request.header().clientId(), request.session().clientAddress().toString(), joinGroupRequest.sessionTimeout(), joinGroupRequest.protocolType(), (List<Tuple2<String, byte[]>>)protocols2, (Function1<JoinGroupResult, BoxedUnit>)new Serializable(this, request, responseHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$9;
                private final ResponseHeader responseHeader$1;

                public final void apply(JoinGroupResult joinResult) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$4(joinResult, this.request$9, this.responseHeader$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$9 = request$9;
                    this.responseHeader$1 = responseHeader$1;
                }
            });
        } else {
            JoinGroupResponse responseBody = new JoinGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), -1, "", "", "", JavaConversions$.MODULE$.mapAsJavaMap((Map)scala.collection.Map$.MODULE$.empty()));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public void handleSyncGroupRequest(RequestChannel.Request request) {
        SyncGroupRequest syncGroupRequest = (SyncGroupRequest)request.body();
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, syncGroupRequest.groupId()))) {
            this.coordinator().handleSyncGroup(syncGroupRequest.groupId(), syncGroupRequest.generationId(), syncGroupRequest.memberId(), (Map<String, byte[]>)JavaConversions$.MODULE$.mapAsScalaMap(syncGroupRequest.groupAssignment()).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(ByteBuffer x$33) {
                    return Utils.toArray((ByteBuffer)x$33);
                }
            }), (Function2<byte[], Object, BoxedUnit>)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$12;

                public final void apply(byte[] memberState, short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$5(memberState, errorCode, this.request$12);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$12 = request$12;
                }
            });
        } else {
            this.kafka$server$KafkaApis$$sendResponseCallback$5((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.GROUP_AUTHORIZATION_FAILED.code(), request);
        }
    }

    public void handleHeartbeatRequest(RequestChannel.Request request) {
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, heartbeatRequest.groupId()))) {
            this.coordinator().handleHeartbeat(heartbeatRequest.groupId(), heartbeatRequest.memberId(), heartbeatRequest.groupGenerationId(), (Function1<Object, BoxedUnit>)new Serializable(this, request, respHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$10;
                private final ResponseHeader respHeader$1;

                public final void apply(short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$6(errorCode, this.request$10, this.respHeader$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$10 = request$10;
                    this.respHeader$1 = respHeader$1;
                }
            });
        } else {
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)heartbeatResponse)));
        }
    }

    private Map<Object, ClientQuotaManager> instantiateQuotaManagers(KafkaConfig cfg) {
        ClientQuotaManagerConfig producerQuotaManagerCfg = new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
        ClientQuotaManagerConfig consumerQuotaManagerCfg = new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
        Map quotaManagers = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToShort((short)ApiKeys.PRODUCE.id)), (Object)new ClientQuotaManager(producerQuotaManagerCfg, this.metrics(), ApiKeys.PRODUCE.name, (Time)new SystemTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id)), (Object)new ClientQuotaManager(consumerQuotaManagerCfg, this.metrics(), ApiKeys.FETCH.name, (Time)new SystemTime()))}));
        return quotaManagers;
    }

    public void handleLeaveGroupRequest(RequestChannel.Request request) {
        LeaveGroupRequest leaveGroupRequest = (LeaveGroupRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (this.kafka$server$KafkaApis$$authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, leaveGroupRequest.groupId()))) {
            this.coordinator().handleLeaveGroup(leaveGroupRequest.groupId(), leaveGroupRequest.memberId(), (Function1<Object, BoxedUnit>)new Serializable(this, request, respHeader){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$11;
                private final ResponseHeader respHeader$2;

                public final void apply(short errorCode) {
                    this.$outer.kafka$server$KafkaApis$$sendResponseCallback$7(errorCode, this.request$11, this.respHeader$2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$11 = request$11;
                    this.respHeader$2 = respHeader$2;
                }
            });
        } else {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)leaveGroupResponse)));
        }
    }

    public void close() {
        this.quotaManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, ClientQuotaManager> x0$14) {
                Tuple2<Object, ClientQuotaManager> tuple2 = x0$14;
                if (tuple2 != null) {
                    ClientQuotaManager quotaManager = (ClientQuotaManager)tuple2._2();
                    quotaManager.shutdown();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public void authorizeClusterAction(RequestChannel.Request request) {
        if (this.kafka$server$KafkaApis$$authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            return;
        }
        throw new ClusterAuthorizationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " is not authorized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
    }

    public final void kafka$server$KafkaApis$$onLeadershipChange$1(Iterable updatedLeaders, Iterable updatedFollowers) {
        updatedLeaders.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;

            public final void apply(Partition partition) {
                String string = partition.topic();
                String string2 = GroupCoordinator$.MODULE$.GroupMetadataTopicName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.coordinator().handleGroupImmigration(partition.partitionId());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        updatedFollowers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;

            public final void apply(Partition partition) {
                String string = partition.topic();
                String string2 = GroupCoordinator$.MODULE$.GroupMetadataTopicName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.coordinator().handleGroupEmigration(partition.partitionId());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$1(scala.collection.immutable.Map commitStatus, RequestChannel.Request request$6, OffsetCommitRequest offsetCommitRequest$1, scala.collection.immutable.Map invalidRequestsInfo$1, scala.collection.immutable.Map unauthorizedRequestInfo$1) {
        scala.collection.immutable.Map mergedCommitStatus = commitStatus.$plus$plus((GenTraversableOnce)unauthorizedRequestInfo$1.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(OffsetAndMetadata x$7) {
                return Errors.TOPIC_AUTHORIZATION_FAILED.code();
            }
        }));
        mergedCommitStatus.foreach((Function1)new Serializable(this, offsetCommitRequest$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final OffsetCommitRequest offsetCommitRequest$1;

            public final void apply(Tuple2<TopicAndPartition, Object> x0$3) {
                Tuple2<TopicAndPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    short errorCode = BoxesRunTime.unboxToShort((Object)tuple2._2());
                    if (errorCode != Errors.NONE.code()) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition, errorCode){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$1$1 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final short errorCode$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset commit request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.offsetCommitRequest$1.correlationId()), this.$outer.offsetCommitRequest$1.clientId(), this.topicAndPartition$1, Errors.forCode((short)this.errorCode$1).exceptionName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.errorCode$1 = errorCode$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetCommitRequest$1 = offsetCommitRequest$1;
            }
        });
        scala.collection.immutable.Map combinedCommitStatus = mergedCommitStatus.$plus$plus((GenTraversableOnce)invalidRequestsInfo$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x$8) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x$8._1()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()));
        OffsetCommitResponse response = new OffsetCommitResponse((scala.collection.immutable.Map<TopicAndPartition, Object>)combinedCommitStatus, offsetCommitRequest$1.correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$6, (Send)new RequestOrResponseSend(request$6.connectionId(), response)));
    }

    public final void kafka$server$KafkaApis$$produceResponseCallback$1(int delayTimeMs, RequestChannel.Request request$2, ProduceRequest produceRequest$1, Map mergedResponseStatus$1, BooleanRef errorInResponse$1) {
        if (produceRequest$1.acks() == 0) {
            if (errorInResponse$1.elem) {
                String exceptionsSummary = ((TraversableOnce)mergedResponseStatus$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, String> apply(Tuple2<TopicPartition, ProduceResponse.PartitionResponse> x0$7) {
                        Tuple2<TopicPartition, ProduceResponse.PartitionResponse> tuple2 = x0$7;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)Errors.forCode((short)status.errorCode).exceptionName());
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, scala.collection.Map$.MODULE$.canBuildFrom())).mkString(", ");
                this.info((Function0<String>)new Serializable(this, request$2, exceptionsSummary){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$2;
                    private final String exceptionsSummary$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing connection due to error during produce request with correlation id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.request$2.header().correlationId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from client id ", " with ack=0\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$2.header().clientId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic and partition to exceptions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exceptionsSummary$1}))).toString();
                    }
                    {
                        this.request$2 = request$2;
                        this.exceptionsSummary$1 = exceptionsSummary$1;
                    }
                });
                this.requestChannel().closeConnection(request$2.processor(), request$2);
            } else {
                this.requestChannel().noOperation(request$2.processor(), request$2);
            }
        } else {
            ProduceResponse produceResponse;
            ResponseHeader respHeader = new ResponseHeader(request$2.header().correlationId());
            short s = request$2.header().apiVersion();
            switch (s) {
                default: {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Version %d of ProducerRequest is not handled. Code must be updated.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)request$2.header().apiVersion())})));
                }
                case 1: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava(), delayTimeMs);
                    break;
                }
                case 0: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava());
                }
            }
            ProduceResponse respBody = produceResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request$2, (Send)new ResponseSend(request$2.connectionId(), respHeader, (AbstractRequestResponse)respBody)));
        }
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$2(Map responseStatus, RequestChannel.Request request$2, ProduceRequest produceRequest$1, int numBytesAppended$1, scala.collection.mutable.Map unauthorizedRequestInfo$2) {
        Map mergedResponseStatus = responseStatus.$plus$plus((GenTraversableOnce)unauthorizedRequestInfo$2.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ProduceResponse.PartitionResponse apply(ByteBuffer x$11) {
                return new ProduceResponse.PartitionResponse(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L);
            }
        }));
        BooleanRef errorInResponse = new BooleanRef(false);
        mergedResponseStatus.foreach((Function1)new Serializable(this, request$2, errorInResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final RequestChannel.Request request$2;
            private final BooleanRef errorInResponse$1;

            public final void apply(Tuple2<TopicPartition, ProduceResponse.PartitionResponse> x0$6) {
                Tuple2<TopicPartition, ProduceResponse.PartitionResponse> tuple2 = x0$6;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                    if (status.errorCode != Errors.NONE.code()) {
                        this.errorInResponse$1.elem = true;
                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, status){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$2$2 $outer;
                            private final TopicPartition topicPartition$1;
                            private final ProduceResponse.PartitionResponse status$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.request$2.header().correlationId()), this.$outer.request$2.header().clientId(), this.topicPartition$1, Errors.forCode((short)this.status$1.errorCode).exceptionName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicPartition$1 = topicPartition$1;
                                this.status$1 = status$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.errorInResponse$1 = errorInResponse$1;
            }
        });
        request$2.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        ((ClientQuotaManager)this.quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)ApiKeys.PRODUCE.id))).recordAndMaybeThrottle(request$2.header().clientId(), numBytesAppended$1, (Function1<Object, BoxedUnit>)new Serializable(this, request$2, produceRequest$1, mergedResponseStatus, errorInResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final RequestChannel.Request request$2;
            private final ProduceRequest produceRequest$1;
            private final Map mergedResponseStatus$1;
            private final BooleanRef errorInResponse$1;

            public final void apply(int delayTimeMs) {
                this.apply$mcVI$sp(delayTimeMs);
            }

            public void apply$mcVI$sp(int delayTimeMs) {
                this.$outer.kafka$server$KafkaApis$$produceResponseCallback$1(delayTimeMs, this.request$2, this.produceRequest$1, this.mergedResponseStatus$1, this.errorInResponse$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.produceRequest$1 = produceRequest$1;
                this.mergedResponseStatus$1 = mergedResponseStatus$1;
                this.errorInResponse$1 = errorInResponse$1;
            }
        });
    }

    public final void kafka$server$KafkaApis$$fetchResponseCallback$1(int delayTimeMs, RequestChannel.Request request$3, FetchRequest fetchRequest$1, Map mergedResponseStatus$2) {
        FetchResponse response = new FetchResponse(fetchRequest$1.correlationId(), (Map<TopicAndPartition, FetchResponsePartitionData>)mergedResponseStatus$2, fetchRequest$1.versionId(), delayTimeMs);
        this.requestChannel().sendResponse(new RequestChannel.Response(request$3, new FetchResponseSend(request$3.connectionId(), response)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$3(Map responsePartitionData, RequestChannel.Request request$3, FetchRequest fetchRequest$1, scala.collection.immutable.Map unauthorizedResponseStatus$1) {
        Map mergedResponseStatus = responsePartitionData.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus$1);
        mergedResponseStatus.foreach((Function1)new Serializable(this, fetchRequest$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final FetchRequest fetchRequest$1;

            public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$10) {
                Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$10;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    FetchResponsePartitionData data = (FetchResponsePartitionData)tuple2._2();
                    if (data.error() != Errors.NONE.code()) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition, data){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$KafkaApis$$sendResponseCallback$3$2 $outer;
                            private final TopicAndPartition topicAndPartition$2;
                            private final FetchResponsePartitionData data$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Fetch request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.correlationId()), this.$outer.fetchRequest$1.clientId(), this.topicAndPartition$2, Errors.forCode((short)this.data$1.error()).exceptionName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$2 = topicAndPartition$2;
                                this.data$1 = data$1;
                            }
                        });
                    }
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).bytesOutRate().mark((long)data.messages().sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesOutRate().mark((long)data.messages().sizeInBytes());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetchRequest$1 = fetchRequest$1;
            }
        });
        request$3.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        if (fetchRequest$1.isFromFollower()) {
            this.kafka$server$KafkaApis$$fetchResponseCallback$1(0, request$3, fetchRequest$1, mergedResponseStatus);
        } else {
            ((ClientQuotaManager)this.quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id))).recordAndMaybeThrottle(fetchRequest$1.clientId(), FetchResponse$.MODULE$.responseSize((Map<String, Map<TopicAndPartition, FetchResponsePartitionData>>)responsePartitionData.groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x$14) {
                    return ((TopicAndPartition)x$14._1()).topic();
                }
            }), fetchRequest$1.versionId()), (Function1<Object, BoxedUnit>)new Serializable(this, request$3, fetchRequest$1, mergedResponseStatus){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;
                private final RequestChannel.Request request$3;
                private final FetchRequest fetchRequest$1;
                private final Map mergedResponseStatus$2;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.kafka$server$KafkaApis$$fetchResponseCallback$1(delayTimeMs, this.request$3, this.fetchRequest$1, this.mergedResponseStatus$2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$3 = request$3;
                    this.fetchRequest$1 = fetchRequest$1;
                    this.mergedResponseStatus$2 = mergedResponseStatus$2;
                }
            });
        }
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$4(JoinGroupResult joinResult, RequestChannel.Request request$9, ResponseHeader responseHeader$1) {
        Map members = (Map)joinResult.members().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ByteBuffer> apply(Tuple2<String, byte[]> x0$13) {
                Tuple2<String, byte[]> tuple2 = x0$13;
                if (tuple2 != null) {
                    String memberId = (String)tuple2._1();
                    byte[] metadataArray = (byte[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)ByteBuffer.wrap(metadataArray));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        JoinGroupResponse responseBody = new JoinGroupResponse(joinResult.errorCode(), joinResult.generationId(), joinResult.subProtocol(), joinResult.memberId(), joinResult.leaderId(), JavaConversions$.MODULE$.mapAsJavaMap(members));
        this.trace((Function0<String>)new Serializable(this, request$9, responseBody){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$9;
            private final JoinGroupResponse responseBody$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending join group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseBody$2, BoxesRunTime.boxToInteger((int)this.request$9.header().correlationId()), this.request$9.header().clientId()}));
            }
            {
                this.request$9 = request$9;
                this.responseBody$2 = responseBody$2;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$9, (Send)new ResponseSend(request$9.connectionId(), responseHeader$1, (AbstractRequestResponse)responseBody)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$5(byte[] memberState, short errorCode, RequestChannel.Request request$12) {
        SyncGroupResponse responseBody = new SyncGroupResponse(errorCode, ByteBuffer.wrap(memberState));
        ResponseHeader responseHeader = new ResponseHeader(request$12.header().correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$12, (Send)new ResponseSend(request$12.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$6(short errorCode, RequestChannel.Request request$10, ResponseHeader respHeader$1) {
        HeartbeatResponse response = new HeartbeatResponse(errorCode);
        this.trace((Function0<String>)new Serializable(this, request$10, response){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$10;
            private final HeartbeatResponse response$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending heartbeat response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2, BoxesRunTime.boxToInteger((int)this.request$10.header().correlationId()), this.request$10.header().clientId()}));
            }
            {
                this.request$10 = request$10;
                this.response$2 = response$2;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$10, (Send)new ResponseSend(request$10.connectionId(), respHeader$1, (AbstractRequestResponse)response)));
    }

    public final void kafka$server$KafkaApis$$sendResponseCallback$7(short errorCode, RequestChannel.Request request$11, ResponseHeader respHeader$2) {
        LeaveGroupResponse response = new LeaveGroupResponse(errorCode);
        this.trace((Function0<String>)new Serializable(this, request$11, response){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$11;
            private final LeaveGroupResponse response$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending leave group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$3, BoxesRunTime.boxToInteger((int)this.request$11.header().correlationId()), this.request$11.header().clientId()}));
            }
            {
                this.request$11 = request$11;
                this.response$3 = response$3;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request$11, (Send)new ResponseSend(request$11.connectionId(), respHeader$2, (AbstractRequestResponse)response)));
    }

    public KafkaApis(RequestChannel requestChannel, ReplicaManager replicaManager, GroupCoordinator coordinator, KafkaController controller, ZkUtils zkUtils, int brokerId, KafkaConfig config, MetadataCache metadataCache, Metrics metrics, Option<Authorizer> authorizer) {
        this.requestChannel = requestChannel;
        this.replicaManager = replicaManager;
        this.coordinator = coordinator;
        this.controller = controller;
        this.zkUtils = zkUtils;
        this.brokerId = brokerId;
        this.config = config;
        this.metadataCache = metadataCache;
        this.metrics = metrics;
        this.authorizer = authorizer;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[KafkaApi-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.quotaManagers = this.instantiateQuotaManagers(config);
    }
}

