/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;

@Description(name="named_struct", value="_FUNC_(name1, val1, name2, val2, ...) - Creates a struct with the given field names and values")
public class GenericUDFNamedStruct
extends GenericUDF {
    private transient Object[] ret;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int numFields = arguments.length;
        if (numFields % 2 == 1) {
            throw new UDFArgumentLengthException("NAMED_STRUCT expects an even number of arguments.");
        }
        this.ret = new Object[numFields / 2];
        ArrayList<String> fname = new ArrayList<String>(numFields / 2);
        ArrayList<ObjectInspector> retOIs = new ArrayList<ObjectInspector>(numFields / 2);
        for (int f = 0; f < numFields; f += 2) {
            if (!(arguments[f] instanceof WritableConstantStringObjectInspector)) {
                throw new UDFArgumentTypeException(f, "Even arguments to NAMED_STRUCT must be a constant STRING." + arguments[f].toString());
            }
            WritableConstantStringObjectInspector constantOI = (WritableConstantStringObjectInspector)arguments[f];
            fname.add(constantOI.getWritableConstantValue().toString());
            retOIs.add(arguments[f + 1]);
        }
        StandardStructObjectInspector soi = ObjectInspectorFactory.getStandardStructObjectInspector(fname, retOIs);
        return soi;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 0; i < arguments.length / 2; ++i) {
            this.ret[i] = arguments[2 * i + 1].get();
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("named_struct(");
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(children[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

