/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="concat_ws", value="_FUNC_(separator, [string | array(string)]+) - returns the concatenation of the strings separated by the separator.", extended="Example:\n  > SELECT _FUNC_('.', 'www', array('facebook', 'com')) FROM src LIMIT 1;\n  'www.facebook.com'")
public class GenericUDFConcatWS
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private final Text resultText = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function CONCAT_WS(separator,[string | array(string)]+) needs at least two arguments.");
        }
        block4: for (int i = 0; i < arguments.length; ++i) {
            switch (arguments[i].getCategory()) {
                case LIST: {
                    if (this.isStringOrVoidType(((ListObjectInspector)arguments[i]).getListElementObjectInspector())) continue block4;
                }
                case PRIMITIVE: {
                    if (this.isStringOrVoidType(arguments[i])) continue block4;
                }
                default: {
                    throw new UDFArgumentTypeException(i, "Argument " + (i + 1) + " of function CONCAT_WS must be \"" + "string" + " or " + "array" + "<" + "string" + ">\", but \"" + arguments[i].getTypeName() + "\" was found.");
                }
            }
        }
        this.argumentOIs = arguments;
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    protected boolean isStringOrVoidType(ObjectInspector oi) {
        return oi.getCategory() == ObjectInspector.Category.PRIMITIVE && (PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP == PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveObjectInspector)oi).getPrimitiveCategory()) || ((PrimitiveObjectInspector)oi).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VOID);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        String separator = PrimitiveObjectInspectorUtils.getString(arguments[0].get(), (PrimitiveObjectInspector)this.argumentOIs[0]);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 1; i < arguments.length; ++i) {
            if (arguments[i].get() == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            if (this.argumentOIs[i].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
                Object strArray = arguments[i].get();
                ListObjectInspector strArrayOI = (ListObjectInspector)this.argumentOIs[i];
                boolean strArrayFirst = true;
                for (int j = 0; j < strArrayOI.getListLength(strArray); ++j) {
                    if (strArrayFirst) {
                        strArrayFirst = false;
                    } else {
                        sb.append(separator);
                    }
                    sb.append(strArrayOI.getListElement(strArray, j));
                }
                continue;
            }
            sb.append(PrimitiveObjectInspectorUtils.getString(arguments[i].get(), (PrimitiveObjectInspector)this.argumentOIs[i]));
        }
        this.resultText.set(sb.toString());
        return this.resultText;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("concat_ws(");
        for (int i = 0; i < children.length - 1; ++i) {
            sb.append(children[i]).append(", ");
        }
        sb.append(children[children.length - 1]).append(")");
        return sb.toString();
    }
}

