/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class StatsUtils {
    private static final Log LOG = LogFactory.getLog((String)StatsUtils.class.getName());

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, TableScanOperator tableScanOperator) throws HiveException {
        ArrayList<ColumnInfo> schema = tableScanOperator.getSchema().getSignature();
        List<String> neededColumns = tableScanOperator.getNeededColumns();
        List<String> referencedColumns = tableScanOperator.getReferencedColumns();
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, referencedColumns);
    }

    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns) throws HiveException {
        boolean fetchColStats = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean fetchPartStats = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_FETCH_PARTITION_STATS);
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, referencedColumns, fetchColStats, fetchPartStats);
    }

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns, boolean fetchColStats, boolean fetchPartStats) throws HiveException {
        Statistics stats = new Statistics();
        float deserFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        if (!table.isPartitioned()) {
            int avgRowSize;
            long nr = StatsUtils.getNumRows(table);
            long ds = StatsUtils.getRawDataSize(table);
            if (ds <= 0L) {
                ds = StatsUtils.getTotalSize(table);
                if (ds <= 0L) {
                    ds = StatsUtils.getFileSizeForTable(conf, table);
                }
                ds = (long)((float)ds * deserFactor);
            }
            if (nr <= 0L && (avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns)) > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Estimated average row size: " + avgRowSize));
                }
                nr = ds / (long)avgRowSize;
            }
            stats.setNumRows(nr);
            stats.setDataSize(ds);
            List<ColStatistics> colStats = Lists.newArrayList();
            if (fetchColStats) {
                colStats = StatsUtils.getTableColumnStats(table, schema, neededColumns);
            }
            StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), colStats);
            stats.setColumnStatsState(StatsUtils.deriveStatType(colStats, neededColumns));
            stats.addToColumnStats(colStats);
        } else if (partList != null) {
            long nr = 0L;
            long ds = 0L;
            ArrayList<Long> rowCounts = Lists.newArrayList();
            List<Long> dataSizes = Lists.newArrayList();
            if (fetchPartStats) {
                rowCounts = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "numRows");
                dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "rawDataSize");
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (ds <= 0L) {
                    dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "totalSize");
                    ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                }
            }
            if (ds <= 0L) {
                dataSizes = StatsUtils.getFileSizeForPartitions(conf, partList.getNotDeniedPartns());
            }
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            ds = (long)((float)ds * deserFactor);
            int avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns);
            if (avgRowSize > 0) {
                StatsUtils.setUnknownRcDsToAverage(rowCounts, dataSizes, avgRowSize);
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (nr <= 0L) {
                    nr = ds / (long)avgRowSize;
                }
            }
            stats.addToNumRows(nr);
            stats.addToDataSize(ds);
            if (StatsUtils.containsNonPositives(rowCounts) && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE)) {
                stats.setBasicStatsState(Statistics.State.PARTIAL);
            }
            if (fetchColStats) {
                ArrayList<String> partNames = new ArrayList<String>(partList.getNotDeniedPartns().size());
                for (Partition part : partList.getNotDeniedPartns()) {
                    partNames.add(part.getName());
                }
                HashMap<String, String> colToTabAlias = new HashMap<String, String>();
                neededColumns = StatsUtils.processNeededColumns(schema, neededColumns, colToTabAlias);
                AggrStats aggrStats = Hive.get().getAggrColStatsFor(table.getDbName(), table.getTableName(), neededColumns, partNames);
                if (null == aggrStats) {
                    ArrayList<ColStatistics> emptyStats = Lists.newArrayList();
                    StatsUtils.addParitionColumnStats(conf, neededColumns, referencedColumns, schema, table, partList, emptyStats);
                    stats.addToColumnStats(emptyStats);
                    stats.updateColumnStatsState(StatsUtils.deriveStatType(emptyStats, referencedColumns));
                } else {
                    List colStats = aggrStats.getColStats();
                    if (colStats.size() != neededColumns.size()) {
                        LOG.debug((Object)("Column stats requested for : " + neededColumns.size() + " columns. Able to" + " retrieve for " + colStats.size() + " columns"));
                    }
                    List<ColStatistics> columnStats = StatsUtils.convertColStats(colStats, table.getTableName(), colToTabAlias);
                    StatsUtils.addParitionColumnStats(conf, neededColumns, referencedColumns, schema, table, partList, columnStats);
                    StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), columnStats);
                    stats.addToColumnStats(columnStats);
                    Statistics.State colState = StatsUtils.deriveStatType(columnStats, referencedColumns);
                    if (aggrStats.getPartsFound() != (long)partNames.size() && colState != Statistics.State.NONE) {
                        LOG.debug((Object)("Column stats requested for : " + partNames.size() + " partitions. " + "Able to retrieve for " + aggrStats.getPartsFound() + " partitions"));
                        colState = Statistics.State.PARTIAL;
                    }
                    stats.setColumnStatsState(colState);
                }
            }
        }
        return stats;
    }

    public static void inferAndSetPrimaryKey(long numRows, List<ColStatistics> colStats) {
        if (colStats != null) {
            for (ColStatistics cs : colStats) {
                if (cs == null || cs.getRange() == null || cs.getRange().minValue == null || cs.getRange().maxValue == null || numRows != cs.getRange().maxValue.longValue() - cs.getRange().minValue.longValue() + 1L) continue;
                cs.setPrimaryKey(true);
            }
        }
    }

    public static boolean inferForeignKey(ColStatistics csPK, ColStatistics csFK) {
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            ColStatistics.Range pkRange = csPK.getRange();
            ColStatistics.Range fkRange = csFK.getRange();
            return StatsUtils.isWithin(fkRange, pkRange);
        }
        return false;
    }

    private static boolean isWithin(ColStatistics.Range range1, ColStatistics.Range range2) {
        return range1.minValue != null && range2.minValue != null && range1.maxValue != null && range2.maxValue != null && range1.minValue.longValue() >= range2.minValue.longValue() && range1.maxValue.longValue() <= range2.maxValue.longValue();
    }

    private static void addParitionColumnStats(HiveConf conf, List<String> neededColumns, List<String> referencedColumns, List<ColumnInfo> schema, Table table, PrunedPartitionList partList, List<ColStatistics> colStats) throws HiveException {
        ArrayList<String> extraCols = Lists.newArrayList(referencedColumns);
        if (referencedColumns.size() > neededColumns.size()) {
            extraCols.removeAll(neededColumns);
            for (String col : extraCols) {
                for (ColumnInfo ci : schema) {
                    if (!col.equals(ci.getInternalName()) || !ci.getIsVirtualCol() || ci.isHiddenVirtualCol()) continue;
                    ColStatistics partCS = new ColStatistics(table.getTableName(), ci.getInternalName(), ci.getType().getTypeName());
                    long numPartitions = StatsUtils.getNDVPartitionColumn(partList.getPartitions(), ci.getInternalName());
                    partCS.setCountDistint(numPartitions);
                    partCS.setAvgColLen(StatsUtils.getAvgColLenOfVariableLengthTypes(conf, ci.getObjectInspector(), partCS.getColumnType()));
                    colStats.add(partCS);
                }
            }
        }
    }

    public static int getNDVPartitionColumn(Set<Partition> partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>(partitions.size());
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    private static void setUnknownRcDsToAverage(List<Long> rowCounts, List<Long> dataSizes, int avgRowSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Estimated average row size: " + avgRowSize));
        }
        for (int i = 0; i < rowCounts.size(); ++i) {
            long rc = rowCounts.get(i);
            long s = dataSizes.get(i);
            if (rc <= 0L && s > 0L) {
                rc = s / (long)avgRowSize;
                rowCounts.set(i, rc);
            }
            if (s > 0L || rc <= 0L) continue;
            s = StatsUtils.safeMult(rc, avgRowSize);
            dataSizes.set(i, s);
        }
    }

    public static int estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns) {
        int avgRowSize = 0;
        for (String neededCol : neededColumns) {
            ColumnInfo ci = StatsUtils.getColumnInfoForColumn(neededCol, schema);
            if (ci == null) continue;
            ObjectInspector oi = ci.getObjectInspector();
            String colTypeLowerCase = ci.getTypeName().toLowerCase();
            if (colTypeLowerCase.equals("string") || colTypeLowerCase.equals("binary") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("array") || colTypeLowerCase.startsWith("map") || colTypeLowerCase.startsWith("struct") || colTypeLowerCase.startsWith("uniontype")) {
                avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colTypeLowerCase));
                continue;
            }
            avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase));
        }
        return avgRowSize;
    }

    private static ColumnInfo getColumnInfoForColumn(String neededCol, List<ColumnInfo> schema) {
        for (ColumnInfo ci : schema) {
            if (!ci.getInternalName().equalsIgnoreCase(neededCol)) continue;
            return ci;
        }
        return null;
    }

    public static long getFileSizeForTable(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = fs.getContentSummary(path).getLength();
        }
        catch (Exception e) {
            size = 0L;
        }
        return size;
    }

    public static List<Long> getFileSizeForPartitions(HiveConf conf, List<Partition> parts) {
        ArrayList<Long> sizes = Lists.newArrayList();
        for (Partition part : parts) {
            Path path = part.getDataLocation();
            long size = 0L;
            try {
                FileSystem fs = path.getFileSystem((Configuration)conf);
                size = fs.getContentSummary(path).getLength();
            }
            catch (Exception e) {
                size = 0L;
            }
            sizes.add(size);
        }
        return sizes;
    }

    private static boolean containsNonPositives(List<Long> vals) {
        for (Long val : vals) {
            if (val > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getSumIgnoreNegatives(List<Long> vals) {
        long result = 0L;
        for (Long l : vals) {
            if (l <= 0L) continue;
            result = StatsUtils.safeAdd(result, l);
        }
        return result;
    }

    private static Statistics.State deriveStatType(List<ColStatistics> colStats, List<String> neededColumns) {
        boolean hasNull;
        boolean hasStats = false;
        boolean bl = hasNull = colStats == null || colStats.size() < neededColumns.size();
        if (colStats != null) {
            ColStatistics cs;
            boolean isNull;
            Iterator<ColStatistics> i$ = colStats.iterator();
            while (!(!i$.hasNext() || (hasNull |= (isNull = (cs = i$.next()) == null)) && (hasStats |= !isNull))) {
            }
        }
        Statistics.State result = hasStats ? (hasNull ? Statistics.State.PARTIAL : Statistics.State.COMPLETE) : (neededColumns.isEmpty() ? Statistics.State.COMPLETE : Statistics.State.NONE);
        return result;
    }

    public static ColStatistics getColStatistics(ColumnStatisticsObj cso, String tabName, String colName) {
        String colTypeLowerCase = cso.getColType().toLowerCase();
        ColStatistics cs = new ColStatistics(colName, colName, colTypeLowerCase);
        ColumnStatisticsData csd = cso.getStatsData();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("float")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("double")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setCountDistint(csd.getStringStats().getNumDVs());
            cs.setNumNulls(csd.getStringStats().getNumNulls());
            cs.setAvgColLen(csd.getStringStats().getAvgColLen());
        } else if (colTypeLowerCase.equals("boolean")) {
            if (csd.getBooleanStats().getNumFalses() > 0L && csd.getBooleanStats().getNumTrues() > 0L) {
                cs.setCountDistint(2L);
            } else {
                cs.setCountDistint(1L);
            }
            cs.setNumTrues(csd.getBooleanStats().getNumTrues());
            cs.setNumFalses(csd.getBooleanStats().getNumFalses());
            cs.setNumNulls(csd.getBooleanStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("binary")) {
            cs.setAvgColLen(csd.getBinaryStats().getAvgColLen());
            cs.setNumNulls(csd.getBinaryStats().getNumNulls());
        } else if (colTypeLowerCase.equals("timestamp")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setCountDistint(csd.getDecimalStats().getNumDVs());
            cs.setNumNulls(csd.getDecimalStats().getNumNulls());
            Decimal val = csd.getDecimalStats().getHighValue();
            BigDecimal maxVal = HiveDecimal.create(new BigInteger(val.getUnscaled()), val.getScale()).bigDecimalValue();
            val = csd.getDecimalStats().getLowValue();
            BigDecimal minVal = HiveDecimal.create(new BigInteger(val.getUnscaled()), val.getScale()).bigDecimalValue();
            cs.setRange(minVal, maxVal);
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
        } else {
            return null;
        }
        return cs;
    }

    public static List<ColStatistics> getTableColumnStats(Table table, List<ColumnInfo> schema, List<String> neededColumns) {
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        HashMap<String, String> colToTabAlias = new HashMap<String, String>(schema.size());
        List<String> neededColsInTable = StatsUtils.processNeededColumns(schema, neededColumns, colToTabAlias);
        List<ColStatistics> stats = null;
        try {
            List<ColumnStatisticsObj> colStat = Hive.get().getTableColumnStatistics(dbName, tabName, neededColsInTable);
            stats = StatsUtils.convertColStats(colStat, tabName, colToTabAlias);
        }
        catch (HiveException e) {
            LOG.error((Object)"Failed to retrieve table statistics: ", (Throwable)e);
            stats = null;
        }
        return stats;
    }

    private static List<ColStatistics> convertColStats(List<ColumnStatisticsObj> colStats, String tabName, Map<String, String> colToTabAlias) {
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(colStats.size());
        for (ColumnStatisticsObj statObj : colStats) {
            ColStatistics cs = StatsUtils.getColStatistics(statObj, tabName, statObj.getColName());
            if (cs == null) continue;
            cs.setTableAlias(colToTabAlias.get(cs.getColumnName()));
            stats.add(cs);
        }
        return stats;
    }

    private static List<String> processNeededColumns(List<ColumnInfo> schema, List<String> neededColumns, Map<String, String> colToTabAlias) {
        for (ColumnInfo col : schema) {
            if (col.isHiddenVirtualCol()) continue;
            colToTabAlias.put(col.getInternalName(), col.getTabAlias());
        }
        ArrayList<String> neededColsInTable = null;
        int limit = neededColumns.size();
        for (int i = 0; i < limit; ++i) {
            if (colToTabAlias.containsKey(neededColumns.get(i))) continue;
            if (neededColsInTable == null) {
                neededColsInTable = Lists.newArrayList(neededColumns);
            }
            neededColsInTable.remove(i--);
            --limit;
        }
        return neededColsInTable == null ? neededColumns : neededColsInTable;
    }

    public static long getAvgColLenOfVariableLengthTypes(HiveConf conf, ObjectInspector oi, String colType) {
        long configVarLen = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
        String colTypeLowCase = colType.toLowerCase();
        if (colTypeLowCase.equals("string")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantStringObjectInspector) {
                WritableConstantStringObjectInspector wcsoi = (WritableConstantStringObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableStringObjectInspector) {
                return configVarLen;
            }
        } else if (colTypeLowCase.startsWith("varchar")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantHiveVarcharObjectInspector) {
                WritableConstantHiveVarcharObjectInspector wcsoi = (WritableConstantHiveVarcharObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableHiveVarcharObjectInspector) {
                return ((WritableHiveVarcharObjectInspector)oi).getMaxLength();
            }
        } else if (colTypeLowCase.startsWith("char")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantHiveCharObjectInspector) {
                WritableConstantHiveCharObjectInspector wcsoi = (WritableConstantHiveCharObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableHiveCharObjectInspector) {
                return ((WritableHiveCharObjectInspector)oi).getMaxLength();
            }
        } else if (colTypeLowCase.equals("binary")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                BytesWritable bw = (BytesWritable)coi.getWritableConstantValue();
                return bw.getLength();
            }
            if (oi instanceof WritableConstantBinaryObjectInspector) {
                WritableConstantBinaryObjectInspector wcboi = (WritableConstantBinaryObjectInspector)oi;
                return wcboi.getWritableConstantValue().getLength();
            }
            if (oi instanceof WritableBinaryObjectInspector) {
                return configVarLen;
            }
        } else {
            return StatsUtils.getSizeOfComplexTypes(conf, oi);
        }
        return 0L;
    }

    public static long getSizeOfComplexTypes(HiveConf conf, ObjectInspector oi) {
        long result = 0L;
        int length = 0;
        int listEntries = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_LIST_NUM_ENTRIES);
        int mapEntries = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_MAP_NUM_ENTRIES);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String colTypeLowerCase = oi.getTypeName().toLowerCase();
                if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForStringOfLength(avgColLen);
                    break;
                }
                if (colTypeLowerCase.equals("binary")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForByteArrayOfSize(avgColLen);
                    break;
                }
                result += StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase);
                break;
            }
            case LIST: {
                if (oi instanceof StandardConstantListObjectInspector) {
                    StandardConstantListObjectInspector scloi = (StandardConstantListObjectInspector)oi;
                    length = scloi.getWritableConstantValue().size();
                    ObjectInspector leoi = scloi.getListElementObjectInspector();
                    if (leoi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
                        result += StatsUtils.getSizeOfPrimitiveTypeArraysFromType(leoi.getTypeName(), length);
                        break;
                    }
                    result += (long)JavaDataModel.get().lengthForObjectArrayOfSize(length);
                    break;
                }
                StandardListObjectInspector sloi = (StandardListObjectInspector)oi;
                long elemSize = StatsUtils.getSizeOfComplexTypes(conf, sloi.getListElementObjectInspector());
                result += (long)JavaDataModel.get().arrayList() + (long)listEntries * elemSize;
                break;
            }
            case MAP: {
                if (oi instanceof StandardConstantMapObjectInspector) {
                    StandardConstantMapObjectInspector scmoi = (StandardConstantMapObjectInspector)oi;
                    result += StatsUtils.getSizeOfMap(scmoi);
                    break;
                }
                StandardMapObjectInspector smoi = (StandardMapObjectInspector)oi;
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapKeyObjectInspector());
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapValueObjectInspector());
                result += (long)JavaDataModel.get().hashMap(mapEntries);
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, structField.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(uoi.getObjectInspectors().size() * JavaDataModel.get().primitive1());
                for (ObjectInspector foi : uoi.getObjectInspectors()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, foi);
                }
                break;
            }
        }
        return result;
    }

    public static long getAvgColLenOfFixedLengthTypes(String colType) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().primitive1();
        }
        if (colTypeLowerCase.equals("double") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().primitive2();
        }
        if (colTypeLowerCase.equals("timestamp")) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        return 0L;
    }

    public static long getSizeOfPrimitiveTypeArraysFromType(String colType, int length) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().lengthForIntArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("double")) {
            return JavaDataModel.get().lengthForDoubleArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().lengthForLongArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("binary")) {
            return JavaDataModel.get().lengthForByteArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("boolean")) {
            return JavaDataModel.get().lengthForBooleanArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("timestamp")) {
            return JavaDataModel.get().lengthForTimestampArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthForDateArrayOfSize(length);
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthForDecimalArrayOfSize(length);
        }
        return 0L;
    }

    public static long getSizeOfMap(StandardConstantMapObjectInspector scmoi) {
        Object map = scmoi.getWritableConstantValue();
        ObjectInspector koi = scmoi.getMapKeyObjectInspector();
        ObjectInspector voi = scmoi.getMapValueObjectInspector();
        long result = 0L;
        for (Map.Entry entry : map.entrySet()) {
            result += StatsUtils.getWritableSize(koi, entry.getKey());
            result += StatsUtils.getWritableSize(voi, entry.getValue());
        }
        return result += (long)JavaDataModel.get().hashMap(map.entrySet().size());
    }

    public static long getWritableSize(ObjectInspector oi, Object value) {
        if (oi instanceof WritableStringObjectInspector) {
            WritableStringObjectInspector woi = (WritableStringObjectInspector)oi;
            return JavaDataModel.get().lengthForStringOfLength(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBinaryObjectInspector) {
            WritableBinaryObjectInspector woi = (WritableBinaryObjectInspector)oi;
            return JavaDataModel.get().lengthForByteArrayOfSize(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBooleanObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableByteObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableDateObjectInspector) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (oi instanceof WritableDoubleObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableFloatObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableHiveDecimalObjectInspector) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (oi instanceof WritableIntObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableLongObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableShortObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableTimestampObjectInspector) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        return 0L;
    }

    public static List<ColStatistics> getColStatisticsFromExprMap(HiveConf conf, Statistics parentStats, Map<String, ExprNodeDesc> colExprMap, RowSchema rowSchema) {
        ArrayList<ColStatistics> cs = Lists.newArrayList();
        if (colExprMap != null && rowSchema != null) {
            for (ColumnInfo ci : rowSchema.getSignature()) {
                String outColName = ci.getInternalName();
                String outTabAlias = ci.getTabAlias();
                ExprNodeDesc end = colExprMap.get(outColName);
                ColStatistics colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end);
                if (colStat == null) continue;
                colStat.setColumnName(outColName);
                colStat.setTableAlias(outTabAlias);
                cs.add(colStat);
            }
            return cs;
        }
        if ((colExprMap == null || rowSchema == null) && parentStats.getColumnStats() != null) {
            cs.addAll(parentStats.getColumnStats());
        }
        return cs;
    }

    public static List<ColStatistics> getColStatisticsUpdatingTableAlias(Statistics parentStats, RowSchema rowSchema) {
        ArrayList<ColStatistics> cs = Lists.newArrayList();
        for (ColStatistics parentColStat : parentStats.getColumnStats()) {
            ColStatistics colStat;
            try {
                colStat = parentColStat.clone();
            }
            catch (CloneNotSupportedException e) {
                colStat = null;
            }
            if (colStat == null) continue;
            ColumnInfo ci = rowSchema.getColumnInfo(colStat.getColumnName());
            if (ci != null) {
                colStat.setTableAlias(ci.getTabAlias());
            }
            cs.add(colStat);
        }
        return cs;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColStatistics getColStatisticsFromExpression(HiveConf conf, Statistics parentStats, ExprNodeDesc end) {
        void var11_15;
        String tabAlias;
        long numNulls;
        long countDistincts;
        double avgColSize;
        String colType;
        String colName;
        block19: {
            ExprNodeDesc encd;
            if (end == null) {
                return null;
            }
            colName = null;
            colType = null;
            avgColSize = 0.0;
            countDistincts = 0L;
            numNulls = 0L;
            Object var11_8 = null;
            long numRows = parentStats.getNumRows();
            tabAlias = null;
            if (end instanceof ExprNodeColumnDesc) {
                encd = (ExprNodeColumnDesc)end;
                colName = ((ExprNodeColumnDesc)encd).getColumn();
                tabAlias = ((ExprNodeColumnDesc)encd).getTabAlias();
                if (((ExprNodeColumnDesc)encd).getIsPartitionColOrVirtualCol()) {
                    ColStatistics colStats = parentStats.getColumnStatisticsFromColName(colName);
                    if (colStats != null) {
                        return colStats;
                    }
                    colType = encd.getTypeInfo().getTypeName();
                    countDistincts = numRows;
                    ObjectInspector objectInspector = encd.getWritableObjectInspector();
                    break block19;
                } else {
                    ColStatistics result = parentStats.getColumnStatisticsForColumn(tabAlias, colName);
                    if (result == null) {
                        return null;
                    }
                    try {
                        return result.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        return null;
                    }
                }
            }
            if (end instanceof ExprNodeConstantDesc) {
                encd = (ExprNodeConstantDesc)end;
                if (((ExprNodeConstantDesc)encd).getValue() == null) {
                    colName = encd.getName();
                    colType = "null";
                    numNulls = numRows;
                } else {
                    colName = encd.getName();
                    colType = encd.getTypeString();
                    countDistincts = 1L;
                    ConstantObjectInspector constantObjectInspector = ((ExprNodeConstantDesc)encd).getWritableObjectInspector();
                }
            } else if (end instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc engfd = (ExprNodeGenericFuncDesc)end;
                colName = engfd.getName();
                colType = engfd.getTypeString();
                countDistincts = numRows;
                ObjectInspector objectInspector = engfd.getWritableObjectInspector();
            } else if (end instanceof ExprNodeNullDesc) {
                ExprNodeNullDesc ennd = (ExprNodeNullDesc)end;
                colName = ennd.getName();
                colType = "null";
                numNulls = numRows;
            } else if (end instanceof ExprNodeColumnListDesc) {
                encd = (ExprNodeColumnListDesc)end;
                colName = Joiner.on(",").join(((ExprNodeColumnListDesc)encd).getCols());
                colType = "array";
                countDistincts = numRows;
                ObjectInspector objectInspector = ((ExprNodeColumnListDesc)encd).getWritableObjectInspector();
            } else if (end instanceof ExprNodeFieldDesc) {
                ExprNodeFieldDesc enfd = (ExprNodeFieldDesc)end;
                colName = enfd.getFieldName();
                colType = enfd.getTypeString();
                countDistincts = numRows;
                ObjectInspector objectInspector = enfd.getWritableObjectInspector();
            }
        }
        colType = colType.toLowerCase();
        avgColSize = colType.equals("string") || colType.equals("binary") || colType.startsWith("varchar") || colType.startsWith("char") || colType.startsWith("array") || colType.startsWith("map") || colType.startsWith("struct") || colType.startsWith("uniontype") ? (double)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, (ObjectInspector)var11_15, colType) : (double)StatsUtils.getAvgColLenOfFixedLengthTypes(colType);
        ColStatistics colStats = new ColStatistics(tabAlias, colName, colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        return colStats;
    }

    public static long getNumRows(Table table) {
        return StatsUtils.getBasicStatForTable(table, "numRows");
    }

    public static long getRawDataSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "rawDataSize");
    }

    public static long getTotalSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "totalSize");
    }

    public static long getBasicStatForTable(Table table, String statType) {
        Map<String, String> params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }

    public static List<Long> getBasicStatForPartitions(Table table, List<Partition> parts, String statType) {
        ArrayList<Long> stats = Lists.newArrayList();
        for (Partition part : parts) {
            Map<String, String> params = part.getParameters();
            long result = 0L;
            if (params == null) continue;
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
            stats.add(result);
        }
        return stats;
    }

    public static long getDataSizeFromColumnStats(long numRows, List<ColStatistics> colStats) {
        long result = 0L;
        if (numRows <= 0L) {
            return result;
        }
        for (ColStatistics cs : colStats) {
            int acl;
            if (cs == null) continue;
            String colTypeLowerCase = cs.getColumnType().toLowerCase();
            long nonNullCount = numRows - cs.getNumNulls();
            double sizeOf = 0.0;
            if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
                sizeOf = cs.getAvgColLen();
            } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForStringOfLength(acl);
            } else if (colTypeLowerCase.equals("binary")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForByteArrayOfSize(acl);
            } else {
                sizeOf = colTypeLowerCase.equals("timestamp") ? (double)JavaDataModel.get().lengthOfTimestamp() : (colTypeLowerCase.startsWith("decimal") ? (double)JavaDataModel.get().lengthOfDecimal() : (colTypeLowerCase.equals("date") ? (double)JavaDataModel.get().lengthOfDate() : cs.getAvgColLen()));
            }
            result = StatsUtils.safeAdd(result, StatsUtils.safeMult(nonNullCount, sizeOf));
        }
        return result;
    }

    public static String getFullyQualifiedColumnName(String tabName, String colName) {
        return StatsUtils.getFullyQualifiedName(null, tabName, colName);
    }

    public static String getFullyQualifiedColumnName(String dbName, String tabName, String colName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName, colName);
    }

    public static String getFullyQualifiedColumnName(String dbName, String tabName, String partName, String colName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName, partName, colName);
    }

    public static String getFullyQualifiedTableName(String dbName, String tabName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName);
    }

    private static String getFullyQualifiedName(String ... names) {
        ArrayList<String> nonNullAndEmptyNames = Lists.newArrayList();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            nonNullAndEmptyNames.add(name);
        }
        return Joiner.on(".").join(nonNullAndEmptyNames);
    }

    public static List<String> getFullyQualifedReducerKeyNames(List<String> keyExprs, Map<String, ExprNodeDesc> map) {
        ArrayList<String> result = Lists.newArrayList();
        if (keyExprs != null) {
            for (String key : keyExprs) {
                String tabAlias;
                ExprNodeDesc encd;
                String colName = key;
                ExprNodeDesc end = map.get(colName);
                if (end == null && (end = map.get(colName = Utilities.ReduceField.KEY.toString() + "." + key)) == null) continue;
                if (end instanceof ExprNodeColumnDesc) {
                    encd = (ExprNodeColumnDesc)end;
                    tabAlias = ((ExprNodeColumnDesc)encd).getTabAlias();
                    result.add(StatsUtils.getFullyQualifiedColumnName(tabAlias, colName));
                    continue;
                }
                if (end instanceof ExprNodeGenericFuncDesc) {
                    ExprNodeGenericFuncDesc enf = (ExprNodeGenericFuncDesc)end;
                    tabAlias = "";
                    for (ExprNodeDesc childEnd : enf.getChildren()) {
                        if (!(childEnd instanceof ExprNodeColumnDesc)) continue;
                        tabAlias = ((ExprNodeColumnDesc)childEnd).getTabAlias();
                        break;
                    }
                    result.add(StatsUtils.getFullyQualifiedColumnName(tabAlias, colName));
                    continue;
                }
                if (!(end instanceof ExprNodeConstantDesc)) continue;
                encd = (ExprNodeConstantDesc)end;
                result.add(((ExprNodeConstantDesc)encd).getValue().toString());
            }
        }
        return result;
    }

    public static Set<String> getAllTableAlias(Map<String, ExprNodeDesc> columnExprMap) {
        HashSet<String> result = new HashSet<String>();
        if (columnExprMap != null) {
            for (ExprNodeDesc end : columnExprMap.values()) {
                StatsUtils.getTableAliasFromExprNode(end, result);
            }
        }
        return result;
    }

    private static void getTableAliasFromExprNode(ExprNodeDesc end, Set<String> output) {
        if (end instanceof ExprNodeColumnDesc) {
            output.add(((ExprNodeColumnDesc)end).getTabAlias());
        } else if (end instanceof ExprNodeGenericFuncDesc) {
            for (ExprNodeDesc child : end.getChildren()) {
                StatsUtils.getTableAliasFromExprNode(child, output);
            }
        }
    }

    public static long getAvailableMemory(Configuration conf) {
        int memory = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVETEZCONTAINERSIZE);
        if (memory <= 0 && (memory = conf.getInt("mapreduce.map.memory.mb", 1024)) <= 0) {
            memory = 1024;
        }
        return memory;
    }

    public static long getMaxIfOverflow(long val) {
        return val < 0L ? Long.MAX_VALUE : val;
    }

    public static long safeMult(long a, double b) {
        double result = (double)a * b;
        return result > 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    public static long safeAdd(long a, long b) {
        try {
            return LongMath.checkedAdd(a, b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static long safeMult(long a, long b) {
        try {
            return LongMath.checkedMultiply(a, b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }
}

