/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;

public class DbTxnManager
extends HiveTxnManagerImpl {
    private static final String CLASS_NAME = DbTxnManager.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private DbLockManager lockMgr = null;
    private IMetaStoreClient client = null;
    private long txnId = 0L;

    DbTxnManager() {
    }

    @Override
    void setHiveConf(HiveConf conf) {
        super.setHiveConf(conf);
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            throw new RuntimeException(ErrorMsg.DBTXNMGR_REQUIRES_CONCURRENCY.getMsg());
        }
    }

    @Override
    public long openTxn(String user) throws LockException {
        this.init();
        try {
            this.txnId = this.client.openTxn(user);
            LOG.debug((Object)("Opened txn " + this.txnId));
            return this.txnId;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public HiveLockManager getLockManager() throws LockException {
        this.init();
        if (this.lockMgr == null) {
            this.lockMgr = new DbLockManager(this.client);
        }
        return this.lockMgr;
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username) throws LockException {
        this.acquireLocks(plan, ctx, username, true);
    }

    LockState acquireLocks(QueryPlan plan, Context ctx, String username, boolean isBlocking) throws LockException {
        LockComponent comp;
        Table t;
        LockComponentBuilder compBuilder;
        this.init();
        this.getLockManager();
        boolean atLeastOneLock = false;
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        LOG.debug((Object)("Setting lock request transaction to " + this.txnId + " for queryId=" + plan.getQueryId()));
        rqstBuilder.setTransactionId(this.txnId).setUser(username);
        block16: for (ReadEntity input : plan.getInputs()) {
            if (!input.needsLock() || input.isUpdateOrDelete()) continue;
            compBuilder = new LockComponentBuilder();
            compBuilder.setShared();
            t = null;
            switch (input.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(input.getDatabase().getName());
                    break;
                }
                case TABLE: {
                    t = input.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    compBuilder.setPartitionName(input.getPartition().getName());
                    t = input.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block16;
                }
            }
            comp = compBuilder.build();
            LOG.debug((Object)("Adding lock component to lock request " + comp.toString()));
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        block17: for (WriteEntity output : plan.getOutputs()) {
            if (output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR) continue;
            compBuilder = new LockComponentBuilder();
            t = null;
            LOG.debug((Object)("output is null " + (output == null)));
            switch (output.getWriteType()) {
                case DDL_EXCLUSIVE: 
                case INSERT_OVERWRITE: {
                    compBuilder.setExclusive();
                    break;
                }
                case INSERT: 
                case DDL_SHARED: {
                    compBuilder.setShared();
                    break;
                }
                case UPDATE: 
                case DELETE: {
                    compBuilder.setSemiShared();
                    break;
                }
                case DDL_NO_LOCK: {
                    continue block17;
                }
                default: {
                    throw new RuntimeException("Unknown write type " + output.getWriteType().toString());
                }
            }
            switch (output.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(output.getDatabase().getName());
                    break;
                }
                case TABLE: 
                case DUMMYPARTITION: {
                    t = output.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: {
                    compBuilder.setPartitionName(output.getPartition().getName());
                    t = output.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block17;
                }
            }
            comp = compBuilder.build();
            LOG.debug((Object)("Adding lock component to lock request " + comp.toString()));
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        if (!atLeastOneLock) {
            LOG.debug((Object)("No locks needed for queryId" + plan.getQueryId()));
            return null;
        }
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>(1);
        LockState lockState = this.lockMgr.lock(rqstBuilder.build(), plan.getQueryId(), isBlocking, locks);
        ctx.setHiveLocks(locks);
        return lockState;
    }

    @Override
    public void commitTxn() throws LockException {
        if (this.txnId == 0L) {
            throw new RuntimeException("Attempt to commit before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            LOG.debug((Object)("Committing txn " + this.txnId));
            this.client.commitTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error((Object)("Metastore could not find txn " + this.txnId));
            throw new LockException(ErrorMsg.TXN_NO_SUCH_TRANSACTION.getMsg(), e);
        }
        catch (TxnAbortedException e) {
            LOG.error((Object)("Transaction " + this.txnId + " aborted"));
            throw new LockException(ErrorMsg.TXN_ABORTED.getMsg(), e);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
        }
    }

    @Override
    public void rollbackTxn() throws LockException {
        if (this.txnId == 0L) {
            throw new RuntimeException("Attempt to rollback before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            LOG.debug((Object)("Rolling back txn " + this.txnId));
            this.client.rollbackTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error((Object)("Metastore could not find txn " + this.txnId));
            throw new LockException(ErrorMsg.TXN_NO_SUCH_TRANSACTION.getMsg(), e);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
        }
    }

    @Override
    public void heartbeat() throws LockException {
        LOG.debug((Object)("Heartbeating lock and transaction " + this.txnId));
        List<HiveLock> locks = this.lockMgr.getLocks(false, false);
        if (locks.size() == 0) {
            if (this.txnId == 0L) {
                return;
            }
            DbLockManager.DbHiveLock dummyLock = new DbLockManager.DbHiveLock(0L);
            locks.add(dummyLock);
        }
        for (HiveLock lock : locks) {
            long lockId = ((DbLockManager.DbHiveLock)lock).lockId;
            try {
                this.client.heartbeat(this.txnId, lockId);
            }
            catch (NoSuchLockException e) {
                LOG.error((Object)("Unable to find lock " + lockId));
                throw new LockException(ErrorMsg.LOCK_NO_SUCH_LOCK.getMsg(), e);
            }
            catch (NoSuchTxnException e) {
                LOG.error((Object)("Unable to find transaction " + this.txnId));
                throw new LockException(ErrorMsg.TXN_NO_SUCH_TRANSACTION.getMsg(), e);
            }
            catch (TxnAbortedException e) {
                LOG.error((Object)("Transaction aborted " + this.txnId));
                throw new LockException(ErrorMsg.TXN_ABORTED.getMsg(), e);
            }
            catch (TException e) {
                throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
            }
        }
    }

    @Override
    public ValidTxnList getValidTxns() throws LockException {
        this.init();
        try {
            return this.client.getValidTxns(this.txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public boolean supportsExplicitLock() {
        return false;
    }

    @Override
    public boolean useNewShowLocksFormat() {
        return true;
    }

    @Override
    public boolean supportsAcid() {
        return true;
    }

    @Override
    protected void destruct() {
        try {
            if (this.txnId > 0L) {
                this.rollbackTxn();
            }
            if (this.lockMgr != null) {
                this.lockMgr.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception " + e.getClass().getName() + " with message <" + e.getMessage() + ">, swallowing as there is nothing we can do with it."));
        }
    }

    private void init() throws LockException {
        if (this.client == null) {
            if (this.conf == null) {
                throw new RuntimeException("Must call setHiveConf before any other methods.");
            }
            try {
                Hive db = Hive.get(this.conf);
                this.client = db.getMSC();
            }
            catch (MetaException e) {
                throw new LockException(ErrorMsg.METASTORE_COULD_NOT_INITIATE.getMsg(), e);
            }
            catch (HiveException e) {
                throw new LockException(ErrorMsg.METASTORE_COULD_NOT_INITIATE.getMsg(), e);
            }
        }
    }
}

