/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.DeepParquetHiveMapInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveArrayInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.StandardParquetHiveMapInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.primitive.ParquetPrimitiveInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class ArrayWritableObjectInspector
extends SettableStructObjectInspector {
    private final TypeInfo typeInfo;
    private final List<TypeInfo> fieldInfos;
    private final List<String> fieldNames;
    private final List<StructField> fields;
    private final HashMap<String, StructFieldImpl> fieldsByName;

    public ArrayWritableObjectInspector(StructTypeInfo rowTypeInfo) {
        this.typeInfo = rowTypeInfo;
        this.fieldNames = rowTypeInfo.getAllStructFieldNames();
        this.fieldInfos = rowTypeInfo.getAllStructFieldTypeInfos();
        this.fields = new ArrayList<StructField>(this.fieldNames.size());
        this.fieldsByName = new HashMap();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String name = this.fieldNames.get(i);
            TypeInfo fieldInfo = this.fieldInfos.get(i);
            StructFieldImpl field = new StructFieldImpl(name, this.getObjectInspector(fieldInfo), i);
            this.fields.add(field);
            this.fieldsByName.put(name, field);
        }
    }

    private ObjectInspector getObjectInspector(TypeInfo typeInfo) {
        if (typeInfo.equals(TypeInfoFactory.doubleTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.booleanTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.floatTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.intTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.longTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.stringTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetStringInspector;
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((DecimalTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return new ArrayWritableObjectInspector((StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo subTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
            return new ParquetHiveArrayInspector(this.getObjectInspector(subTypeInfo));
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
            TypeInfo valueTypeInfo = ((MapTypeInfo)typeInfo).getMapValueTypeInfo();
            if (keyTypeInfo.equals(TypeInfoFactory.stringTypeInfo) || keyTypeInfo.equals(TypeInfoFactory.byteTypeInfo) || keyTypeInfo.equals(TypeInfoFactory.shortTypeInfo)) {
                return new DeepParquetHiveMapInspector(this.getObjectInspector(keyTypeInfo), this.getObjectInspector(valueTypeInfo));
            }
            return new StandardParquetHiveMapInspector(this.getObjectInspector(keyTypeInfo), this.getObjectInspector(valueTypeInfo));
        }
        if (typeInfo.equals(TypeInfoFactory.byteTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetByteInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.shortTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetShortInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.timestampTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.binaryTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        if (typeInfo.equals(TypeInfoFactory.dateTypeInfo)) {
            throw new UnsupportedOperationException("Parquet does not support date. See HIVE-6384");
        }
        if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((CharTypeInfo)typeInfo);
        }
        if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((VarcharTypeInfo)typeInfo);
        }
        throw new UnsupportedOperationException("Unknown field type: " + typeInfo);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public String getTypeName() {
        return this.typeInfo.getTypeName();
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            ArrayWritable arr = (ArrayWritable)data;
            return arr.get()[((StructFieldImpl)fieldRef).getIndex()];
        }
        if (data instanceof List) {
            return ((List)data).get(((StructFieldImpl)fieldRef).getIndex());
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    @Override
    public StructField getStructFieldRef(String name) {
        return this.fieldsByName.get(name);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            ArrayWritable arr = (ArrayWritable)data;
            Writable[] arrWritable = arr.get();
            return new ArrayList<Writable>(Arrays.asList(arrWritable));
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    @Override
    public Object create() {
        ArrayList<Object> list = new ArrayList<Object>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        ArrayList list = (ArrayList)struct;
        list.set(((StructFieldImpl)field).getIndex(), fieldValue);
        return list;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayWritableObjectInspector other = (ArrayWritableObjectInspector)obj;
        return this.typeInfo == other.typeInfo || this.typeInfo != null && this.typeInfo.equals(other.typeInfo);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.typeInfo != null ? this.typeInfo.hashCode() : 0);
        return hash;
    }

    class StructFieldImpl
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int index;

        public StructFieldImpl(String name, ObjectInspector inspector, int index) {
            this.name = name;
            this.inspector = inspector;
            this.index = index;
        }

        @Override
        public String getFieldComment() {
            return "";
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        @Override
        public int getFieldID() {
            return this.index;
        }
    }
}

