/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import parquet.column.Dictionary;
import parquet.io.api.Binary;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;

public enum ETypeConverter {
    EDOUBLE_CONVERTER((Class)Double.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent) {
            return new PrimitiveConverter(){

                @Override
                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBOOLEAN_CONVERTER((Class)Boolean.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent) {
            return new PrimitiveConverter(){

                @Override
                public void addBoolean(boolean value) {
                    parent.set(index, (Writable)new BooleanWritable(value));
                }
            };
        }
    }
    ,
    EFLOAT_CONVERTER((Class)Float.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent) {
            return new PrimitiveConverter(){

                @Override
                public void addFloat(float value) {
                    parent.set(index, (Writable)new FloatWritable(value));
                }
            };
        }
    }
    ,
    EINT32_CONVERTER((Class)Integer.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent) {
            return new PrimitiveConverter(){

                @Override
                public void addInt(int value) {
                    parent.set(index, (Writable)new IntWritable(value));
                }
            };
        }
    }
    ,
    EINT64_CONVERTER((Class)Long.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent) {
            return new PrimitiveConverter(){

                @Override
                public void addLong(long value) {
                    parent.set(index, (Writable)new LongWritable(value));
                }
            };
        }
    }
    ,
    EBINARY_CONVERTER((Class)Binary.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent) {
            return new BinaryConverter<BytesWritable>(type, parent, index){

                @Override
                protected BytesWritable convert(Binary binary) {
                    return new BytesWritable(binary.getBytes());
                }
            };
        }
    }
    ,
    ESTRING_CONVERTER((Class)String.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent) {
            return new BinaryConverter<Text>(type, parent, index){

                @Override
                protected Text convert(Binary binary) {
                    return new Text(binary.getBytes());
                }
            };
        }
    }
    ,
    EDECIMAL_CONVERTER((Class)BigDecimal.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent) {
            return new BinaryConverter<HiveDecimalWritable>(type, parent, index){

                @Override
                protected HiveDecimalWritable convert(Binary binary) {
                    return new HiveDecimalWritable(binary.getBytes(), this.type.getDecimalMetadata().getScale());
                }
            };
        }
    }
    ,
    ETIMESTAMP_CONVERTER((Class)TimestampWritable.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, final ConverterParent parent) {
            return new BinaryConverter<TimestampWritable>(type, parent, index){

                @Override
                protected TimestampWritable convert(Binary binary) {
                    NanoTime nt = NanoTime.fromBinary(binary);
                    Map<String, String> metadata = parent.getMetadata();
                    boolean skipConversion = Boolean.valueOf(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname));
                    Timestamp ts = NanoTimeUtils.getTimestamp(nt, skipConversion);
                    return new TimestampWritable(ts);
                }
            };
        }
    };

    final Class<?> _type;

    private ETypeConverter(Class<?> type) {
        this._type = type;
    }

    private Class<?> getType() {
        return this._type;
    }

    abstract PrimitiveConverter getConverter(PrimitiveType var1, int var2, ConverterParent var3);

    public static PrimitiveConverter getNewConverter(PrimitiveType type, int index, ConverterParent parent) {
        if (type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
            return ETIMESTAMP_CONVERTER.getConverter(type, index, parent);
        }
        if (OriginalType.DECIMAL == type.getOriginalType()) {
            return EDECIMAL_CONVERTER.getConverter(type, index, parent);
        }
        if (OriginalType.UTF8 == type.getOriginalType()) {
            return ESTRING_CONVERTER.getConverter(type, index, parent);
        }
        Class<?> javaType = type.getPrimitiveTypeName().javaType;
        for (ETypeConverter eConverter : ETypeConverter.values()) {
            if (eConverter.getType() != javaType) continue;
            return eConverter.getConverter(type, index, parent);
        }
        throw new IllegalArgumentException("Converter not found ... for type : " + type);
    }

    public static abstract class BinaryConverter<T extends Writable>
    extends PrimitiveConverter {
        protected final PrimitiveType type;
        private final ConverterParent parent;
        private final int index;
        private ArrayList<T> lookupTable;

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index) {
            this.type = type;
            this.parent = parent;
            this.index = index;
        }

        protected abstract T convert(Binary var1);

        @Override
        public boolean hasDictionarySupport() {
            return true;
        }

        @Override
        public void setDictionary(Dictionary dictionary) {
            int length = dictionary.getMaxId() + 1;
            this.lookupTable = new ArrayList();
            for (int i = 0; i < length; ++i) {
                this.lookupTable.add(this.convert(dictionary.decodeToBinary(i)));
            }
        }

        @Override
        public void addValueFromDictionary(int dictionaryId) {
            this.parent.set(this.index, (Writable)this.lookupTable.get(dictionaryId));
        }

        @Override
        public void addBinary(Binary value) {
            this.parent.set(this.index, (Writable)this.convert(value));
        }
    }
}

