/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HiveIOExceptionHandlerUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveRecordReader;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveInputFormat<K extends WritableComparable, V extends Writable>
implements InputFormat<K, V>,
JobConfigurable {
    private static final String CLASS_NAME = HiveInputFormat.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private static Map<Class, InputFormat<WritableComparable, Writable>> inputFormats = new ConcurrentHashMap<Class, InputFormat<WritableComparable, Writable>>();
    private JobConf job;
    protected Map<String, PartitionDesc> pathToPartitionInfo;
    protected MapWork mrwork;

    public void configure(JobConf job) {
        this.job = job;
    }

    public static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, JobConf job) throws IOException {
        InputFormat instance = inputFormats.get(inputFormatClass);
        if (instance == null) {
            try {
                instance = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)job);
                String inputFormatName = inputFormatClass.getName().toLowerCase();
                if (!inputFormatName.contains("hbase")) {
                    inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)instance);
                }
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!", e);
            }
        }
        return instance;
    }

    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        HiveInputSplit hsplit = (HiveInputSplit)split;
        InputSplit inputSplit = hsplit.getInputSplit();
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName, e);
        }
        if (this.mrwork == null) {
            this.init(job);
        }
        boolean nonNative = false;
        PartitionDesc part = this.pathToPartitionInfo.get(hsplit.getPath().toString());
        if (part != null && part.getTableDesc() != null) {
            Utilities.copyTableJobPropertiesToConf(part.getTableDesc(), job);
            nonNative = part.getTableDesc().isNonNative();
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath().toString(), hsplit.getPath().toUri().getPath(), nonNative);
        InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
        RecordReader innerReader = null;
        try {
            innerReader = inputFormat.getRecordReader(inputSplit, job, reporter);
        }
        catch (Exception e) {
            innerReader = HiveIOExceptionHandlerUtil.handleRecordReaderCreationException(e, job);
        }
        HiveRecordReader rr = new HiveRecordReader(innerReader, job);
        rr.initIOContext(hsplit, job, inputFormatClass, innerReader);
        return rr;
    }

    protected void init(JobConf job) {
        if (this.mrwork == null || this.pathToPartitionInfo == null) {
            if (HiveConf.getVar((Configuration)job, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                this.mrwork = (MapWork)Utilities.getMergeWork(job);
                if (this.mrwork == null) {
                    this.mrwork = Utilities.getMapWork((Configuration)job);
                }
            } else {
                this.mrwork = Utilities.getMapWork((Configuration)job);
            }
            this.pathToPartitionInfo = this.mrwork.getPathToPartitionInfo();
        }
    }

    private void addSplitsForGroup(List<Path> dirs, TableScanOperator tableScan, JobConf conf, InputFormat inputFormat, Class<? extends InputFormat> inputFormatClass, int splits, TableDesc table, List<InputSplit> result) throws IOException {
        InputSplit[] iss;
        Utilities.copyTablePropertiesToConf(table, conf);
        if (tableScan != null) {
            HiveInputFormat.pushFilters(conf, tableScan);
        }
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])dirs.toArray(new Path[dirs.size()]));
        conf.setInputFormat(inputFormat.getClass());
        int headerCount = 0;
        int footerCount = 0;
        if (table != null) {
            headerCount = Utilities.getHeaderCount(table);
            footerCount = Utilities.getFooterCount(table, conf);
            if (headerCount != 0 || footerCount != 0) {
                conf.setLong(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZE"), Long.MAX_VALUE);
            }
        }
        for (InputSplit is : iss = inputFormat.getSplits(conf, splits)) {
            result.add(new HiveInputSplit(is, inputFormatClass.getName()));
        }
    }

    Path[] getInputPaths(JobConf job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            if (HiveConf.getVar((Configuration)job, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                try {
                    List<Path> paths = Utilities.getInputPathsTez(job, this.mrwork);
                    dirs = paths.toArray(new Path[paths.size()]);
                }
                catch (Exception e) {
                    throw new IOException("Could not create input files", e);
                }
            } else {
                throw new IOException("No input paths specified in job");
            }
        }
        return dirs;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getSplits");
        this.init(job);
        Path[] dirs = this.getInputPaths(job);
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        ArrayList<Path> currentDirs = new ArrayList<Path>();
        Class<? extends InputFormat> currentInputFormatClass = null;
        TableDesc currentTable = null;
        TableScanOperator currentTableScan = null;
        boolean pushDownProjection = false;
        StringBuilder readColumnsBuffer = new StringBuilder(newjob.get("hive.io.file.readcolumn.ids", ""));
        StringBuilder readColumnNamesBuffer = new StringBuilder(newjob.get("hive.io.file.readcolumn.names", ""));
        for (Path dir : dirs) {
            Operator<? extends OperatorDesc> op;
            PartitionDesc part = HiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            TableDesc table = part.getTableDesc();
            TableScanOperator tableScan = null;
            List aliases = this.mrwork.getPathToAliases().get(dir.toUri().toString());
            if (aliases != null && aliases.size() == 1 && (op = this.mrwork.getAliasToWork().get(aliases.get(0))) != null && op instanceof TableScanOperator) {
                tableScan = (TableScanOperator)op;
                readColumnsBuffer.setLength(0);
                readColumnNamesBuffer.setLength(0);
                ColumnProjectionUtils.appendReadColumns(readColumnsBuffer, readColumnNamesBuffer, tableScan.getNeededColumnIDs(), tableScan.getNeededColumns());
                pushDownProjection = true;
                HiveInputFormat.pushFilters(newjob, tableScan);
            }
            if (!currentDirs.isEmpty() && inputFormatClass.equals(currentInputFormatClass) && table.equals(currentTable) && tableScan == currentTableScan) {
                currentDirs.add(dir);
                continue;
            }
            if (!currentDirs.isEmpty()) {
                LOG.info((Object)"Generating splits");
                this.addSplitsForGroup(currentDirs, currentTableScan, newjob, HiveInputFormat.getInputFormatFromCache(currentInputFormatClass, job), currentInputFormatClass, currentDirs.size() * (numSplits / dirs.length), currentTable, result);
            }
            currentDirs.clear();
            currentDirs.add(dir);
            currentTableScan = tableScan;
            currentTable = table;
            currentInputFormatClass = inputFormatClass;
        }
        if (pushDownProjection) {
            newjob.setBoolean("hive.io.file.read.all.columns", false);
            newjob.set("hive.io.file.readcolumn.ids", readColumnsBuffer.toString());
            newjob.set("hive.io.file.readcolumn.names", readColumnNamesBuffer.toString());
            LOG.info((Object)("hive.io.file.readcolumn.ids=" + readColumnsBuffer.toString()));
            LOG.info((Object)("hive.io.file.readcolumn.names=" + readColumnNamesBuffer.toString()));
        }
        if (dirs.length != 0) {
            LOG.info((Object)"Generating splits");
            this.addSplitsForGroup(currentDirs, currentTableScan, newjob, HiveInputFormat.getInputFormatFromCache(currentInputFormatClass, job), currentInputFormatClass, currentDirs.size() * (numSplits / dirs.length), currentTable, result);
        }
        Utilities.clearWorkMapForConf((Configuration)job);
        LOG.info((Object)("number of splits " + result.size()));
        perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
        return result.toArray(new HiveInputSplit[result.size()]);
    }

    protected static PartitionDesc getPartitionDescFromPath(Map<String, PartitionDesc> pathToPartitionInfo, Path dir) throws IOException {
        PartitionDesc partDesc = pathToPartitionInfo.get(dir.toString());
        if (partDesc == null) {
            partDesc = pathToPartitionInfo.get(dir.toUri().getPath());
        }
        if (partDesc == null) {
            throw new IOException("cannot find dir = " + dir.toString() + " in " + pathToPartitionInfo);
        }
        return partDesc;
    }

    public static void pushFilters(JobConf jobConf, TableScanOperator tableScan) {
        jobConf.unset("hive.io.filter.text");
        jobConf.unset("hive.io.filter.expr.serialized");
        TableScanDesc scanDesc = (TableScanDesc)tableScan.getConf();
        if (scanDesc == null) {
            return;
        }
        Utilities.setColumnNameList(jobConf, tableScan);
        Utilities.setColumnTypeList(jobConf, tableScan);
        ExprNodeGenericFuncDesc filterExpr = scanDesc.getFilterExpr();
        if (filterExpr == null) {
            return;
        }
        Serializable filterObject = scanDesc.getFilterObject();
        if (filterObject != null) {
            jobConf.set("hive.io.filter.object", Utilities.serializeObject(filterObject));
        }
        String filterText = filterExpr.getExprString();
        String filterExprSerialized = Utilities.serializeExpression(filterExpr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filter text = " + filterText));
            LOG.debug((Object)("Filter expression = " + filterExprSerialized));
        }
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", filterExprSerialized);
    }

    protected void pushProjectionsAndFilters(JobConf jobConf, Class inputFormatClass, String splitPath, String splitPathWithNoSchema) {
        this.pushProjectionsAndFilters(jobConf, inputFormatClass, splitPath, splitPathWithNoSchema, false);
    }

    protected void pushProjectionsAndFilters(JobConf jobConf, Class inputFormatClass, String splitPath, String splitPathWithNoSchema, boolean nonNative) {
        if (this.mrwork == null) {
            this.init(this.job);
        }
        if (this.mrwork.getPathToAliases() == null) {
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : this.mrwork.getPathToAliases().entrySet()) {
            boolean match;
            String key = entry.getKey();
            if (nonNative) {
                match = splitPath.equals(key) || splitPathWithNoSchema.equals(key);
            } else {
                boolean bl = match = splitPath.startsWith(key) || splitPathWithNoSchema.startsWith(key);
            }
            if (!match) continue;
            ArrayList<String> list = entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator<? extends OperatorDesc> op = this.mrwork.getAliasToWork().get(alias);
            if (!(op instanceof TableScanOperator)) continue;
            TableScanOperator ts = (TableScanOperator)op;
            ColumnProjectionUtils.appendReadColumns((Configuration)jobConf, ts.getNeededColumnIDs(), ts.getNeededColumns());
            HiveInputFormat.pushFilters(jobConf, ts);
        }
    }

    public static class HiveInputSplit
    extends FileSplit
    implements InputSplit,
    Configurable {
        InputSplit inputSplit;
        String inputFormatClassName;
        Configuration conf;

        public HiveInputSplit() {
            super((Path)null, 0L, 0L, (String[])null);
        }

        public HiveInputSplit(InputSplit inputSplit, String inputFormatClassName) {
            super((Path)null, 0L, 0L, (String[])null);
            this.inputSplit = inputSplit;
            this.inputFormatClassName = inputFormatClassName;
        }

        public InputSplit getInputSplit() {
            return this.inputSplit;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public Path getPath() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getPath();
            }
            return new Path("");
        }

        public long getStart() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getStart();
            }
            return 0L;
        }

        public String toString() {
            return this.inputFormatClassName + ":" + this.inputSplit.toString();
        }

        public long getLength() {
            long r = 0L;
            try {
                r = this.inputSplit.getLength();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return r;
        }

        public String[] getLocations() throws IOException {
            return this.inputSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            String inputSplitClassName = in.readUTF();
            try {
                this.inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)this.conf.getClassByName(inputSplitClassName), (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputSplit class = " + inputSplitClassName + ":" + e.getMessage(), e);
            }
            this.inputSplit.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.inputSplit.getClass().getName());
            this.inputSplit.write(out);
            out.writeUTF(this.inputFormatClassName);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }
    }
}

