/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelDirectoryRenamer {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelDirectoryRenamer.class);

    public static void renameDirectoryInParallel(final Configuration conf, FileSystem srcFs, final FileSystem destFs, Path srcPath, Path destPath, final boolean inheritPerms, final SessionState parentSession, ExecutorService pool) throws IOException, HiveException {
        Preconditions.checkArgument(srcFs.getClass().equals(destFs.getClass()), "Source and destination filesystems must of the same type");
        Preconditions.checkArgument(BlobStorageUtils.isBlobStorageFileSystem(conf, srcFs), "Source and destinations filesystems must both be blobstores");
        Preconditions.checkArgument(srcFs.exists(srcPath), "Source Path " + srcPath + " does not exist");
        if (srcFs.isDirectory(srcPath)) {
            Path basePath;
            if (!destFs.exists(destPath)) {
                destFs.mkdirs(destPath);
                basePath = destPath;
            } else {
                basePath = new Path(destPath, srcPath.getName());
                Preconditions.checkArgument(!destFs.exists(basePath), "Path " + basePath + " already exists");
            }
            final HadoopShims shims = ShimLoader.getHadoopShims();
            final HadoopShims.HdfsFileStatus desiredStatus = shims.getFullFileStatus(destFs.getConf(), destFs, destPath);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (final FileStatus srcStatus : srcFs.listStatus(srcPath)) {
                final Path destFile = new Path(basePath, srcStatus.getPath().getName());
                final String group = srcStatus.getGroup();
                futures.add(pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SessionState.setCurrentSessionState(parentSession);
                        if (destFs.rename(srcStatus.getPath(), destFile)) {
                            if (inheritPerms) {
                                shims.setFullFileStatus(conf, desiredStatus, group, destFs, destFile, false);
                            }
                        } else {
                            throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest path: " + destFile + " returned false");
                        }
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOG.debug(e.getMessage());
                    pool.shutdownNow();
                    throw new HiveException(e);
                }
            }
        } else if (!destFs.rename(srcPath, destPath)) {
            throw new IOException("rename for src path: " + srcPath + " to dest path: " + destPath + " returned false");
        }
    }
}

