/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HBaseBulkGetExample$ {
    public static final HBaseBulkGetExample$ MODULE$;

    static {
        new HBaseBulkGetExample$();
    }

    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"HBaseBulkGetExample {tableName}");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder().append((Object)"HBaseBulkGetExample ").append((Object)tableName).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            RDD rdd = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5"), Bytes.toBytes((String)"6"), Bytes.toBytes((String)"7")}), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = hbaseContext.bulkGet(TableName.valueOf((String)tableName), Predef$.MODULE$.int2Integer(2), rdd, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Get apply(byte[] record) {
                    System.out.println("making Get");
                    return new Get(record);
                }
            }, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Result result) {
                    Iterator<E> it = result.listCells().iterator();
                    StringBuilder b = new StringBuilder();
                    b.append(new StringBuilder().append((Object)Bytes.toString((byte[])result.getRow())).append((Object)":").toString());
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                        StringBuilder stringBuilder = q.equals("counter") ? b.append(new StringBuilder().append((Object)"(").append((Object)q).append((Object)",").append((Object)BoxesRunTime.boxToLong((long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell)))).append((Object)")").toString()) : b.append(new StringBuilder().append((Object)"(").append((Object)q).append((Object)",").append((Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append((Object)")").toString());
                    }
                    return b.toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            Predef$.MODULE$.refArrayOps((Object[])getRdd.collect()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String v) {
                    Predef$.MODULE$.println((Object)v);
                }
            });
            return;
        }
        finally {
            sc.stop();
        }
    }

    private HBaseBulkGetExample$() {
        MODULE$ = this;
    }
}

