/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import org.apache.hadoop.hbase.util.Bytes;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\tI1kY1o%\u0006tw-\u001a\u0006\u0003\u0007\u0011\tQa\u001d9be.T!!\u0002\u0004\u0002\u000b!\u0014\u0017m]3\u000b\u0005\u001dA\u0011A\u00025bI>|\u0007O\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0019!C\u00013\u0005QQ\u000f\u001d9fe\n{WO\u001c3\u0016\u0003i\u00012aD\u000e\u001e\u0013\ta\u0002CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010=%\u0011q\u0004\u0005\u0002\u0005\u0005f$X\r\u0003\u0005\"\u0001\t\u0005\r\u0011\"\u0001#\u00039)\b\u000f]3s\u0005>,h\u000eZ0%KF$\"a\t\u0014\u0011\u0005=!\u0013BA\u0013\u0011\u0005\u0011)f.\u001b;\t\u000f\u001d\u0002\u0013\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\u0011%\u0002!\u0011!Q!\ni\t1\"\u001e9qKJ\u0014u.\u001e8eA!A1\u0006\u0001BA\u0002\u0013\u0005A&A\njgV\u0003\b/\u001a:C_VtG-R9vC2$v.F\u0001.!\tya&\u0003\u00020!\t9!i\\8mK\u0006t\u0007\u0002C\u0019\u0001\u0005\u0003\u0007I\u0011\u0001\u001a\u0002/%\u001cX\u000b\u001d9fe\n{WO\u001c3FcV\fG\u000eV8`I\u0015\fHCA\u00124\u0011\u001d9\u0003'!AA\u00025B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006K!L\u0001\u0015SN,\u0006\u000f]3s\u0005>,h\u000eZ#rk\u0006dGk\u001c\u0011\t\u0011]\u0002!\u00111A\u0005\u0002e\t!\u0002\\8xKJ\u0014u.\u001e8e\u0011!I\u0004A!a\u0001\n\u0003Q\u0014A\u00047po\u0016\u0014(i\\;oI~#S-\u001d\u000b\u0003GmBqa\n\u001d\u0002\u0002\u0003\u0007!\u0004\u0003\u0005>\u0001\t\u0005\t\u0015)\u0003\u001b\u0003-awn^3s\u0005>,h\u000e\u001a\u0011\t\u0011}\u0002!\u00111A\u0005\u00021\n1#[:M_^,'OQ8v]\u0012,\u0015/^1m)>D\u0001\"\u0011\u0001\u0003\u0002\u0004%\tAQ\u0001\u0018SNdun^3s\u0005>,h\u000eZ#rk\u0006dGk\\0%KF$\"aI\"\t\u000f\u001d\u0002\u0015\u0011!a\u0001[!AQ\t\u0001B\u0001B\u0003&Q&\u0001\u000bjg2{w/\u001a:C_VtG-R9vC2$v\u000e\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%[E*\u0014(\u0011\u0005)\u0003Q\"\u0001\u0002\t\u000ba1\u0005\u0019\u0001\u000e\t\u000b-2\u0005\u0019A\u0017\t\u000b]2\u0005\u0019\u0001\u000e\t\u000b}2\u0005\u0019A\u0017\t\u000bA\u0003A\u0011A)\u0002\u001d5,'oZ3J]R,'o]3diR\u00111E\u0015\u0005\u0006'>\u0003\r!S\u0001\u0006_RDWM\u001d\u0005\u0006+\u0002!\tAV\u0001\u000b[\u0016\u0014x-Z+oS>tGCA\u0012X\u0011\u0015\u0019F\u000b1\u0001J\u0011\u0015I\u0006\u0001\"\u0001[\u0003M9W\r^(wKJd\u0015\r]*dC:\u0014\u0016M\\4f)\tI5\fC\u0003T1\u0002\u0007\u0011\nC\u0003^\u0001\u0011\u0005a,\u0001\u0007d_6\u0004\u0018M]3SC:<W\rF\u0002`E\u0012\u0004\"a\u00041\n\u0005\u0005\u0004\"aA%oi\")1\r\u0018a\u00015\u0005!A.\u001a4u\u0011\u0015)G\f1\u0001\u001b\u0003\u0015\u0011\u0018n\u001a5u\u0011\u00159\u0007\u0001\"\u0001i\u00035\u0019wN\u001c;bS:\u001c\bk\\5oiR\u0011Q&\u001b\u0005\u0006U\u001a\u0004\rAG\u0001\u0006a>Lg\u000e\u001e\u0005\u0006Y\u0002!\t%\\\u0001\ti>\u001cFO]5oOR\ta\u000e\u0005\u0002pe:\u0011q\u0002]\u0005\u0003cB\ta\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000f\u0005")
public class ScanRange
implements Serializable {
    private byte[] upperBound;
    private boolean isUpperBoundEqualTo;
    private byte[] lowerBound;
    private boolean isLowerBoundEqualTo;

    public byte[] upperBound() {
        return this.upperBound;
    }

    public void upperBound_$eq(byte[] x$1) {
        this.upperBound = x$1;
    }

    public boolean isUpperBoundEqualTo() {
        return this.isUpperBoundEqualTo;
    }

    public void isUpperBoundEqualTo_$eq(boolean x$1) {
        this.isUpperBoundEqualTo = x$1;
    }

    public byte[] lowerBound() {
        return this.lowerBound;
    }

    public void lowerBound_$eq(byte[] x$1) {
        this.lowerBound = x$1;
    }

    public boolean isLowerBoundEqualTo() {
        return this.isLowerBoundEqualTo;
    }

    public void isLowerBoundEqualTo_$eq(boolean x$1) {
        this.isLowerBoundEqualTo = x$1;
    }

    public void mergeIntersect(ScanRange other) {
        int upperBoundCompare = this.compareRange(this.upperBound(), other.upperBound());
        int lowerBoundCompare = this.compareRange(this.lowerBound(), other.lowerBound());
        this.upperBound_$eq(upperBoundCompare < 0 ? this.upperBound() : other.upperBound());
        this.lowerBound_$eq(lowerBoundCompare > 0 ? this.lowerBound() : other.lowerBound());
        this.isLowerBoundEqualTo_$eq(lowerBoundCompare == 0 ? this.isLowerBoundEqualTo() && other.isLowerBoundEqualTo() : this.isLowerBoundEqualTo());
        this.isUpperBoundEqualTo_$eq(upperBoundCompare == 0 ? this.isUpperBoundEqualTo() && other.isUpperBoundEqualTo() : this.isUpperBoundEqualTo());
    }

    public void mergeUnion(ScanRange other) {
        int upperBoundCompare = this.compareRange(this.upperBound(), other.upperBound());
        int lowerBoundCompare = this.compareRange(this.lowerBound(), other.lowerBound());
        this.upperBound_$eq(upperBoundCompare > 0 ? this.upperBound() : other.upperBound());
        this.lowerBound_$eq(lowerBoundCompare < 0 ? this.lowerBound() : other.lowerBound());
        this.isLowerBoundEqualTo_$eq(lowerBoundCompare == 0 ? this.isLowerBoundEqualTo() || other.isLowerBoundEqualTo() : (lowerBoundCompare < 0 ? this.isLowerBoundEqualTo() : other.isLowerBoundEqualTo()));
        this.isUpperBoundEqualTo_$eq(upperBoundCompare == 0 ? this.isUpperBoundEqualTo() || other.isUpperBoundEqualTo() : (upperBoundCompare < 0 ? other.isUpperBoundEqualTo() : this.isUpperBoundEqualTo()));
    }

    public ScanRange getOverLapScanRange(ScanRange other) {
        ScanRange leftRange = null;
        ScanRange rightRange = null;
        if (this.compareRange(this.lowerBound(), other.lowerBound()) < 0 || this.compareRange(this.upperBound(), other.upperBound()) < 0) {
            leftRange = this;
            rightRange = other;
        } else {
            leftRange = other;
            rightRange = this;
        }
        return leftRange.upperBound() == null || Bytes.compareTo((byte[])leftRange.upperBound(), (byte[])rightRange.lowerBound()) >= 0 ? new ScanRange(leftRange.upperBound(), leftRange.isUpperBoundEqualTo(), rightRange.lowerBound(), rightRange.isLowerBoundEqualTo()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareRange(byte[] left, byte[] right) {
        if (left == null) {
            if (right == null) {
                return 0;
            }
        }
        if (left == null) {
            if (right != null) {
                return 1;
            }
        }
        if (left != null) {
            if (right == null) {
                return -1;
            }
        }
        int n = Bytes.compareTo((byte[])left, (byte[])right);
        return n;
    }

    public boolean containsPoint(byte[] point) {
        int lowerCompare = this.compareRange(point, this.lowerBound());
        int upperCompare = this.compareRange(point, this.upperBound());
        return (this.isLowerBoundEqualTo() && lowerCompare >= 0 || !this.isLowerBoundEqualTo() && lowerCompare > 0) && (this.isUpperBoundEqualTo() && upperCompare <= 0 || !this.isUpperBoundEqualTo() && upperCompare < 0);
    }

    public String toString() {
        return new StringBuilder().append((Object)"ScanRange:(upperBound:").append((Object)Bytes.toString((byte[])this.upperBound())).append((Object)",isUpperBoundEqualTo:").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isUpperBoundEqualTo())).append((Object)",lowerBound:").append((Object)Bytes.toString((byte[])this.lowerBound())).append((Object)",isLowerBoundEqualTo:").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLowerBoundEqualTo())).append((Object)")").toString();
    }

    public ScanRange(byte[] upperBound, boolean isUpperBoundEqualTo, byte[] lowerBound, boolean isLowerBoundEqualTo) {
        this.upperBound = upperBound;
        this.isUpperBoundEqualTo = isUpperBoundEqualTo;
        this.lowerBound = lowerBound;
        this.isLowerBoundEqualTo = isLowerBoundEqualTo;
    }
}

