/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.HashMap;
import org.apache.hadoop.hbase.spark.HBaseRelation;
import org.apache.hadoop.hbase.spark.SchemaQualifierDefinition;
import org.apache.spark.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.RelationProvider;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001b\tiA)\u001a4bk2$8k\\;sG\u0016T!a\u0001\u0003\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00151\u0011!\u00025cCN,'BA\u0004\t\u0003\u0019A\u0017\rZ8pa*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u0015;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000fM|WO]2fg*\u0011\u0011DG\u0001\u0004gFd'BA\u0002\t\u0013\tabC\u0001\tSK2\fG/[8o!J|g/\u001b3feB\u0011adH\u0007\u00025%\u0011\u0001E\u0007\u0002\b\u0019><w-\u001b8h\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!\u0001C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\u0002\u0013Q\u000b%\tT#`\u0017\u0016KV#A\u0015\u0011\u0005)jcBA\b,\u0013\ta\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u0011\u0011\u0019\t\u0004\u0001)A\u0005S\u0005QA+\u0011\"M\u000b~[U)\u0017\u0011\t\u000fM\u0002!\u0019!C\u0001Q\u0005Q2k\u0011%F\u001b\u0006{6i\u0014'V\u001b:\u001bv,T!Q!&suiX&F3\"1Q\u0007\u0001Q\u0001\n%\n1dU\"I\u000b6\u000bulQ(M+6s5kX'B!BKejR0L\u000bf\u0003\u0003bB\u001c\u0001\u0005\u0004%\t\u0001K\u0001!\u0011\n\u000b5+R0D\u001f:3\u0015jR0S\u000bN{UKU\"F'~cujQ!U\u0013>s5\u000b\u0003\u0004:\u0001\u0001\u0006I!K\u0001\"\u0011\n\u000b5+R0D\u001f:3\u0015jR0S\u000bN{UKU\"F'~cujQ!U\u0013>s5\u000b\t\u0005\bw\u0001\u0011\r\u0011\"\u0001)\u0003E)6+R0I\u0005\u0006\u001bViX\"P\u001dR+\u0005\f\u0016\u0005\u0007{\u0001\u0001\u000b\u0011B\u0015\u0002%U\u001bVi\u0018%C\u0003N+ulQ(O)\u0016CF\u000b\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001)\u0003]\u0001Vk\u0015%`\t>;fjX\"P\u0019Vkej\u0018$J\u0019R+%\u000b\u0003\u0004B\u0001\u0001\u0006I!K\u0001\u0019!V\u001b\u0006j\u0018#P/:{6i\u0014'V\u001b:{f)\u0013'U\u000bJ\u0003\u0003\"B\"\u0001\t\u0003\"\u0015AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0004\u000b\"s\u0005CA\u000bG\u0013\t9eC\u0001\u0007CCN,'+\u001a7bi&|g\u000eC\u0003J\u0005\u0002\u0007!*\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"a\u0013'\u000e\u0003aI!!\u0014\r\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003P\u0005\u0002\u0007\u0001+\u0001\u0006qCJ\fW.\u001a;feN\u0004BAK)*S%\u0011!k\f\u0002\u0004\u001b\u0006\u0004\b\"\u0002+\u0001\t\u0003)\u0016\u0001G4f]\u0016\u0014\u0018\r^3TG\",W.Y'baBLgnZ'baR\u0011a+\u0019\t\u0005/rKc,D\u0001Y\u0015\tI&,\u0001\u0003vi&d'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002&?&\u0011\u0001M\u0001\u0002\u001a'\u000eDW-\\1Rk\u0006d\u0017NZ5fe\u0012+g-\u001b8ji&|g\u000eC\u0003c'\u0002\u0007\u0011&A\ntG\",W.Y'baBLgnZ*ue&tw\r")
public class DefaultSource
implements RelationProvider,
Logging {
    private final String TABLE_KEY;
    private final String SCHEMA_COLUMNS_MAPPING_KEY;
    private final String HBASE_CONFIG_RESOURCES_LOCATIONS;
    private final String USE_HBASE_CONTEXT;
    private final String PUSH_DOWN_COLUMN_FILTER;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String TABLE_KEY() {
        return this.TABLE_KEY;
    }

    public String SCHEMA_COLUMNS_MAPPING_KEY() {
        return this.SCHEMA_COLUMNS_MAPPING_KEY;
    }

    public String HBASE_CONFIG_RESOURCES_LOCATIONS() {
        return this.HBASE_CONFIG_RESOURCES_LOCATIONS;
    }

    public String USE_HBASE_CONTEXT() {
        return this.USE_HBASE_CONTEXT;
    }

    public String PUSH_DOWN_COLUMN_FILTER() {
        return this.PUSH_DOWN_COLUMN_FILTER;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        Option tableName = parameters.get((Object)this.TABLE_KEY());
        Object object = tableName.isEmpty() ? new IllegalArgumentException(new StringBuilder().append((Object)"Invalid value for ").append((Object)this.TABLE_KEY()).append((Object)" '").append((Object)tableName).append((Object)"'").toString()) : BoxedUnit.UNIT;
        String schemaMappingString = (String)parameters.getOrElse((Object)this.SCHEMA_COLUMNS_MAPPING_KEY(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String hbaseConfigResources = (String)parameters.getOrElse((Object)this.HBASE_CONFIG_RESOURCES_LOCATIONS(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String useHBaseReources = (String)parameters.getOrElse((Object)this.USE_HBASE_CONTEXT(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        });
        String usePushDownColumnFilter = (String)parameters.getOrElse((Object)this.PUSH_DOWN_COLUMN_FILTER(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        });
        return new HBaseRelation((String)tableName.get(), this.generateSchemaMappingMap(schemaMappingString), hbaseConfigResources, useHBaseReources.equalsIgnoreCase("true"), usePushDownColumnFilter.equalsIgnoreCase("true"), parameters, sqlContext);
    }

    public HashMap<String, SchemaQualifierDefinition> generateSchemaMappingMap(String schemaMappingString) {
        try {
            String[] columnDefinitions = new StringOps(Predef$.MODULE$.augmentString(schemaMappingString)).split(',');
            HashMap<String, SchemaQualifierDefinition> resultingMap = new HashMap<String, SchemaQualifierDefinition>();
            Predef$.MODULE$.refArrayOps((Object[])columnDefinitions).map((Function1)new Serializable(this, resultingMap){
                public static final long serialVersionUID = 0L;
                private final HashMap resultingMap$1;

                public final SchemaQualifierDefinition apply(String cd) {
                    String[] parts = new StringOps(Predef$.MODULE$.augmentString(cd.trim())).split(' ');
                    if (parts.length == 3) {
                        String[] hbaseDefinitionParts = parts[2].charAt(0) == ':' ? (String[])((Object[])new String[]{"", "key"}) : new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(':');
                        return this.resultingMap$1.put(parts[0], new SchemaQualifierDefinition(parts[0], parts[1], hbaseDefinitionParts[0], hbaseDefinitionParts[1]));
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid value for schema mapping '").append((Object)cd).append((Object)"' should be '<columnName> <columnType> <columnFamily>:<qualifier>' ").append((Object)"for columns and '<columnName> <columnType> :<qualifier>' for rowKeys").toString());
                }
                {
                    this.resultingMap$1 = resultingMap$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchemaQualifierDefinition.class)));
            return resultingMap;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid value for ").append((Object)this.SCHEMA_COLUMNS_MAPPING_KEY()).append((Object)" '").append((Object)schemaMappingString).append((Object)"'").toString(), exception);
        }
    }

    public DefaultSource() {
        Logging.class.$init$((Logging)this);
        this.TABLE_KEY = "hbase.table";
        this.SCHEMA_COLUMNS_MAPPING_KEY = "hbase.columns.mapping";
        this.HBASE_CONFIG_RESOURCES_LOCATIONS = "hbase.config.resources";
        this.USE_HBASE_CONTEXT = "hbase.use.hbase.context";
        this.PUSH_DOWN_COLUMN_FILTER = "hbase.push.down.column.filter";
    }
}

