/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface RegionMergeTransaction {
    public boolean prepare(RegionServerServices var1) throws IOException;

    public Region execute(Server var1, RegionServerServices var2) throws IOException;

    public boolean rollback(Server var1, RegionServerServices var2) throws IOException;

    public RegionMergeTransaction registerTransactionListener(TransactionListener var1);

    public HRegionInfo getMergedRegionInfo();

    public List<JournalEntry> getJournal();

    public Server getServer();

    public RegionServerServices getRegionServerServices();

    public static interface TransactionListener {
        public void transition(RegionMergeTransaction var1, RegionMergeTransactionPhase var2, RegionMergeTransactionPhase var3) throws IOException;

        public void rollback(RegionMergeTransaction var1, RegionMergeTransactionPhase var2, RegionMergeTransactionPhase var3);
    }

    public static interface JournalEntry {
        public RegionMergeTransactionPhase getPhase();

        public long getTimeStamp();
    }

    public static enum RegionMergeTransactionPhase {
        STARTED,
        PREPARED,
        SET_MERGING,
        CREATED_MERGE_DIR,
        CLOSED_REGION_A,
        OFFLINED_REGION_A,
        CLOSED_REGION_B,
        OFFLINED_REGION_B,
        STARTED_MERGED_REGION_CREATION,
        PONR,
        COMPLETED;

    }
}

