/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class TestTableInputFormatScanBase {
    private static final Log LOG = LogFactory.getLog(TestTableInputFormatScanBase.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final TableName TABLE_NAME = TableName.valueOf((String)"scantest");
    static final byte[][] INPUT_FAMILYS = new byte[][]{Bytes.toBytes((String)"content1"), Bytes.toBytes((String)"content2")};
    static final String KEY_STARTROW = "startRow";
    static final String KEY_LASTROW = "stpRow";
    private static Table table = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        TEST_UTIL.enableDebug(TableInputFormat.class);
        TEST_UTIL.enableDebug(TableInputFormatBase.class);
        TEST_UTIL.startMiniCluster(3);
        table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, INPUT_FAMILYS);
        TEST_UTIL.loadTable(table, INPUT_FAMILYS, null, false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected void testScanFromConfiguration(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "ScanFromConfig" + (start != null ? start.toUpperCase(Locale.ROOT) : "Empty") + "To" + (stop != null ? stop.toUpperCase(Locale.ROOT) : "Empty");
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.set("hbase.mapreduce.inputtable", TABLE_NAME.getNameAsString());
        c.set("hbase.mapreduce.scan.column.family", Bytes.toString((byte[])INPUT_FAMILYS[0]) + ", " + Bytes.toString((byte[])INPUT_FAMILYS[1]));
        c.set(KEY_STARTROW, start != null ? start : "");
        c.set(KEY_LASTROW, last != null ? last : "");
        if (start != null) {
            c.set("hbase.mapreduce.scan.row.start", start);
        }
        if (stop != null) {
            c.set("hbase.mapreduce.scan.row.stop", stop);
        }
        Job job = new Job(c, jobName);
        job.setMapperClass(ScanMapper.class);
        job.setReducerClass(ScanReducer.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(ImmutableBytesWritable.class);
        job.setInputFormatClass(TableInputFormat.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        TableMapReduceUtil.addDependencyJars((Job)job);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    protected void testScan(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "Scan" + (start != null ? start.toUpperCase(Locale.ROOT) : "Empty") + "To" + (stop != null ? stop.toUpperCase(Locale.ROOT) : "Empty");
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILYS[0]);
        scan.addFamily(INPUT_FAMILYS[1]);
        if (start != null) {
            scan.setStartRow(Bytes.toBytes((String)start));
        }
        c.set(KEY_STARTROW, start != null ? start : "");
        if (stop != null) {
            scan.setStopRow(Bytes.toBytes((String)stop));
        }
        c.set(KEY_LASTROW, last != null ? last : "");
        LOG.info((Object)("scan before: " + scan));
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob((TableName)TABLE_NAME, (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        LOG.info((Object)("Started " + job.getJobName()));
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        LOG.info((Object)("After map/reduce completion - job " + jobName));
    }

    public void testNumOfSplits(int splitsPerRegion, int expectedNumOfSplits) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "TestJobForNumOfSplits";
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILYS[0]);
        scan.addFamily(INPUT_FAMILYS[1]);
        c.setInt("hbase.mapreduce.tableinput.mappers.per.region", splitsPerRegion);
        c.set(KEY_STARTROW, "");
        c.set(KEY_LASTROW, "");
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob((String)TABLE_NAME.getNameAsString(), (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        TableInputFormat tif = new TableInputFormat();
        tif.setConf(job.getConfiguration());
        Assert.assertEquals((Object)TABLE_NAME, (Object)table.getName());
        List splits = tif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumOfSplits, (long)splits.size());
    }

    public void testNumOfSplitsMR(int splitsPerRegion, int expectedNumOfSplits) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "TestJobForNumOfSplits-MR";
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        JobConf c = new JobConf(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILYS[0]);
        scan.addFamily(INPUT_FAMILYS[1]);
        c.setInt("hbase.mapreduce.tableinput.mappers.per.region", splitsPerRegion);
        c.set(KEY_STARTROW, "");
        c.set(KEY_LASTROW, "");
        Job job = Job.getInstance((Configuration)c, (String)jobName);
        TableMapReduceUtil.initTableMapperJob((String)TABLE_NAME.getNameAsString(), (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(NullOutputFormat.class);
        Assert.assertTrue((String)"job failed!", (boolean)job.waitForCompletion(true));
        Assert.assertEquals((String)"Saw the wrong count of mappers per region", (long)expectedNumOfSplits, (long)job.getCounters().findCounter((Enum)TaskCounter.SHUFFLED_MAPS).getValue());
    }

    public void testAutobalanceNumOfSplit() throws IOException {
        ArrayList<TableSplit> splits = new ArrayList<TableSplit>(5);
        int[] regionLen = new int[]{10, 20, 20, 40, 60};
        for (int i = 0; i < 5; ++i) {
            TableSplit split = new TableSplit(TABLE_NAME, new Scan(), Bytes.toBytes((int)i), Bytes.toBytes((int)(i + 1)), "", "", (long)(regionLen[i] * 0x100000));
            splits.add(split);
        }
        TableInputFormat tif = new TableInputFormat();
        List res = tif.calculateAutoBalancedSplits(splits, 0x40000000L);
        Assert.assertEquals((String)"Saw the wrong number of splits", (long)5L, (long)res.size());
        TableSplit ts1 = (TableSplit)res.get(0);
        Assert.assertEquals((String)"The first split end key should be", (long)2L, (long)Bytes.toInt((byte[])ts1.getEndRow()));
        TableSplit ts2 = (TableSplit)res.get(1);
        Assert.assertEquals((String)"The second split regionsize should be", (long)0x1400000L, (long)ts2.getLength());
        TableSplit ts3 = (TableSplit)res.get(2);
        Assert.assertEquals((String)"The third split start key should be", (long)3L, (long)Bytes.toInt((byte[])ts3.getStartRow()));
        TableSplit ts4 = (TableSplit)res.get(4);
        Assert.assertNotEquals((String)"The seventh split start key should not be", (long)4L, (long)Bytes.toInt((byte[])ts4.getStartRow()));
    }

    public static class ScanReducer
    extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private String first = null;
        private String last = null;

        protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (ImmutableBytesWritable value : values) {
                String val = Bytes.toStringBinary((byte[])value.get());
                LOG.info((Object)("reduce: key[" + count + "] -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val));
                if (this.first == null) {
                    this.first = val;
                }
                this.last = val;
                ++count;
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration c = context.getConfiguration();
            String startRow = c.get(TestTableInputFormatScanBase.KEY_STARTROW);
            String lastRow = c.get(TestTableInputFormatScanBase.KEY_LASTROW);
            LOG.info((Object)("cleanup: first -> \"" + this.first + "\", start row -> \"" + startRow + "\""));
            LOG.info((Object)("cleanup: last -> \"" + this.last + "\", last row -> \"" + lastRow + "\""));
            if (startRow != null && startRow.length() > 0) {
                Assert.assertEquals((Object)startRow, (Object)this.first);
            }
            if (lastRow != null && lastRow.length() > 0) {
                Assert.assertEquals((Object)lastRow, (Object)this.last);
            }
        }
    }

    public static class ScanMapper
    extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 2) {
                throw new IOException("There should be two input columns");
            }
            NavigableMap cfMap = value.getMap();
            if (!cfMap.containsKey(INPUT_FAMILYS[0]) || !cfMap.containsKey(INPUT_FAMILYS[1])) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILYS[0]) + "' or '" + Bytes.toString((byte[])INPUT_FAMILYS[1]) + "'.");
            }
            String val0 = Bytes.toStringBinary((byte[])value.getValue(INPUT_FAMILYS[0], null));
            String val1 = Bytes.toStringBinary((byte[])value.getValue(INPUT_FAMILYS[1], null));
            LOG.info((Object)("map: key -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> (" + val0 + ", " + val1 + ")"));
            context.write((Object)key, (Object)key);
        }
    }
}

