/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private final String shippedKBsKey;
    private final String logReadInBytesKey;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableFastCounter logReadInEditsCounter;
    private final MutableFastCounter logEditsFilteredCounter;
    private final MutableFastCounter shippedBatchesCounter;
    private final MutableFastCounter shippedOpsCounter;
    private final MutableFastCounter shippedKBsCounter;
    private final MutableFastCounter logReadInBytesCounter;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.ageOfLastShippedOpKey = "source." + id + ".ageOfLastShippedOp";
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getGauge(this.ageOfLastShippedOpKey, 0L);
        this.sizeOfLogQueueKey = "source." + id + ".sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = "source." + this.id + ".shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = "source." + this.id + ".shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = "source." + this.id + ".shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getCounter(this.shippedKBsKey, 0L);
        this.logReadInBytesKey = "source." + this.id + ".logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = "source." + id + ".logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = "source." + id + ".logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getCounter(this.logEditsFilteredKey, 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }
}

