/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationGlobalSourceSource
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableFastCounter logReadInEditsCounter;
    private final MutableFastCounter logEditsFilteredCounter;
    private final MutableFastCounter shippedBatchesCounter;
    private final MutableFastCounter shippedOpsCounter;
    private final MutableFastCounter shippedKBsCounter;
    private final MutableFastCounter logReadInBytesCounter;

    public MetricsReplicationGlobalSourceSource(MetricsReplicationSourceImpl rms) {
        this.rms = rms;
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getGauge("source.ageOfLastShippedOp", 0L);
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getGauge("source.sizeOfLogQueue", 0L);
        this.shippedBatchesCounter = rms.getMetricsRegistry().getCounter("source.shippedBatches", 0L);
        this.shippedOpsCounter = rms.getMetricsRegistry().getCounter("source.shippedOps", 0L);
        this.shippedKBsCounter = rms.getMetricsRegistry().getCounter("source.shippedKBs", 0L);
        this.logReadInBytesCounter = rms.getMetricsRegistry().getCounter("source.logReadInBytes", 0L);
        this.logReadInEditsCounter = rms.getMetricsRegistry().getCounter("source.logEditsRead", 0L);
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getCounter("source.logEditsFiltered", 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }
}

