/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsRegionSourceImpl
implements MetricsRegionSource {
    private static final Log LOG = LogFactory.getLog(MetricsRegionSourceImpl.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private MetricsRegionWrapper regionWrapper;
    private final MetricsRegionAggregateSourceImpl agg;
    private final DynamicMetricsRegistry registry;
    private final String regionNamePrefix;
    private final String regionPutKey;
    private final String regionDeleteKey;
    private final String regionGetKey;
    private final String regionIncrementKey;
    private final String regionAppendKey;
    private final String regionScanNextKey;
    private final MutableFastCounter regionPut;
    private final MutableFastCounter regionDelete;
    private final MutableFastCounter regionIncrement;
    private final MutableFastCounter regionAppend;
    private final MetricHistogram regionGet;
    private final MetricHistogram regionScanNext;
    private final int hashCode;

    public MetricsRegionSourceImpl(MetricsRegionWrapper regionWrapper, MetricsRegionAggregateSourceImpl aggregate) {
        this.regionWrapper = regionWrapper;
        this.agg = aggregate;
        this.agg.register(this);
        LOG.debug((Object)("Creating new MetricsRegionSourceImpl for table " + regionWrapper.getTableName() + " " + regionWrapper.getRegionName()));
        this.registry = this.agg.getMetricsRegistry();
        this.regionNamePrefix = "Namespace_" + regionWrapper.getNamespace() + "_table_" + regionWrapper.getTableName() + "_region_" + regionWrapper.getRegionName() + "_metric_";
        String suffix = "Count";
        this.regionPutKey = this.regionNamePrefix + "mutate" + suffix;
        this.regionPut = this.registry.getCounter(this.regionPutKey, 0L);
        this.regionDeleteKey = this.regionNamePrefix + "delete" + suffix;
        this.regionDelete = this.registry.getCounter(this.regionDeleteKey, 0L);
        this.regionIncrementKey = this.regionNamePrefix + "increment" + suffix;
        this.regionIncrement = this.registry.getCounter(this.regionIncrementKey, 0L);
        this.regionAppendKey = this.regionNamePrefix + "append" + suffix;
        this.regionAppend = this.registry.getCounter(this.regionAppendKey, 0L);
        this.regionGetKey = this.regionNamePrefix + "get";
        this.regionGet = this.registry.newTimeHistogram(this.regionGetKey);
        this.regionScanNextKey = this.regionNamePrefix + "scanNext";
        this.regionScanNext = this.registry.newTimeHistogram(this.regionScanNextKey);
        this.hashCode = regionWrapper.getRegionHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        this.agg.deregister(this);
        MetricsRegionSourceImpl metricsRegionSourceImpl = this;
        synchronized (metricsRegionSourceImpl) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Removing region Metrics: " + this.regionWrapper.getRegionName()));
            }
            this.registry.removeMetric(this.regionPutKey);
            this.registry.removeMetric(this.regionDeleteKey);
            this.registry.removeMetric(this.regionIncrementKey);
            this.registry.removeMetric(this.regionAppendKey);
            this.registry.removeMetric(this.regionGetKey);
            this.registry.removeMetric(this.regionScanNextKey);
            this.registry.removeHistogramMetrics(this.regionGetKey);
            this.registry.removeHistogramMetrics(this.regionScanNextKey);
            this.regionWrapper = null;
        }
    }

    public void updatePut() {
        this.regionPut.incr();
    }

    public void updateDelete() {
        this.regionDelete.incr();
    }

    public void updateGet(long getSize) {
        this.regionGet.add(getSize);
    }

    public void updateScan(long scanSize) {
        this.regionScanNext.add(scanSize);
    }

    public void updateIncrement() {
        this.regionIncrement.incr();
    }

    public void updateAppend() {
        this.regionAppend.incr();
    }

    public MetricsRegionAggregateSource getAggregateSource() {
        return this.agg;
    }

    public int compareTo(MetricsRegionSource source) {
        if (!(source instanceof MetricsRegionSourceImpl)) {
            return -1;
        }
        MetricsRegionSourceImpl impl = (MetricsRegionSourceImpl)source;
        if (impl == null) {
            return -1;
        }
        return Long.compare(this.hashCode, impl.hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsRegionSourceImpl metricsRegionSourceImpl = this;
        synchronized (metricsRegionSourceImpl) {
            if (this.closed.get()) {
                return;
            }
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeCount"), (String)"Number of Stores"), this.regionWrapper.getNumStores());
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeFileCount"), (String)"Number of Store Files"), this.regionWrapper.getNumStoreFiles());
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "memStoreSize"), (String)"Size of the memstore"), this.regionWrapper.getMemstoreSize());
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeFileSize"), (String)"Size of storefiles being served."), this.regionWrapper.getStoreFileSize());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "compactionsCompletedCount"), (String)"Number of compactions that have completed."), this.regionWrapper.getNumCompactionsCompleted());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "numBytesCompactedCount"), (String)"Sum of filesize on all files entering a finished, successful or aborted, compaction"), this.regionWrapper.getNumBytesCompacted());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "numFilesCompactedCount"), (String)"Number of files that were input for finished, successful or aborted, compactions"), this.regionWrapper.getNumFilesCompacted());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "readRequestCount"), (String)"Number of read requests this region server has answered."), this.regionWrapper.getReadRequestCount());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "writeRequestCount"), (String)"Number of mutation requests this region server has answered."), this.regionWrapper.getWriteRequestCount());
            mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "replicaid"), (String)"The replica ID of a region. 0 is primary, otherwise is secondary"), this.regionWrapper.getReplicaId());
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MetricsRegionSourceImpl && this.compareTo((MetricsRegionSourceImpl)obj) == 0;
    }
}

