/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MetricHistogram scanNextHisto;
    private final MutableFastCounter slowPut;
    private final MutableFastCounter slowDelete;
    private final MutableFastCounter slowGet;
    private final MutableFastCounter slowIncrement;
    private final MutableFastCounter slowAppend;
    private final MutableFastCounter splitRequest;
    private final MutableFastCounter splitSuccess;
    private final MetricHistogram splitTimeHisto;
    private final MetricHistogram flushTimeHisto;
    private final MutableFastCounter infoPauseThresholdExceeded;
    private final MutableFastCounter warnPauseThresholdExceeded;
    private final MetricHistogram pausesWithGc;
    private final MetricHistogram pausesWithoutGc;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newTimeHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newTimeHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newTimeHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newTimeHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newTimeHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newTimeHistogram("replay");
        this.scanNextHisto = this.getMetricsRegistry().newTimeHistogram("scanNext");
        this.splitTimeHisto = this.getMetricsRegistry().newTimeHistogram("splitTime");
        this.flushTimeHisto = this.getMetricsRegistry().newTimeHistogram("flushTime");
        this.splitRequest = this.getMetricsRegistry().newCounter("splitRequestCount", "Number of splits requested", 0L);
        this.splitSuccess = this.getMetricsRegistry().newCounter("splitSuccessCount", "Number of successfully executed splits", 0L);
        this.infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
        this.warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
        this.pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
        this.pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void updateScannerNext(long scanSize) {
        this.scanNextHisto.add(scanSize);
    }

    public void incrSlowPut() {
        this.slowPut.incr();
    }

    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    public void incrSlowGet() {
        this.slowGet.incr();
    }

    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    public void incrSplitRequest() {
        this.splitRequest.incr();
    }

    public void incrSplitSuccess() {
        this.splitSuccess.incr();
    }

    public void updateSplitTime(long t) {
        this.splitTimeHisto.add(t);
    }

    public void updateFlushTime(long t) {
        this.flushTimeHisto.add(t);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.rsWrap != null) {
            mrb.addGauge(Interns.info((String)"regionCount", (String)"Number of regions"), this.rsWrap.getNumOnlineRegions()).addGauge(Interns.info((String)"storeCount", (String)"Number of Stores"), this.rsWrap.getNumStores()).addGauge(Interns.info((String)"hlogFileCount", (String)"Number of WAL Files"), this.rsWrap.getNumWALFiles()).addGauge(Interns.info((String)"hlogFileSize", (String)"Size of all WAL Files"), this.rsWrap.getWALFileSize()).addGauge(Interns.info((String)"storeFileCount", (String)"Number of Store Files"), this.rsWrap.getNumStoreFiles()).addGauge(Interns.info((String)"memStoreSize", (String)"Size of the memstore"), this.rsWrap.getMemstoreSize()).addGauge(Interns.info((String)"storeFileSize", (String)"Size of storefiles being served."), this.rsWrap.getStoreFileSize()).addGauge(Interns.info((String)"regionServerStartTime", (String)"RegionServer Start Time"), this.rsWrap.getStartCode()).addCounter(Interns.info((String)"totalRequestCount", (String)"Total number of requests this RegionServer has answered."), this.rsWrap.getTotalRequestCount()).addCounter(Interns.info((String)"readRequestCount", (String)"Number of read requests this region server has answered."), this.rsWrap.getReadRequestsCount()).addCounter(Interns.info((String)"writeRequestCount", (String)"Number of mutation requests this region server has answered."), this.rsWrap.getWriteRequestsCount()).addCounter(Interns.info((String)"checkMutateFailedCount", (String)"Number of Check and Mutate calls that failed the checks."), this.rsWrap.getCheckAndMutateChecksFailed()).addCounter(Interns.info((String)"checkMutatePassedCount", (String)"Number of Check and Mutate calls that passed the checks."), this.rsWrap.getCheckAndMutateChecksPassed()).addGauge(Interns.info((String)"storeFileIndexSize", (String)"Size of indexes in storefiles on disk."), this.rsWrap.getStoreFileIndexSize()).addGauge(Interns.info((String)"staticIndexSize", (String)"Uncompressed size of the static indexes."), this.rsWrap.getTotalStaticIndexSize()).addGauge(Interns.info((String)"staticBloomSize", (String)"Uncompressed size of the static bloom filters."), this.rsWrap.getTotalStaticBloomSize()).addGauge(Interns.info((String)"mutationsWithoutWALCount", (String)"Number of mutations that have been sent by clients with the write ahead logging turned off."), this.rsWrap.getNumMutationsWithoutWAL()).addGauge(Interns.info((String)"mutationsWithoutWALSize", (String)"Size of data that has been sent by clients with the write ahead logging turned off."), this.rsWrap.getDataInMemoryWithoutWAL()).addGauge(Interns.info((String)"percentFilesLocal", (String)"The percent of HFiles that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocal()).addGauge(Interns.info((String)"percentFilesLocalSecondaryRegions", (String)"The percent of HFiles used by secondary regions that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocalSecondaryRegions()).addGauge(Interns.info((String)"splitQueueLength", (String)"Length of the queue for splits."), this.rsWrap.getSplitQueueSize()).addGauge(Interns.info((String)"compactionQueueLength", (String)"Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info((String)"flushQueueLength", (String)"Length of the queue for region flushes"), this.rsWrap.getFlushQueueSize()).addGauge(Interns.info((String)"blockCacheFreeSize", (String)"Size of the block cache that is not occupied."), this.rsWrap.getBlockCacheFreeSize()).addGauge(Interns.info((String)"blockCacheCount", (String)"Number of block in the block cache."), this.rsWrap.getBlockCacheCount()).addGauge(Interns.info((String)"blockCacheSize", (String)"Size of the block cache."), this.rsWrap.getBlockCacheSize()).addCounter(Interns.info((String)"blockCacheHitCount", (String)"Count of the hit on the block cache."), this.rsWrap.getBlockCacheHitCount()).addCounter(Interns.info((String)"blockCacheHitCountPrimary", (String)"Count of hit on primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryHitCount()).addCounter(Interns.info((String)"blockCacheMissCount", (String)"Number of requests for a block that missed the block cache."), this.rsWrap.getBlockCacheMissCount()).addCounter(Interns.info((String)"blockCacheMissCountPrimary", (String)"Number of requests for a block of primary replica that missed the block cache."), this.rsWrap.getBlockCachePrimaryMissCount()).addCounter(Interns.info((String)"blockCacheEvictionCount", (String)"Count of the number of blocks evicted from the block cache."), this.rsWrap.getBlockCacheEvictedCount()).addCounter(Interns.info((String)"blockCacheEvictionCountPrimary", (String)"Count of the number of blocks evicted from primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryEvictedCount()).addGauge(Interns.info((String)"blockCacheCountHitPercent", (String)"Percent of block cache requests that are hits"), this.rsWrap.getBlockCacheHitPercent()).addGauge(Interns.info((String)"blockCountHitPercent", (String)"Percent of block cache requests that are hits"), this.rsWrap.getBlockHitPercent()).addGauge(Interns.info((String)"blockCacheExpressHitPercent", (String)"The percent of the time that requests with the cache turned on hit the cache."), this.rsWrap.getBlockCacheHitCachingPercent()).addCounter(Interns.info((String)"blockCacheFailedInsertionCount", (String)"Number of times that a block cache insertion failed. Usually due to size restrictions."), this.rsWrap.getBlockCacheFailedInsertions()).addCounter(Interns.info((String)"updatesBlockedTime", (String)"Number of MS updates have been blocked so that the memstore can be flushed."), this.rsWrap.getUpdatesBlockedTime()).addCounter(Interns.info((String)"flushedCellsCount", (String)"The number of cells flushed to disk"), this.rsWrap.getFlushedCellsCount()).addCounter(Interns.info((String)"compactedCellsCount", (String)"The number of cells processed during minor compactions"), this.rsWrap.getCompactedCellsCount()).addCounter(Interns.info((String)"majorCompactedCellsCount", (String)"The number of cells processed during major compactions"), this.rsWrap.getMajorCompactedCellsCount()).addCounter(Interns.info((String)"flushedCellsSize", (String)"The total amount of data flushed to disk, in bytes"), this.rsWrap.getFlushedCellsSize()).addCounter(Interns.info((String)"compactedCellsSize", (String)"The total amount of data processed during minor compactions, in bytes"), this.rsWrap.getCompactedCellsSize()).addCounter(Interns.info((String)"majorCompactedCellsSize", (String)"The total amount of data processed during major compactions, in bytes"), this.rsWrap.getMajorCompactedCellsSize()).addCounter(Interns.info((String)"blockedRequestCount", (String)"The number of blocked requests because of memstore size is larger than blockingMemStoreSize"), this.rsWrap.getBlockedRequestsCount()).addCounter(Interns.info((String)"hedgedReads", (String)"The number of times we started a hedged read"), this.rsWrap.getHedgedReadOps()).addCounter(Interns.info((String)"hedgedReadWins", (String)"The number of times we started a hedged read and a hedged read won"), this.rsWrap.getHedgedReadWins()).addCounter(Interns.info((String)"mobCompactedFromMobCellsCount", (String)"The number of cells moved from mob during compaction"), this.rsWrap.getMobCompactedFromMobCellsCount()).addCounter(Interns.info((String)"mobCompactedIntoMobCellsCount", (String)"The number of cells moved to mob during compaction"), this.rsWrap.getMobCompactedIntoMobCellsCount()).addCounter(Interns.info((String)"mobCompactedFromMobCellsSize", (String)"The total amount of cells move from mob during compaction, in bytes"), this.rsWrap.getMobCompactedFromMobCellsSize()).addCounter(Interns.info((String)"mobCompactedIntoMobCellsSize", (String)"The total amount of cells move to mob during compaction, in bytes"), this.rsWrap.getMobCompactedIntoMobCellsSize()).addCounter(Interns.info((String)"mobFlushCount", (String)"The number of the flushes in mob-enabled stores"), this.rsWrap.getMobFlushCount()).addCounter(Interns.info((String)"mobFlushedCellsCount", (String)"The number of mob cells flushed to disk"), this.rsWrap.getMobFlushedCellsCount()).addCounter(Interns.info((String)"mobFlushedCellsSize", (String)"The total amount of mob cells flushed to disk, in bytes"), this.rsWrap.getMobFlushedCellsSize()).addCounter(Interns.info((String)"mobScanCellsCount", (String)"The number of scanned mob cells"), this.rsWrap.getMobScanCellsCount()).addCounter(Interns.info((String)"mobScanCellsSize", (String)"The total amount of scanned mob cells, in bytes"), this.rsWrap.getMobScanCellsSize()).addGauge(Interns.info((String)"mobFileCacheCount", (String)"The count of cached mob files"), this.rsWrap.getMobFileCacheCount()).addCounter(Interns.info((String)"mobFileCacheAccessCount", (String)"The count of accesses to the mob file cache"), this.rsWrap.getMobFileCacheAccessCount()).addCounter(Interns.info((String)"mobFileCacheMissCount", (String)"The count of misses to the mob file cache"), this.rsWrap.getMobFileCacheMissCount()).addCounter(Interns.info((String)"mobFileCacheEvictedCount", (String)"The number of items evicted from the mob file cache"), this.rsWrap.getMobFileCacheEvictedCount()).addGauge(Interns.info((String)"mobFileCacheHitPercent", (String)"The hit percent to the mob file cache"), this.rsWrap.getMobFileCacheHitPercent()).tag(Interns.info((String)"zookeeperQuorum", (String)"Zookeeper Quorum"), this.rsWrap.getZookeeperQuorum()).tag(Interns.info((String)"serverName", (String)"Server Name"), this.rsWrap.getServerName()).tag(Interns.info((String)"clusterId", (String)"Cluster Id"), this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }

    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr(count);
    }

    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr(count);
    }

    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

