/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsHBaseServerSourceImpl
extends BaseSourceImpl
implements MetricsHBaseServerSource {
    private final MetricsHBaseServerWrapper wrapper;
    private final MutableFastCounter authorizationSuccesses;
    private final MutableFastCounter authorizationFailures;
    private final MutableFastCounter authenticationSuccesses;
    private final MutableFastCounter authenticationFailures;
    private final MutableFastCounter authenticationFallbacks;
    private final MutableFastCounter sentBytes;
    private final MutableFastCounter receivedBytes;
    private final MutableFastCounter exceptions;
    private final MutableFastCounter exceptionsOOO;
    private final MutableFastCounter exceptionsBusy;
    private final MutableFastCounter exceptionsUnknown;
    private final MutableFastCounter exceptionsSanity;
    private final MutableFastCounter exceptionsNSRE;
    private final MutableFastCounter exceptionsMoved;
    private final MutableFastCounter exceptionsMultiTooLarge;
    private MetricHistogram queueCallTime;
    private MetricHistogram processCallTime;
    private MetricHistogram totalCallTime;
    private MetricHistogram requestSize;
    private MetricHistogram responseSize;

    public MetricsHBaseServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsHBaseServerWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.authorizationSuccesses = this.getMetricsRegistry().newCounter("authorizationSuccesses", "Number of authorization successes.", 0L);
        this.authorizationFailures = this.getMetricsRegistry().newCounter("authorizationFailures", "Number of authorization failures.", 0L);
        this.exceptions = this.getMetricsRegistry().newCounter("exceptions", "Exceptions caused by requests", 0L);
        this.exceptionsOOO = this.getMetricsRegistry().newCounter("exceptions.OutOfOrderScannerNextException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsBusy = this.getMetricsRegistry().newCounter("exceptions.RegionTooBusyException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsUnknown = this.getMetricsRegistry().newCounter("exceptions.UnknownScannerException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsSanity = this.getMetricsRegistry().newCounter("exceptions.FailedSanityCheckException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMoved = this.getMetricsRegistry().newCounter("exceptions.RegionMovedException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsNSRE = this.getMetricsRegistry().newCounter("exceptions.NotServingRegionException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMultiTooLarge = this.getMetricsRegistry().newCounter("exceptions.multiResponseTooLarge", "A response to a multi request was too large and the rest of the requests will have to be retried.", 0L);
        this.authenticationSuccesses = this.getMetricsRegistry().newCounter("authenticationSuccesses", "Number of authentication successes.", 0L);
        this.authenticationFailures = this.getMetricsRegistry().newCounter("authenticationFailures", "Number of authentication failures.", 0L);
        this.authenticationFallbacks = this.getMetricsRegistry().newCounter("authenticationFallbacks", "Number of fallbacks to insecure authentication.", 0L);
        this.sentBytes = this.getMetricsRegistry().newCounter("sentBytes", "Number of bytes sent.", 0L);
        this.receivedBytes = this.getMetricsRegistry().newCounter("receivedBytes", "Number of bytes received.", 0L);
        this.queueCallTime = this.getMetricsRegistry().newTimeHistogram("queueCallTime", "Queue Call Time.");
        this.processCallTime = this.getMetricsRegistry().newTimeHistogram("processCallTime", "Processing call time.");
        this.totalCallTime = this.getMetricsRegistry().newTimeHistogram("totalCallTime", "Total call time, including both queued and processing time.");
        this.requestSize = this.getMetricsRegistry().newSizeHistogram("requestSize", "Request size in bytes.");
        this.responseSize = this.getMetricsRegistry().newSizeHistogram("responseSize", "Response size in bytes.");
    }

    public void authorizationSuccess() {
        this.authorizationSuccesses.incr();
    }

    public void authorizationFailure() {
        this.authorizationFailures.incr();
    }

    public void authenticationFailure() {
        this.authenticationFailures.incr();
    }

    public void authenticationFallback() {
        this.authenticationFallbacks.incr();
    }

    public void exception() {
        this.exceptions.incr();
    }

    public void outOfOrderException() {
        this.exceptionsOOO.incr();
    }

    public void failedSanityException() {
        this.exceptionsSanity.incr();
    }

    public void movedRegionException() {
        this.exceptionsMoved.incr();
    }

    public void notServingRegionException() {
        this.exceptionsNSRE.incr();
    }

    public void unknownScannerException() {
        this.exceptionsUnknown.incr();
    }

    public void tooBusyException() {
        this.exceptionsBusy.incr();
    }

    public void multiActionTooLargeException() {
        this.exceptionsMultiTooLarge.incr();
    }

    public void authenticationSuccess() {
        this.authenticationSuccesses.incr();
    }

    public void sentBytes(long count) {
        this.sentBytes.incr(count);
    }

    public void receivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    public void sentResponse(long count) {
        this.responseSize.add(count);
    }

    public void receivedRequest(long count) {
        this.requestSize.add(count);
    }

    public void dequeuedCall(int qTime) {
        this.queueCallTime.add((long)qTime);
    }

    public void processedCall(int processingTime) {
        this.processCallTime.add((long)processingTime);
    }

    public void queuedAndProcessedCall(int totalTime) {
        this.totalCallTime.add((long)totalTime);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addGauge(Interns.info((String)"queueSize", (String)"Number of bytes in the call queues."), this.wrapper.getTotalQueueSize()).addGauge(Interns.info((String)"numCallsInGeneralQueue", (String)"Number of calls in the general call queue."), this.wrapper.getGeneralQueueLength()).addGauge(Interns.info((String)"numCallsInReplicationQueue", (String)"Number of calls in the replication call queue."), this.wrapper.getReplicationQueueLength()).addGauge(Interns.info((String)"numCallsInPriorityQueue", (String)"Number of calls in the priority call queue."), this.wrapper.getPriorityQueueLength()).addGauge(Interns.info((String)"numOpenConnections", (String)"Number of open connections."), this.wrapper.getNumOpenConnections()).addGauge(Interns.info((String)"numActiveHandler", (String)"Number of active rpc handlers."), this.wrapper.getActiveRpcHandlerCount());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

