/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;

@Singleton
public class RMWebAppFilter
extends GuiceContainer {
    private Injector injector;
    private static final long serialVersionUID = 1L;
    private static final Set<String> NON_REDIRECTED_URIS = Sets.newHashSet((Object[])new String[]{"/conf", "/stacks", "/logLevel", "/metrics", "/jmx", "/logs"});
    private String path;
    private static final int BASIC_SLEEP_TIME = 5;
    private static final int MAX_SLEEP_TIME = 300;
    private static final Random randnum = new Random();

    @Inject
    public RMWebAppFilter(Injector injector, Configuration conf) {
        super(injector);
        this.injector = injector;
        InetSocketAddress sock = YarnConfiguration.useHttps((Configuration)conf) ? conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090) : conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088);
        this.path = sock.getHostName() + ":" + Integer.toString(sock.getPort());
        this.path = YarnConfiguration.useHttps((Configuration)conf) ? "https://" + this.path : "http://" + this.path;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        response.setCharacterEncoding("UTF-8");
        String uri = HtmlQuoting.quoteHtmlChars((String)request.getRequestURI());
        if (uri == null) {
            uri = "/";
        }
        RMWebApp rmWebApp = (RMWebApp)((Object)this.injector.getInstance(RMWebApp.class));
        rmWebApp.checkIfStandbyRM();
        if (rmWebApp.isStandby() && this.shouldRedirect(rmWebApp, uri)) {
            String redirectPath = rmWebApp.getRedirectPath();
            if (redirectPath != null && !redirectPath.isEmpty()) {
                redirectPath = redirectPath + uri;
                String redirectMsg = "This is standby RM. Redirecting to the current active RM: " + redirectPath;
                response.addHeader("Refresh", "3; url=" + redirectPath);
                PrintWriter out = response.getWriter();
                out.println(redirectMsg);
                return;
            }
            boolean doRetry = true;
            String retryIntervalStr = request.getParameter("next.fresh.interval");
            int retryInterval = 0;
            if (retryIntervalStr != null) {
                try {
                    retryInterval = Integer.parseInt(retryIntervalStr.trim());
                }
                catch (NumberFormatException ex) {
                    doRetry = false;
                }
            }
            int next = RMWebAppFilter.calculateExponentialTime(retryInterval);
            String redirectUrl = this.appendOrReplaceParamter(this.path + uri, "next.fresh.interval=" + (retryInterval + 1));
            if (redirectUrl == null || next > 300) {
                doRetry = false;
            }
            String redirectMsg = doRetry ? "Can not find any active RM. Will retry in next " + next + " seconds." : "There is no active RM right now.";
            redirectMsg = redirectMsg + "\nHA Zookeeper Connection State: " + rmWebApp.getHAZookeeperConnectionState();
            PrintWriter out = response.getWriter();
            out.println(redirectMsg);
            if (doRetry) {
                response.setHeader("Refresh", next + ";url=" + redirectUrl);
                response.setStatus(307);
            }
            return;
        }
        super.doFilter(request, response, chain);
    }

    private boolean shouldRedirect(RMWebApp rmWebApp, String uri) {
        return !uri.equals("/" + rmWebApp.wsName() + "/v1/cluster/info") && !uri.equals("/" + rmWebApp.name() + "/cluster") && !NON_REDIRECTED_URIS.contains(uri);
    }

    private String appendOrReplaceParamter(String uri, String newQuery) {
        if (uri.contains("next.fresh.interval=")) {
            return uri.replaceAll("next.fresh.interval=[^&]+", newQuery);
        }
        try {
            URI oldUri = new URI(uri);
            String appendQuery = oldUri.getQuery();
            appendQuery = appendQuery == null ? newQuery : appendQuery + "&" + newQuery;
            URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), appendQuery, oldUri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static int calculateExponentialTime(int retries) {
        long baseTime = 5L * (1L << retries);
        return (int)((double)baseTime * (randnum.nextDouble() + 0.5));
    }
}

