/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;

public class RMNodeStatusEvent
extends RMNodeEvent {
    private final NodeHealthStatus nodeHealthStatus;
    private final List<ContainerStatus> containersCollection;
    private final NodeHeartbeatResponse latestResponse;
    private final List<ApplicationId> keepAliveAppIds;
    private List<LogAggregationReport> logAggregationReportsForApps;

    public RMNodeStatusEvent(NodeId nodeId, NodeHealthStatus nodeHealthStatus, List<ContainerStatus> collection, List<ApplicationId> keepAliveAppIds, NodeHeartbeatResponse latestResponse) {
        super(nodeId, RMNodeEventType.STATUS_UPDATE);
        this.nodeHealthStatus = nodeHealthStatus;
        this.containersCollection = collection;
        this.keepAliveAppIds = keepAliveAppIds;
        this.latestResponse = latestResponse;
        this.logAggregationReportsForApps = null;
    }

    public RMNodeStatusEvent(NodeId nodeId, NodeHealthStatus nodeHealthStatus, List<ContainerStatus> collection, List<ApplicationId> keepAliveAppIds, NodeHeartbeatResponse latestResponse, List<LogAggregationReport> logAggregationReportsForApps) {
        super(nodeId, RMNodeEventType.STATUS_UPDATE);
        this.nodeHealthStatus = nodeHealthStatus;
        this.containersCollection = collection;
        this.keepAliveAppIds = keepAliveAppIds;
        this.latestResponse = latestResponse;
        this.logAggregationReportsForApps = logAggregationReportsForApps;
    }

    public NodeHealthStatus getNodeHealthStatus() {
        return this.nodeHealthStatus;
    }

    public List<ContainerStatus> getContainers() {
        return this.containersCollection;
    }

    public NodeHeartbeatResponse getLatestResponse() {
        return this.latestResponse;
    }

    public List<ApplicationId> getKeepAliveAppIds() {
        return this.keepAliveAppIds;
    }

    public List<LogAggregationReport> getLogAggregationReportsForApps() {
        return this.logAggregationReportsForApps;
    }

    public void setLogAggregationReportsForApps(List<LogAggregationReport> logAggregationReportsForApps) {
        this.logAggregationReportsForApps = logAggregationReportsForApps;
    }
}

