/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTokenCache {
    private static final int NUM_OF_KEYS = 10;
    private static MiniMRCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static final Path TEST_DIR;
    private static final Path jsonTokenFile;
    private static final Path binaryTokenFile;
    private static int numSlaves;
    private static JobConf jConf;
    private static ObjectMapper mapper;
    private static Path p1;
    private static Path p2;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        dfsCluster = new MiniDFSCluster(conf, numSlaves, true, null);
        jConf = new JobConf(conf);
        mrCluster = new MiniMRCluster(0, 0, numSlaves, dfsCluster.getFileSystem().getUri().toString(), 1, null, null, null, jConf);
        TestTokenCache.createTokenFileJson();
        TestTokenCache.verifySecretKeysInJSONFile();
        TestTokenCache.createTokenFileBinary();
        TestTokenCache.verifySecretKeysInBinaryFile();
        NameNodeAdapter.getDtSecretManager((FSNamesystem)dfsCluster.getNamesystem()).startThreads();
        DistributedFileSystem fs = dfsCluster.getFileSystem();
        p1 = new Path("file1");
        p2 = new Path("file2");
        p1 = fs.makeQualified(p1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.shutdown();
        }
        mrCluster = null;
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
        dfsCluster = null;
    }

    private static void createTokenFileJson() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            KeyGenerator kg = KeyGenerator.getInstance("HmacSHA1");
            for (int i = 0; i < 10; ++i) {
                SecretKeySpec key = (SecretKeySpec)kg.generateKey();
                byte[] enc_key = key.getEncoded();
                map.put("alias" + i, new String(Base64.encodeBase64((byte[])enc_key)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        try {
            File p = new File(jsonTokenFile.getParent().toString());
            p.mkdirs();
            mapper.writeValue(new File(jsonTokenFile.toString()), map);
        }
        catch (Exception e) {
            System.out.println("failed with :" + e.getLocalizedMessage());
        }
    }

    private static void createTokenFileBinary() throws IOException {
        Credentials creds = new Credentials();
        try {
            KeyGenerator kg = KeyGenerator.getInstance("HmacSHA1");
            for (int i = 0; i < 10; ++i) {
                SecretKeySpec key = (SecretKeySpec)kg.generateKey();
                byte[] enc_key = key.getEncoded();
                creds.addSecretKey(new Text("alias" + i), Base64.encodeBase64((byte[])enc_key));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        try {
            creds.writeTokenStorageFile(new Path(binaryTokenFile.toUri()), new Configuration());
        }
        catch (Exception e) {
            System.out.println("failed with :" + e.getLocalizedMessage());
        }
    }

    private static void verifySecretKeysInJSONFile() throws IOException {
        Map map = (Map)mapper.readValue(new File(jsonTokenFile.toString()), Map.class);
        Assert.assertEquals((String)"didn't read JSON correctly", (long)map.size(), (long)10L);
    }

    private static void verifySecretKeysInBinaryFile() throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((File)new File(binaryTokenFile.toString()), (Configuration)new Configuration());
        Assert.assertEquals((String)"didn't read JSON correctly", (long)creds.numberOfSecretKeys(), (long)10L);
    }

    @Test
    public void testTokenCache() throws IOException {
        jConf = mrCluster.createJobConf();
        NameNode nn = dfsCluster.getNameNode();
        URI nnUri = NameNode.getUri((InetSocketAddress)nn.getNameNodeAddress());
        jConf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri.toString());
        jConf.set("mapreduce.jobtracker.kerberos.principal", "jt_id");
        String[] args = new String[]{"-tokenCacheFile", binaryTokenFile.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jConf, (Tool)new MySleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0", (long)res, (long)0L);
    }

    @Test
    public void testLocalJobTokenCache() throws NoSuchAlgorithmException, IOException {
        jConf = mrCluster.createJobConf();
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        jConf.set("mapreduce.job.credentials.json", jsonTokenFile.toString());
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jConf, (Tool)new MySleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"local Job failed");
        }
        Assert.assertEquals((String)"local job res is not 0", (long)res, (long)0L);
    }

    @Test
    public void testGetTokensForNamenodes() throws IOException {
        DistributedFileSystem fs = dfsCluster.getFileSystem();
        Credentials credentials = new Credentials();
        TokenCache.obtainTokensForNamenodesInternal((Credentials)credentials, (Path[])new Path[]{p1, p2}, (Configuration)jConf);
        String fs_addr = SecurityUtil.buildDTServiceName((URI)p1.toUri(), (int)8020);
        Collection tns = credentials.getAllTokens();
        Assert.assertEquals((String)"number of tokens is not 1", (long)1L, (long)tns.size());
        boolean found = false;
        for (Token t : tns) {
            if (t.getKind().equals((Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND) && t.getService().equals((Object)new Text(fs_addr))) {
                found = true;
            }
            Assert.assertTrue((String)("didn't find token for " + p1), (boolean)found);
        }
    }

    @Test
    public void testCleanUpTokenReferral() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.credentials.binary", "foo");
        TokenCache.cleanUpTokenReferral((Configuration)conf);
        Assert.assertNull((Object)conf.get("mapreduce.job.credentials.binary"));
    }

    @Test
    public void testGetTokensForViewFS() throws IOException, URISyntaxException {
        Configuration conf = new Configuration((Configuration)jConf);
        DistributedFileSystem dfs = dfsCluster.getFileSystem();
        String serviceName = dfs.getCanonicalServiceName();
        Path p1 = new Path("/mount1");
        Path p2 = new Path("/mount2");
        p1 = dfs.makeQualified(p1);
        p2 = dfs.makeQualified(p2);
        conf.set("fs.viewfs.mounttable.default.link./dir1", p1.toString());
        conf.set("fs.viewfs.mounttable.default.link./dir2", p2.toString());
        Credentials credentials = new Credentials();
        Path lp1 = new Path("viewfs:///dir1");
        Path lp2 = new Path("viewfs:///dir2");
        Path[] paths = new Path[]{lp1, lp2};
        TokenCache.obtainTokensForNamenodesInternal((Credentials)credentials, (Path[])paths, (Configuration)conf);
        Collection tns = credentials.getAllTokens();
        Assert.assertEquals((String)"number of tokens is not 1", (long)1L, (long)tns.size());
        boolean found = false;
        for (Token tt : tns) {
            System.out.println("token=" + tt);
            if (tt.getKind().equals((Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND) && tt.getService().equals((Object)new Text(serviceName))) {
                found = true;
            }
            Assert.assertTrue((String)("didn't find token for [" + lp1 + ", " + lp2 + "]"), (boolean)found);
        }
    }

    static {
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "sleepTest");
        jsonTokenFile = new Path(TEST_DIR, "tokenFile.json");
        binaryTokenFile = new Path(TEST_DIR, "tokenFile.bin");
        numSlaves = 1;
        mapper = new ObjectMapper();
    }

    static class MySleepJob
    extends SleepJob
    implements JobConfigurable {
        Credentials ts;

        MySleepJob() {
        }

        public void configure(JobConf job) {
            try {
                this.ts = job.getCredentials();
                Path p1 = new Path("file1");
                p1 = p1.getFileSystem((Configuration)job).makeQualified(p1);
                Credentials cred = new Credentials();
                TokenCache.obtainTokensForNamenodesInternal((Credentials)cred, (Path[])new Path[]{p1}, (Configuration)job);
                for (Token t : cred.getAllTokens()) {
                    this.ts.addToken(new Text("Hdfs"), t);
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Exception " + e));
            }
        }

        public void map(IntWritable key, IntWritable value, OutputCollector<IntWritable, NullWritable> output, Reporter reporter) throws IOException {
            byte[] key1 = this.ts.getSecretKey(new Text("alias1"));
            Collection dts = this.ts.getAllTokens();
            int dts_size = 0;
            if (dts != null) {
                dts_size = dts.size();
            }
            if (dts.size() != 2) {
                throw new RuntimeException("tokens are not available");
            }
            if (key1 == null || this.ts == null || this.ts.numberOfSecretKeys() != 10) {
                throw new RuntimeException("secret keys are not available");
            }
            super.map(key, value, output, reporter);
        }

        public JobConf setupJobConf(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) {
            JobConf job = super.setupJobConf(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
            job.setMapperClass(MySleepJob.class);
            return job;
        }
    }
}

