/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEncryptedShuffle {
    private static final String BASEDIR = System.getProperty("test.build.dir", "build/test-dir") + "/" + TestEncryptedShuffle.class.getSimpleName();
    private MiniDFSCluster dfsCluster = null;
    private MiniMRCluster mrCluster = null;

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @After
    public void cleanUpMiniClusterSpecialConfig() throws Exception {
        String classpathDir = KeyStoreTestUtil.getClasspathDir(TestEncryptedShuffle.class);
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)classpathDir);
    }

    private void startCluster(Configuration conf) throws Exception {
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", "build/test-dir");
        }
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        this.dfsCluster = new MiniDFSCluster(conf, 1, true, null);
        DistributedFileSystem fileSystem = this.dfsCluster.getFileSystem();
        fileSystem.mkdirs(new Path("/tmp"));
        fileSystem.mkdirs(new Path("/user"));
        fileSystem.mkdirs(new Path("/hadoop/mapred/system"));
        fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/hadoop/mapred/system"), FsPermission.valueOf((String)"-rwx------"));
        FileSystem.setDefaultUri((Configuration)conf, (URI)fileSystem.getUri());
        this.mrCluster = new MiniMRCluster(1, fileSystem.getUri().toString(), 1, null, null, new JobConf(conf));
    }

    private void stopCluster() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
    }

    protected JobConf getJobConf(Configuration sslConf) throws IOException {
        JobConf conf = new JobConf((Configuration)this.mrCluster.createJobConf());
        conf.set("mapreduce.shuffle.ssl.enabled", sslConf.get("mapreduce.shuffle.ssl.enabled"));
        conf.set("hadoop.ssl.hostname.verifier", sslConf.get("hadoop.ssl.hostname.verifier"));
        conf.set("hadoop.ssl.client.conf", sslConf.get("hadoop.ssl.client.conf"));
        conf.set("hadoop.ssl.server.conf", sslConf.get("hadoop.ssl.server.conf"));
        conf.set("hadoop.ssl.require.client.cert", sslConf.get("hadoop.ssl.require.client.cert"));
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptedShuffleWithCerts(boolean useClientCerts) throws Exception {
        try {
            Configuration conf = new Configuration();
            String keystoresDir = new File(BASEDIR).getAbsolutePath();
            String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestEncryptedShuffle.class);
            KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfsDir, (Configuration)conf, (boolean)useClientCerts);
            conf.setBoolean("mapreduce.shuffle.ssl.enabled", true);
            this.startCluster(conf);
            FileSystem fs = FileSystem.get((Configuration)this.getJobConf(conf));
            Path inputDir = new Path("input");
            fs.mkdirs(inputDir);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
            writer.write("hello");
            ((Writer)writer).close();
            Path outputDir = new Path("output", "output");
            JobConf jobConf = new JobConf((Configuration)this.getJobConf(conf));
            jobConf.setInt("mapred.map.tasks", 1);
            jobConf.setInt("mapred.map.max.attempts", 1);
            jobConf.setInt("mapred.reduce.max.attempts", 1);
            jobConf.set("mapred.input.dir", inputDir.toString());
            jobConf.set("mapred.output.dir", outputDir.toString());
            JobClient jobClient = new JobClient(jobConf);
            RunningJob runJob = jobClient.submitJob(jobConf);
            runJob.waitForCompletion();
            Assert.assertTrue((boolean)runJob.isComplete());
            Assert.assertTrue((boolean)runJob.isSuccessful());
        }
        finally {
            this.stopCluster();
        }
    }

    @Test
    public void encryptedShuffleWithClientCerts() throws Exception {
        this.encryptedShuffleWithCerts(true);
    }

    @Test
    public void encryptedShuffleWithoutClientCerts() throws Exception {
        this.encryptedShuffleWithCerts(false);
    }
}

