/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFilter;
import org.apache.hadoop.mapreduce.task.MapContextImpl;

public class TestMRSequenceFileInputFilter
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMRSequenceFileInputFilter.class.getName());
    private static final int MAX_LENGTH = 15000;
    private static final Configuration conf = new Configuration();
    private static final Job job;
    private static final FileSystem fs;
    private static final Path inDir;
    private static final Path inFile;
    private static final Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSequenceFile(int numRecords) throws Exception {
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inFile, Text.class, BytesWritable.class);){
            for (int i = 1; i <= numRecords; ++i) {
                Text key = new Text(Integer.toString(i));
                byte[] data = new byte[random.nextInt(10)];
                random.nextBytes(data);
                BytesWritable value = new BytesWritable(data);
                writer.append((Writable)key, (Writable)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countRecords(int numSplits) throws IOException, InterruptedException {
        SequenceFileInputFilter format = new SequenceFileInputFilter();
        if (numSplits == 0) {
            numSplits = random.nextInt(150) + 1;
        }
        FileInputFormat.setMaxInputSplitSize((Job)job, (long)(fs.getFileStatus(inFile).getLen() / (long)numSplits));
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
        int count = 0;
        for (InputSplit split : format.getSplits((JobContext)job)) {
            RecordReader reader = format.createRecordReader(split, context);
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, (TaskAttemptContext)mcontext);
            try {
                while (reader.nextKeyValue()) {
                    LOG.info((Object)("Accept record " + ((Text)reader.getCurrentKey()).toString()));
                    ++count;
                }
            }
            finally {
                reader.close();
            }
        }
        return count;
    }

    public void testRegexFilter() throws Exception {
        LOG.info((Object)"Testing Regex Filter with patter: \\A10*");
        SequenceFileInputFilter.setFilterClass((Job)job, SequenceFileInputFilter.RegexFilter.class);
        SequenceFileInputFilter.RegexFilter.setPattern((Configuration)job.getConfiguration(), (String)"\\A10*");
        fs.delete(inDir, true);
        for (int length = 1; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info((Object)("******Number of records: " + length));
            TestMRSequenceFileInputFilter.createSequenceFile(length);
            int count = this.countRecords(0);
            TestMRSequenceFileInputFilter.assertEquals((int)count, (int)(length == 0 ? 0 : (int)Math.log10(length) + 1));
        }
        fs.delete(inDir, true);
    }

    public void testPercentFilter() throws Exception {
        LOG.info((Object)"Testing Percent Filter with frequency: 1000");
        SequenceFileInputFilter.setFilterClass((Job)job, SequenceFileInputFilter.PercentFilter.class);
        SequenceFileInputFilter.PercentFilter.setFrequency((Configuration)job.getConfiguration(), (int)1000);
        fs.delete(inDir, true);
        for (int length = 0; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info((Object)("******Number of records: " + length));
            TestMRSequenceFileInputFilter.createSequenceFile(length);
            int count = this.countRecords(1);
            LOG.info((Object)("Accepted " + count + " records"));
            int expectedCount = length / 1000;
            if (expectedCount * 1000 != length) {
                ++expectedCount;
            }
            TestMRSequenceFileInputFilter.assertEquals((int)count, (int)expectedCount);
        }
        fs.delete(inDir, true);
    }

    public void testMD5Filter() throws Exception {
        LOG.info((Object)"Testing MD5 Filter with frequency: 1000");
        SequenceFileInputFilter.setFilterClass((Job)job, SequenceFileInputFilter.MD5Filter.class);
        SequenceFileInputFilter.MD5Filter.setFrequency((Configuration)job.getConfiguration(), (int)1000);
        fs.delete(inDir, true);
        for (int length = 0; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info((Object)("******Number of records: " + length));
            TestMRSequenceFileInputFilter.createSequenceFile(length);
            LOG.info((Object)("Accepted " + this.countRecords(0) + " records"));
        }
        fs.delete(inDir, true);
    }

    public static void main(String[] args) throws Exception {
        TestMRSequenceFileInputFilter filter = new TestMRSequenceFileInputFilter();
        filter.testRegexFilter();
    }

    static {
        inDir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        inFile = new Path(inDir, "test.seq");
        random = new Random(1L);
        try {
            job = new Job(conf);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inDir});
            fs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

