/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestMRKeyValueTextInputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMRKeyValueTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        Job job = new Job(new Configuration());
        Path file = new Path(workDir, "test.txt");
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                List splits = format.getSplits((JobContext)job);
                LOG.debug((Object)("splitting: got =        " + splits.size()));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.size(); ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits.get(j)));
                    TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                    RecordReader reader = format.createRecordReader((InputSplit)splits.get(j), context);
                    Class<?> clazz = reader.getClass();
                    TestMRKeyValueTextInputFormat.assertEquals((String)"reader class is KeyValueLineRecordReader.", KeyValueLineRecordReader.class, clazz);
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(j));
                    reader.initialize((InputSplit)splits.get(j), (TaskAttemptContext)mcontext);
                    Text key = null;
                    Text value = null;
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            key = (Text)reader.getCurrentKey();
                            clazz = key.getClass();
                            TestMRKeyValueTextInputFormat.assertEquals((String)"Key class is Text.", Text.class, clazz);
                            value = (Text)reader.getCurrentValue();
                            clazz = value.getClass();
                            TestMRKeyValueTextInputFormat.assertEquals((String)"Value class is Text.", Text.class, clazz);
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            TestMRKeyValueTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits.get(j) + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                TestMRKeyValueTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), defaultConf);
    }

    public void testUTF8() throws Exception {
        LineReader in = this.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        TestMRKeyValueTextInputFormat.assertEquals((String)"readLine changed utf8 characters", (String)"abcd\u20acbdcd\u20ac", (String)line.toString());
        in = this.makeStream("abc\u200axyz");
        in.readLine(line);
        TestMRKeyValueTextInputFormat.assertEquals((String)"split on fake newline", (String)"abc\u200axyz", (String)line.toString());
    }

    public void testNewLines() throws Exception {
        LineReader in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
        Text out = new Text();
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line1 length", (int)1, (int)out.getLength());
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line2 length", (int)2, (int)out.getLength());
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line3 length", (int)0, (int)out.getLength());
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line4 length", (int)3, (int)out.getLength());
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)4, (int)out.getLength());
        in.readLine(out);
        TestMRKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)5, (int)out.getLength());
        TestMRKeyValueTextInputFormat.assertEquals((String)"end of file", (int)0, (int)in.readLine(out));
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, Job job) throws IOException, InterruptedException {
        ArrayList<Text> result = new ArrayList<Text>();
        Configuration conf = job.getConfiguration();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(conf);
        RecordReader reader = format.createRecordReader(split, MapReduceTestUtil.createDummyMapTaskAttemptContext(conf));
        MapContextImpl mcontext = new MapContextImpl(conf, context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
        reader.initialize(split, (TaskAttemptContext)mcontext);
        while (reader.nextKeyValue()) {
            result.add(new Text((Text)reader.getCurrentValue()));
        }
        return result;
    }

    public static void testGzip() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)conf);
        localFs.delete(workDir, true);
        TestMRKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestMRKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        Job job = new Job(conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        List splits = format.getSplits((JobContext)job);
        TestMRKeyValueTextInputFormat.assertEquals((String)"compressed splits == 2", (int)2, (int)splits.size());
        FileSplit tmp = (FileSplit)splits.get(0);
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits.set(0, splits.get(1));
            splits.set(1, tmp);
        }
        List<Text> results = TestMRKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(0), job);
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0] length", (int)6, (int)results.size());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][0]", (String)"the quick", (String)results.get(0).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][1]", (String)"brown", (String)results.get(1).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][2]", (String)"fox jumped", (String)results.get(2).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][3]", (String)"over", (String)results.get(3).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][4]", (String)" the lazy", (String)results.get(4).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[0][5]", (String)" dog", (String)results.get(5).toString());
        results = TestMRKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(1), job);
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[1] length", (int)2, (int)results.size());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[1][0]", (String)"this is a test", (String)results.get(0).toString());
        TestMRKeyValueTextInputFormat.assertEquals((String)"splits[1][1]", (String)"of gzip", (String)results.get(1).toString());
    }

    public static void main(String[] args) throws Exception {
        new TestMRKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
    }
}

